# $Id: cosmosmash.spec.in,v 1.10 2002/12/27 02:52:47 sarrazip Exp $
# Spec file for cosmosmash

# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .bz2 source archive, give the command
#   rpm -tb --define 'srcext .bz2' cosmosmash-1.3.tar.bz2
#
%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif

Summary: Clone of the Intellivision(TM) game Astrosmash(TM). 
Name: cosmosmash
Version: 1.3
Release: %{rel}
Copyright: GPL
Group: Amusements/Games
Source: %{name}-%{version}.tar%{srcext}
URL: http://sarrazip.com/dev/%{name}.html
Packager: Pierre Sarrazin
Prefix: /usr
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires: gengameng	>= 4.0
Requires: SDL		>= 1.2.4
Requires: SDL_image	>= 1.2.2
Requires: SDL_mixer	>= 1.2.4
BuildRequires: gengameng-devel	>= 4.0
BuildRequires: SDL-devel	>= 1.2.4
BuildRequires: SDL_image-devel	>= 1.2.2
BuildRequires: SDL_mixer-devel	>= 1.2.4

%description
Clone of the Intellivision game Astrosmash.
In this game, you control a base that must destroy
rocks before they hit the ground, or you lose points.
You must also prevent "spinners" from touching the ground,
or your base will explode.

This package installs an entry in the GNOME 1.x Games menu.

%description -l fr
Clone du jeu Astrosmash de l'Intellivision.
Dans ce jeu, vous contrlez une base qui doit dtruire
des rochers avant qu'il n'atteignent le sol, sinon vous
perdez des points.  Vous devez aussi empcher des "spinners"
de toucher le sol sinon votre base va exploser.

Ce paquet installe une entre dans le menu Jeux de GNOME 1.x.

%prep
%setup

%build
./configure --prefix=%{prefix} --with-desktop-entry \
	&& make CXXFLAGS="-DNDEBUG -O2"

%install
rm -fR $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -fR $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%{prefix}/bin/*
%{prefix}/share/pixmaps/*
%{prefix}/share/sounds/*
%{prefix}/man/man*/*
%{prefix}/share/gnome/apps/*/*
