/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	send_mail.c	display a little information window		*/
/*									*/
/************************************************************************/

#include	<stdio.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/textsw.h>

#include	"manifest.h"
#include	"contool_ui.h"

#define		VERSION			"3.3a"

PUBLIC	contool_base_objects	*contool_base;

PRIVATE	contool_mail_objects	*dialog = NULL;

/************************************************************************/
EXPORT	popup_send_mail(item, event)

Panel_item	item;
Event		*event;

{
	if (dialog == NULL) {
	   dialog = contool_mail_objects_initialize(NULL, contool_base->base);
	   place_dialog(contool_base->base, dialog->mail);
	   xv_set(dialog->other_address, WIN_SHOW, FALSE, NULL);
	   }
	xv_set(dialog->mail, XV_SHOW, TRUE, NULL);
	xv_set(item, PANEL_NOTIFY_STATUS, XV_OK, 0);
}

/************************************************************************/
EXPORT	Menu	handle_address(menu, op)

Menu_item	menu;
Menu_generate	op;

{	char	*addr;

	if (op == MENU_NOTIFY) {
	   addr = (char *) xv_get(menu, MENU_STRING);
	   xv_set(dialog->other_address, WIN_SHOW, strcmp(addr, "Other:") == 0, NULL);
	   xv_set(dialog->fixed_address, PANEL_LABEL_STRING, addr, NULL);
	   panel_paint(dialog->other_address, PANEL_CLEAR);
	   panel_paint(dialog->fixed_address, PANEL_CLEAR);
	   }
	xv_set(menu, MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	xv_set(xv_get(menu, MENU_PARENT), MENU_NOTIFY_STATUS, XV_ERROR, NULL);
	return(menu);
}

/************************************************************************/
EXPORT	void	done_mail(frame)

Frame		frame;

{
	textsw_reset(dialog->message, 0, 0);
	xv_set(frame, XV_SHOW, FALSE, 0);
}

/************************************************************************/
EXPORT	void	send_mail(item, event)

Panel_item	item;
Event		*event;

{	char	cmd[1024], *buf;
	int	val, size;
	FILE	*pipe;

	xv_set(item, PANEL_NOTIFY_STATUS, XV_ERROR, 0);
	buf = (char *) xv_get(dialog->fixed_address, PANEL_LABEL_STRING);
	if (strcmp(buf, "Other:") != 0)
	   sprintf(cmd, "%s %s", MAILER, buf);
	else {
	   buf = (char *) xv_get(dialog->other_address, PANEL_VALUE);
	   if (is_empty(buf)) {
	      error("You must specify an alternate address before sending your message");
	      return;
	      }
	   else
	      sprintf(cmd, "%s %s", MAILER, buf);
	   }
	size = (int) xv_get(dialog->message, TEXTSW_LENGTH);
	if (size == 0) {
	   error("Please type a message before sending the mail");
	   return;
	   }
	if ((pipe = popen(cmd, "w")) == NULL) {
	   error("Could not invoke \"%s\" to send mail", cmd);
	   return;
	   }
	lets_get_busy(contool_base->base, TRUE, NULL);
	buf = (char *) malloc(size);
	xv_get(dialog->message, TEXTSW_CONTENTS, 0, buf, size);
	fprintf(pipe, "Subject: Contool %s comment\n\n", VERSION);
	if (fwrite(buf, 1, size, pipe) != size) {
	   error("Could not write message to the mailer");
	   free(buf);
	   return;
	   }
	pclose(pipe);
	free(buf);
	textsw_reset(dialog->message, 0, 0);
	lets_get_busy(contool_base->base, FALSE, NULL);
	xv_set(item, PANEL_NOTIFY_STATUS, XV_OK, 0);
}
