/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	place_dialog.c	position a dialog box at the right place	*/
/*									*/
/************************************************************************/

#include	<stdio.h>

#include	<xview/xview.h>
#include	<X11/Xutil.h>

#include	"manifest.h"

/************************************************************************/
EXPORT	void	place_dialog(base, dialog)

Xv_opaque	base;
Xv_opaque	dialog;

{	Rect		br, dr, sr;
	XWMHints	*hints;

	sr = *((Rect *) xv_get(base, WIN_SCREEN_RECT));
	frame_get_rect(base, &br);
	frame_get_rect(dialog, &dr);
	if (rect_right(&br) + dr.r_width < sr.r_width) {
	   dr.r_left = rect_right(&br);
	   dr.r_top = br.r_top;
	   }
	else if (dr.r_width <= br.r_left) {
	   dr.r_left = br.r_left - dr.r_width;
	   dr.r_top = br.r_top;
	   }
	else {
	   dr.r_left = br.r_left + 32;
	   dr.r_top = br.r_top + 32;
	   }
	if (dr.r_top + dr.r_height > sr.r_height)
	   dr.r_top = sr.r_height - dr.r_height;
	if (dr.r_top < 0)
	   dr.r_top = 0;
	if (rect_right(&dr) > sr.r_width)
	   dr.r_left = sr.r_width - dr.r_width;
	if (dr.r_left < 0)
	   dr.r_left = 0;
	frame_set_rect(dialog, &dr);

	hints = XGetWMHints((Display *) xv_get(dialog, XV_DISPLAY), xv_get(dialog, XV_XID));
	hints->flags |= StateHint;
	hints->initial_state = NormalState;
	XSetWMHints((Display *) xv_get(dialog, XV_DISPLAY), xv_get(dialog, XV_XID), hints);
	XFree((void *) hints);
}

