/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

#include	<stdio.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<stdlib.h>
#include	<string.h>
#include	<pwd.h>
#include	<errno.h>

#include	"manifest.h"
#include	"contool.h"

#ifndef	SVR4

#define		L_POS		8
#define		D_POS		9

#define		MASTER_PATH	"/dev/ptyp0"
#define		SLAVE_PATH	"/dev/ttyp0"
#define		LETTERS		"pqrstu"
#define		DIGITS		"0123456789abcdef"

/************************************************************************/
EXPORT	void	open_psuedo_tty(master, slave)

int	*master;
int	*slave;

{	char	*s, *t;
	static	char master_path[12], slave_path[12];

	strcpy(master_path, MASTER_PATH);
	strcpy(slave_path, SLAVE_PATH);
	*master = *slave = -1;
	for (s = LETTERS; *s && *master == -1; s++) {
	   master_path[L_POS] = *s;
	   slave_path[L_POS] = *s;
	   for (t = DIGITS; *t && *master == -1; t++) {
	      master_path[D_POS] = *t;
	      slave_path[D_POS] = *t;
	      if ((*master = open(master_path, O_RDONLY)) == -1 || (*slave = open(slave_path, O_WRONLY)) == -1) {
	         if (*master != -1)
	            close(*master);
	         if (*slave != -1)
	            close(*slave);
	         *master = *slave = -1;
		 if (errno == EINTR) /* retry interrupted opens */
		    t--;
	         }
	      }
	   }
}

#endif

/************************************************************************/
EXPORT	char	*expand_tilde(path)

char	*path;

{	char	s[1024], *p;
	struct	passwd	*pw;

	if (*path == '~') {
	   if (path[1] == '/' || path[1] == '\0') {
	      strcpy(s, getenv("HOME"));
	      strcat(s, path + 1);
	      }
	   else {
	      if ((p = strchr(path, '/')) != NULL)
	         *p = '\0';
	      if ((pw = getpwnam(path + 1)) != NULL) {
	         strcpy(s, pw->pw_dir);
	         if (p != NULL) {
	            strcat(s, "/");
	            strcat(s, p + 1);
	            }
	         }
	      else {
	         if (p != NULL)
	            *p = '/';
	         strcpy(s, path);
	         }
	      }
	   return(strsave(s));
	   }
	else
	   return(strsave(path));
}

/************************************************************************/
EXPORT	int	is_empty(s)

char	*s;

{
	if (s == NULL)
	   return(TRUE);
	for (; *s; s++)
	   if (!isspace(*s))
	      return(FALSE); 
	return(TRUE);
}

/************************************************************************/
EXPORT	char	*check_escapes(s)

char	*s;

{	static	char	buf[1024];
	char	*p;

	for (p = buf; *s; s++, p++)
	   if (*s == '"') {
	      *p++ = '"';
	      *p = *s;
	      }
	   else
	      *p = *s;
	*p = '\0';
	return(buf);
}
