/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	logging.c	message log management				*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#ifdef	SVR4
#include	<sys/systeminfo.h>
#else
#define		sysinfo(op, buf, len)		gethostname(buf, len)
#endif

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/xv_xrect.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

PUBLIC	Menu_item	start_logging();
PUBLIC	Menu_item	stop_logging();

PUBLIC	contool_base_objects	*contool_base;

PRIVATE	int	logging = FALSE;
PRIVATE	FILE	*logfile = NULL;
PRIVATE	char	*log_path = NULL;

/************************************************************************/
EXPORT	void	disable_logging()

{
	if (logging) {
	   fclose(logfile);
	   cond_free(log_path);
	   log_path = NULL;
	   logging = FALSE;
	   }
	xv_set(contool_base->base, FRAME_RIGHT_FOOTER, "", NULL);
}

/************************************************************************/
EXPORT	void	enable_logging()

{	char	buf[1024];

	if (logging) {
	   if (log_path && strcmp(log_path, defaults.log_file) == 0)
	      return;
	   disable_logging();
	   }
	if (is_empty(defaults.log_file))
	   error("You must specify a log file in the Properties dialog");
	else if ((logfile = fopen(defaults.log_file, "a")) == NULL)
	   error("Cannot open log file %s : %s", defaults.log_file, sys_errlist[errno]);
	else {
	   logging = TRUE;
	   log_path = strsave(defaults.log_file);
	   sprintf(buf, "Logging to %s...", defaults.log_file);
	   xv_set(contool_base->base, FRAME_RIGHT_FOOTER, buf, NULL);
	   }
}

/************************************************************************/
EXPORT	Menu_item	start_logging(item, op)

Menu_item	item;
Menu_generate	op;

{	contool_base_objects	*ip = (contool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, logging, NULL);
	else if (op == MENU_NOTIFY)
	   enable_logging();
	return item;
}

/************************************************************************/
EXPORT	Menu_item	stop_logging(item, op)

Menu_item	item;
Menu_generate	op;

{	contool_base_objects	*ip = (contool_base_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	if (op == MENU_DISPLAY)
	   xv_set(item, MENU_INACTIVE, !logging, NULL);
	else if (op == MENU_NOTIFY)
	   disable_logging();
	return item;
}

/************************************************************************/
EXPORT	update_logging()

{
	if (logging) {
	   disable_logging();
	   enable_logging();
	   }
}

/************************************************************************/
EXPORT	write_log(s)

char	*s;

{	time_t	t;
	static	char	*hostname = NULL;
	char	*p, buf[100];

	if (logging) {
	   if (hostname == NULL) {
	      if ((p = getenv(CONTOOL_LOGNAME)) == NULL)
	         if (sysinfo(SI_HOSTNAME, buf, 99) != 0)
	            p = "(unknown)";
	         else
	            p = buf;
	      hostname = strsave(p);
	      }
	   t = time(0);
	   fseek(logfile, 0L, 2);
	   fprintf(logfile, "%s\t%.16s\t%s", hostname, ctime(&t) + 4, s);
	   fflush(logfile);
	   }
}
