/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>

#include	<sys/file.h>

#include	<xview/xview.h>
#include	<xview/icon_load.h>

#include	"manifest.h"

#if !defined(ICON_PATH)
#define		ICON_PATH		".:./icons:/usr/local/images:/usr/include/images"
#endif

/************************************************************************/
PRIVATE	short	*load_as_icon(path, width, height, depth)

char	*path;
int	*width;
int	*height;
int	*depth;

{	Pixrect	*pr;
	char	error_msg[IL_ERRORMSG_SIZE];

	if ((pr = icon_load_mpr(path, error_msg)) == NULL)
	   return(NULL);
	else {
	   *width = pr->pr_width;
	   *height = pr->pr_height;
	   *depth = pr->pr_depth;
	   return((short *)((struct mpr_data *)pr->pr_data)->md_image);
	   }
}

/************************************************************************/
PRIVATE	short	*load_as_sunraster(path, width, height, depth)

char	*path;
int	*width;
int	*height;
int	*depth;

{
	return(NULL); /* :-( */
}

/************************************************************************/
PRIVATE	Server_image	load_image(path, msg)

char	*path;
char	*msg;

{	int	width, height, depth;
	short	*data;
	Server_image	result;

	if (access(path, R_OK) != 0) {
	   sprintf(msg, "cannot access bitmap file %s: %s", path, sys_errlist[errno]);
	   return((Server_image) NULL);
	   }

	if ((data = load_as_icon(path, &width, &height, &depth)) || (data = load_as_sunraster(path, &width, &height, &depth))) {
	   if (depth != 1) {
	      sprintf(msg, "image contained in %s has depth greater than 1", path);
	      return((Server_image) NULL);
	      }
	   result = (Server_image) xv_create((Frame) NULL, SERVER_IMAGE,
	   				        SERVER_IMAGE_BITS, data,
					        XV_WIDTH, width,
					        XV_HEIGHT, height,
					     NULL);
	   }
	else {
	   result = (Server_image) xv_create((Frame) NULL, SERVER_IMAGE,
	   				        SERVER_IMAGE_BITMAP_FILE, path,
	   				     NULL);
	   if (result == (Server_image) NULL)
	      sprintf(msg, "unrecognized image format in %s", path);
	   }

	return(result);
}

/************************************************************************/
EXPORT	Server_image	load_icon(path, message)

char	*path;
char	*message;

{	char	*icon_path, new_path[1024], *p, *q;

	if (*path == '/')
	   return(load_image(path, message));
	else {
	   if ((p = getenv("ICON_PATH")) != NULL)
	      icon_path = strsave(p);
	   else
	      icon_path = strsave(ICON_PATH);
	   for (p = icon_path; *p; ) {
	      if (q = strchr(p, ':'))
	         *q = '\0';
	      strcpy(new_path, p);
	      strcat(new_path, "/");
	      strcat(new_path, path);
	      if (access(new_path, R_OK) == 0) {
	         free(icon_path);
	         return(load_image(new_path, message));
	         }
	      else if (q != NULL)
	         p = q + 1;
	      else
	         break;
	      }
	   free(icon_path);
	   return(load_image(path, message));
	   }
}
