/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

#define		RETURN(x)		return(last_token = (x))

#define		FIRST_KEYWORD		ARCHIVE
#define		LAST_KEYWORD		YES
#define		NUM_KEYWORDS		(LAST_KEYWORD - FIRST_KEYWORD + 1)

PRIVATE	FILE	*f = NULL;
PRIVATE	int	last_token = -1;
PRIVATE	char	buf[1024];

PRIVATE	struct	{char	*name;
		 int	value;
		} token[] = {{"archive",              ARCHIVE},
			     {"beep",                 BEEP},
			     {"check_icon",           CHECK_ICON},
			     {"check_icon_mask",      CHECK_ICON_MASK},
			     {"command",              COMMAND},
			     {"comment",              COMMENT},
			     {"defaults",             DEFAULTS},
			     {"delete",               DELETE},
			     {"display",              DISPLAY},
			     {"filters",              FILTERS},
			     {"flash",                FLASH},
			     {"flash_icon",           FLASH_ICON},
			     {"flash_icon_mask",      FLASH_ICON_MASK},
			     {"good_icon",            GOOD_ICON},
			     {"good_icon_mask",       GOOD_ICON_MASK},
			     {"ignore",               IGNORE},
			     {"log",                  LOG},
			     {"log_before_filtering", LOG_BEFORE_FILTERING},
			     {"log_file",             LOG_FILE},
			     {"match",                MATCH},
			     {"no"     ,              NO},
			     {"noflash",              NOFLASH},
			     {"noopen",               NOOPEN},
			     {"nostamp",              NOSTAMP},
			     {"open",                 OPEN},
			     {"print",                PRINT},
			     {"quiet",                QUIET},
			     {"save",                 SAVE},
			     {"stamp",                STAMP},
			     {"timeout",              TIMEOUT},
			     {"timestamp",            TIMESTAMP},
			     {"to",                   TO},
			     {"version",              VERSION},
			     {"yes",                  YES}};

PRIVATE	struct	{char	first;
		 char	next;
		 int	name;
		} punc[] = {{'{',  '\0', LBRACE},
			    {'}',  '\0', RBRACE},
			    {'\0', '\0', -1}};

/************************************************************************/
EXPORT	int	lex_init(path)

char	*path;

{
	if (f)
	   fclose(f);
	if (f = fopen(path, "r")) {
	   curr_file = strsave(path);
	   line_count = 1;
	   lastc = -1;
	   parse_errors_occured = 0;
	   return(TRUE);
	   }
	else
	   return(FALSE);
}

/************************************************************************/
PRIVATE	char	getch()

{	register	char	c;
	static		int	first = TRUE;

	if (lastc != -1)
	   c = lastc, lastc = -1;
	else {
	   c = getc(f);
	   if (c == '\n')
	      line_count++;
	   }
	return(c);
}

/************************************************************************/
PRIVATE	int	is_keyword(s)

char	*s;

{	register	int	cmp, high, low, pos;

	for (low = 0, high = NUM_KEYWORDS - 1; low <= high; )
	   if ((cmp = strcmp(s, token[pos = (high - low) / 2 + low].name)) == 0)
	      return(token[pos].value);
	   else if (cmp < 0)
	      high = pos - 1;
	   else
	      low = pos + 1;
	return(0);
}

/************************************************************************/
PRIVATE	int	yylex()

{	register	char	c, c1, *p;
	register	int	i, j, val;
	double			atof();

	c = getch();
	while (isspace(c))
	   c = getch();
	if (isalpha(c)) {
	   p = buf;
	   *p++ = c;
	   while (isalnum(c = getch()) || c == '_')
	      *p++ = c;
	   lastc = c;
	   *p = '\0';
	   for (p = buf; *p; p++)
	      if (isupper(*p))
	         *p = tolower(*p);
	   if (i = is_keyword(buf))
	      RETURN(i);
	   else {
	      yyerror("unexpected keyword: %s", buf);
	      fclose(f);
	      f = NULL;
	      RETURN(EOF);
	      }
	   }
	else if (c == '"' || c == '\'') {
	   for (p = buf; TRUE; p++)
	      if ((*p = getch()) == c) {
	         if ((c1 = getch()) != c) {
	            lastc = c1;
	            break;
	            }
	         }
	      else if (*p == '\\' && filter_version < 310)
	         *p = getch();
	      else if (*p == '\n' || *p == '\r') {
	         yyerror("Newline in string not allowed");
	         break;
	         }
	   *p = '\0';
	   yylval.cpval = strsave(buf);
	   RETURN(STRING);
	   }
	else if (isdigit(c)) {
	   p = buf;
	   *p++ = c;
	   while (isdigit(c = getch()))
	      *p++ = c;
	   *p = '\0';
	   lastc = c;
	   yylval.ival = atoi(buf);
	   RETURN(INTEGER);
	   }
	else if (c == '#') {
	   while ((c = getch()) != '\n' && c != EOF)
	      ;
	   if (c == EOF) {
	      fclose(f);
	      f = NULL;
	      RETURN(EOF);
	      }
	   else
	      RETURN(yylex());
	   }
	else if (c == EOF) {
	   fclose(f);
	   f = NULL;
	   RETURN(EOF);
	   }
	else {
	   for (i = 0; punc[i].first; i++)
	      if (c == punc[i].first) {
	         for (c1 = getch(), j = 1; punc[i + j].first == c; j++)
	            if (c1 == punc[i + j].next)
	               RETURN(punc[i + j].name);
	         lastc = c1;
	         RETURN(punc[i].name);
	         }
	   yyerror("Invalid character in source file: %c (0x%02x)", c, c);
	   }
	RETURN(yylex());
}

/************************************************************************/
PRIVATE	char	*get_last_token()

{	int	i;
	static	char	msg[512];

	if (last_token == INTEGER || last_token == STRING)
	   sprintf(msg, "\"%s\"", buf);
	else if (last_token >= LBRACE && last_token <= RBRACE) {
	   for (i = 0; punc[i].first; i++)
	      if (punc[i].name == last_token) {
	         sprintf(msg, "\"%c\"", punc[i].first);
	         if (punc[i].next)
	            sprintf(msg + 2, "%c\"", punc[i].next);
	         break;
	         }
	   if (punc[i].first == '\0')
	      sprintf(msg, "!!Geez!  Some punctuation, I don't know!!");
	   }
	else if (last_token >= FIRST_KEYWORD && last_token <= LAST_KEYWORD)
	   sprintf(msg, "\"%s\"", token[last_token - FIRST_KEYWORD].name);
	else if (last_token == EOF)
	   sprintf(msg, "End Of File");
	else
	   sprintf(msg, "!!Geez!  Some keyword, I don't know!!");
	return(msg);
}
