/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	filename_completion.c	completion handler for text items	*/
/*									*/
/************************************************************************/

#include	<stdio.h>

#include	<xview/xview.h>
#include	<xview/panel.h>

#include	"manifest.h"

/************************************************************************/
EXPORT	Panel_setting	filename_completion(item, event)

Panel_item	item;
Event		*event;

{	char	*p, *expand_filename();

	switch (event_action(event)) {
	   case '\n' :
	   case '\r' : 
	   case ' '  : if ((p = expand_filename((char *) xv_get(item, PANEL_VALUE))) == NULL)
	   		  window_bell(xv_get(item, XV_OWNER));
	   	       else
	   	          xv_set(item, PANEL_VALUE, p, 0);
	   	       event_set_id(event, '\n');
	   	       return(PANEL_NONE);
	   case '\t' : return(event_shift_is_down(event)? PANEL_PREVIOUS : PANEL_NEXT);
	   default   : return(panel_text_notify(item, event));
	   }
}
