/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

#include	<dirent.h>
#include	<pwd.h>
#include	<stdlib.h>
#include	<string.h>

#include	"manifest.h"

/************************************************************************/
PRIVATE	char	*root_path(path)

char	*path;

{	char	*p;

	if (p = strrchr(path, '/'))
	   if (p == path)
	      p[1] = '\0';
	   else
	      *p = '\0';
	else
	   *path = '\0';
	return(path);
}

/************************************************************************/
PRIVATE	char	*last_node(path)

char	*path;

{	char	*p;

	return((p = strrchr(path, '/'))? p + 1 : path);
}

/************************************************************************/
EXPORT	char	*expand_filename(path)

char	*path;

{	static	char	s[1024];
	char	pattern[1024], candidate[1024], *p,*q;
	DIR	*dir;
	struct	dirent *dp;
	struct	passwd	*pw;

	strcpy(s, path);
	if (*path == '~')
	   if (path[1] == '/' || path[1] == '\0') {
	      strcpy(s, getenv("HOME"));
	      strcat(s, path + 1);
	      }
	   else {
	      if ((p = strchr(path, '/')) != NULL)
	         *p = '\0';
	      if ((pw = getpwnam(path + 1)) != NULL) {
	         strcpy(s, pw->pw_dir);
	         if (p != NULL) {
	            strcat(s, "/");
	            strcat(s, p + 1);
	            }
	         }
	      else
	         return(NULL);
	      }
	strcpy(pattern, last_node(s));
	if (*pattern == '\0')
	   return(s);
	root_path(s);
	candidate[0] = '\0';
	if (*s == '\0')
	   strcpy(s, ".");
	if ((dir = opendir(s)) == NULL) {
	   strcpy(s, path);
	   return(s);
	   }
	while ((dp = readdir(dir)) != NULL)
	   if (strncmp(dp->d_name, pattern, strlen(pattern)) == 0)
	      if (*candidate == '\0')
	         strcpy(candidate, dp->d_name);
	      else {
	         for (p = candidate, q = dp->d_name; *p == *q; p++, q++)
	            ;
	         *p = '\0';
	         }
	closedir(dir);
	if (*candidate == '\0')
	   return(NULL);
	else {
	   if (strcmp(s, ".") == 0)
	      *s = '\0';
	   else if (s[strlen(s) - 1] != '/')
	      strcat(s, "/");
	   strcat(s, candidate);
	   }
	return(s);
}
