.TH CONTOOL 1 "24 February 1994"
.SH NAME
contool \- capture and display console output
.SH SYNOPSIS
contool [\fB\(hyc\fP \fIfile\fP] [\fB\(hyf\fP] [\fB\(hyi\fP \fIinput\fP] [\fB\(hyl\fP] [\f3\(hyL\fP \f2logfile\fP] [\f3\(hyn\fP]
.SH DESCRIPTION
.LP
\f2Contool\fP captures and displays any messages sent to the system console.
Each message is timestamped as it arrives.  The messages are displayed in a
scrolling text window, so the user can scroll through old messages.
.LP
When a message arrives, \f3contool\fP will beep and, if closed, begin
blinking its icon until the user opens the tool.  This behavior can be changed
by modifying the default contool properties.
.LP
\f2Contool\fP must be run under either Open Windows or X Windows.
It accepts the standard Open Windows command line options.
.SH OPTIONS
.IP "\fB\\(hyc\fP \fIfile\fP"
specifies an alternate configuration file.  \f2Contool\fP normally
reads its configuration information from the path specified in
the CONTOOL_FILTERS environment variable or, if CONTOOL_FILTERS
is not defined, from ~/.contool.
.IP "\fB\\(hyf\fP"
forces \f2contool\fP to fork itself into the background after 
acquiring the console.  This option is most useful when starting
\f2contool\fP from your ~/.xinitrc or ~/.openwin-init file, where
multiple tools are started in the background.  Even if \f2contool\fP is
started first, other tools may begin running and produce error
messages before \f2contool\fP can acquire the console.  By using the
\fB-f\fP option you can start \f2contool\fP in the foreground,
preventing other tools from starting until \f2contool\fP has acquired
the console.
.IP "\fB\\(hyi\fP \fIinput\fP"
specifies an alternate input source.  \f2Contool\fP normally reads
messages from the system console.  If \fB-i\fP is used, \f2contool\fP
will read messages from the specified \fIinput\fP.  \fIInput\fP must
be the pathname of a either a FIFO, or a character special device like
/dev/tty.  \fIInput\fP can also be given as \*(lq-\*(rq, indicating
that contool should read messages from its standard input.
.IP "\fB\\(hyl\fP"
enables logging when \f2contool\fP starts.  Initially, \f2contool\fP
does not log messages to a file.  This option allows logging to be started
automatically.  Logging behavior can be enabled and disabled via the
\*(lqFile\*(rq menu (see below).
.IP "\fB\\(hyL\fP \fIlogfile\fP"
specifies an alternate log file.  The value of \fIlogfile\fP overrides
any log file stored in the configuration file.  The \fB-l\fP and \fB-L\fP
options used together allow multiple copies of contool to be started on 
a single machine, with each copy logging to a different file, without
having to create and maintain multiple configuration files.
.IP "\fB\\(hyn\fP"
prevents \f2contool\fP from acquiring the console when it starts.  This
is most useful when testing a new version of contool, so that the test
copy does not interfere with any previously running console tool.
.SH USER INTERFACE
.LP
\f2Contool\fP presents the user with a control panel containing three
buttons and a scrolling text window.  Console messages appear in the
text window; \f2contool\fP's behavior is managed with the \fBFile\fP,
\fBView\fP, and \fBEdit\fP buttons.  These buttons have several menu choices
associated with them:
.IP "\fBFile: Load Configuration...\fP"
brings up the \fBLoad Configuration\fP dialog box.  This dialog contains
a non-exclusive setting, a text field, and a single \fBLoad\fP button.
The setting has two entries: \*(lqTool Properties\*(rq and \*(lqFilter
Definitions\*(rq.  The user can choose which of these items to load from
the configuration file.  The default action is to load both properties and
filters from the file.
.IP ""
The text field contains the path of the configuration file.  By default,
this is either the value of the \fB-c\fP option (above), the value of the
CONTOOL_FILTERS environment variable, or ~/.contool.
This text field provides file name completion, like \f2csh\fP(1), by typing
a space or carriage return.
.IP ""
After determining which components to be read from the file, and the name of
the file, clicking on the \fBLoad\fP button will cause the desired elements
to be read from the file.  If filters are loaded, any existing filters are
discarded.  If \f2contool\fP was in the middle of filtering a multi-line message,
that filtering action is terminated.
.IP ""
\f2Contool\fP can read files created by all previous versions of
\f2contool\fP.  Files written by \f2contool\fP cannot be read by any previous
version.
.IP "\fBFile: Save Configuration...\fP"
is analogous to the \fBLoad Configuration\fP operation, bringing up a dialog
box containing a non-exclusive setting, a text field, and a \fBSave\fP
button.  In the same manner as the \fBLoad Configuration\fP dialog, the
user indiactes which items he desires to save, specifies the destination
file, and clicks on the \fBSave\fP button to save the information.
.IP ""
\f2Contool\fP writes the data in a format incompatible with previous
versions (release 3.0 or earlier) of the tool.
.IP "\fBFile: Start Logging\fP"
starts logging console messages to the log file specified by the tool
properties, or the \fB-L\fP option (above).  The tool properties also
contains a switch which determines whether messages are written before
or after filtering occurs.  If before, all messages are logged.  If after,
a message is written to the log if it does not match a filter and the default
action in the tool properties has \*(lqLog message\*(rq enabled; or if it
matches a filter with both the \*(lqSave\*(rq and \*(lqLog message\*(rq 
attributes set.
.IP ""
The log file is written in such a manner that multiple invocations of
\f2contool\fP can write to the same log file without conflict.  New 
messages are always appended to the log file.  Log files can be forcibly
flushed with a SIGHUP; see SIGNALS, below.
.IP "\fBFile: Stop Logging\fP"
stops the logging process.
.IP "\fBFile: Print\fP"
uses the \*(lqPrint Filter\*(rq specified in the tool properties to 
print the contents of the console.  Only messages saved in the console
can be printed.
.IP "\fBFile: About Contool...\fP"
provides a brief history of \f2contool\fP, and allows users to send
e-mail to the contool developer.
.IP "\fBView: Archive...\fP"
opens the message archive dialog box.  This dialog box displays a 
scrolling window containing all messages archived from the main 
console display.  See MESSAGE ARCHIVE, below.
.IP "\fBView: Archive Messages\fP"
moves all the messages in the console display to the message archive.
This is a handy way to remove already viewed messages from the console
without losing them for later review.  By periodically moving 
messages to the archive, only the most recent messages will be
visible in the main console display.  Messages can be archived automatically
as well; see TOOL PROPERTIES, below.
.IP "\fBView: Become Console\fP"
ensures that \f2contool\fP has the system console attribute.  SunOS
allows exactly one process in the system to own the console.  If some
other process takes control of the console, the user can reassign the
console attribute to \f2contool\fP using this menu selection.
.IP "\fBView: Clear Messages\fP"
clears all messages from the console text display.
.IP "\fBView: Reset Filter\fP"
interrupts filtering of a multi-line filter.  If the user incorrectly
specifies the end pattern of a multi-line filter, \f2contool\fP may
never stop processing the filter, causing all subsequent console
messages to be incorrectly handled.  This selection resets the effect
of any multi-line filter that may be in effect.
.IP ""
When processing a multi-line filter, \f2contool\fP displays the
starting filter pattern in the left window footer.  If the left footer
is blank, \f2contool\fP is not processing a multi-line filter.
.IP "\fBEdit: Filters...\fP"
brings up the \fBFilters\fP dialog box.  See EDITING FILTERS, below.
.IP "\fBEdit: Properties...\fP"
brings up the \fBTool Properties\fP dialog box.  See TOOL PROPERTIES, below.
.SH EDITING FILTERS
The \fBFilters\fP dialog presents a scrolling list of filters and a variety of
devices used to modify the current filter set.  The items in this dialog are:
.IP "\fBFilters\fP"
This scrolling list shows the starting pattern of each filter currently used by
\f2contool\fP.  The pattern text is preceded by a small glyph indicating
whether the filter is a single-line or multi-line filter.
.IP ""
If exactly one item in the list is selected, the properties of that filter
will be displayed in the dialog box.  If no, or more than one, filter is
selected, the remainder of the dialog box is grayed out.
.IP "\fBInsert\fP"
This button inserts a new blank filter into the scrolling list, allowing
the user to add new filters to the filter set.  A menu attached to
the button allows the user to select the insert point: at the top of the
list, before the current selection, after the current selection, or at
the bottom of the list.  The \*(lqbefore\*(rq and \*(lqafter\*(rq
choices are only enabled if exactly one filter in the list is selected.
The default position is the bottom of the list.
.IP "\fBEdit\fP"
This button edits the currently selected filters in the list.  The
menu attached to this button has four choices: \fBCut\fP, \fBCopy\fP, \fBPaste\fP,
and \fBDelete\fP.
.IP ""
The \fBCut\fP operation removes the selected filters from the list
and places them on the clipboard, where they can subsequently be pasted
back into the list.
.IP ""
The \fBCopy\fP operation copies the selected filters to the clipboard.
The filters are not removed from the list.  The copied filters can subsequently
be pasted back into the list.
.IP ""
The \fBPaste\fP operation copies filters from the clipboard into the list.
This selection has a menu which specifies the paste position: at the top of the
list, before the current selection, after the current selection, or at
the bottom of the list.  The \*(lqbefore\*(rq and \*(lqafter\*(rq
choices are only enabled if exactly one filter in the list is selected.
The default position is the bottom of the list.
.IP ""
The \fBDelete\fP operation removes the selected filters from the list
without placing them on the clipboard.  Once deleted, filters cannot
be recovered with a paste operation.
.IP ""
The \fBCut\fP, \fBCopy\fP, and \fBDelete\fP selections are only presented
if one or more filters in the list are selected.  The \fBPaste\fP selection
is only available after a \fBCut\fP or \fBCopy\fP operation.
.IP "\fBUpdate\fP"
This button updates the currently selected filter using the values 
presented in the remainder of the dialog box.  This button is only
accessible if exactly one filter in the list is selected.
.IP ""
\fBUpdate\fP is used to modify an existing filter.  When just that filter
is selected, its attributes are placed into the other dialog elements
described below.  After adjusting the filter attributes, the user clicks
the \fBUpdate\fP button to apply the changes to the currently selected
filter.
.IP ""
In a similar manner, \fBUpdate\fP is used to apply attributes to a new,
blank filter placed in the list via the \fBInsert\fP button.
.IP "\fBType\fP"
The \fBType\fP toggle indicates whether a filter will match just a single
line message, or will match a multiple line message.  When \*(lqSingle
line filter\*(rq is chosen, the \fBEnd pattern\fP item is disabled,
and the user must specify the pattern which will match a single line of
text written to the console.  When \*(lqMulti-line filter\*(rq is
selected, the \fBEnd pattern\fP item is enabled, and the user needs to specify
both a starting and an ending pattern.  All text following a line which
matches the starting pattern, up to and including a line which matches the
ending pattern, is considered to be part of the filtered message.
.IP "\fBPattern\fP"
This text field specifies the regular expression which matches the first
(and, in the case of single line filters, the only) line of text in the
filtered message.  Any valid regular expression is permitted.  Users that
are trying to match some text exactly should be aware that regular
expressions can match text anywhere in a line, and that the expression
should be anchored to the start (or end) of the line by using the "^"
(or "$") metacharacters.  For more information on regular expressions,
see \f2ed\fP(1).
.IP ""
As a special extension to regular expressions, \f2contool\fP recognizes
a backslash (\*(lq\\\*(rq) followed by one or more octal digits as a single
character in the expression.  This allows non-printing characters, such as
control characters, to be inserted in the text pattern.  If a backslash is
followed by any other character, it is placed in the pattern verbatim.  Thus,
to create an expression which matches a control-G followed by a backslash, the
pattern \*(lq\\007\\\*(rq would suffice.
.IP "\fBEnd pattern\fP"
If the \fBType\fP is set to \*(lqMulti-line filter\*(rq, this field
must contain the regular expression which matches the last line of the
block of text handled by this filter.
.IP "\fBTimeout\fP"
If the \fBType\fP is set to \*(lqMulti-line filter\*(rq, this field
sets a limit on how long \f2contool\fP will process the filter.  This
prevents filters with erroneous end patterns from absorbing all console
output once they begin filtering.  The default value, 0, indicates that
no timeout is in effect.
.IP "\fBComment\fP"
This text field contains any comments regarding the filter the user
wishes to record.  Since some filters can be rather arcane, it is suggested
that users comment their filters.
.IP "\fBWhen matched\fP"
This exclusive setting dictates the behavior of \f2contool\fP when a
filter is matched.  If \*(lqSave message\*(rq is chosen, the message
is copied into the console display, and various actions can be taken.
If \*(lqIgnore message\*(rq is selected, the filter text is discarded
and no further actions are taken by \f2contool\fP.
.IP "\fBWhen saved\fP"
If \fBWhen matched\fP is set to \*(lqSave message\*(rq, this non-exclusive
choice item will be enabled, allowing the user to specify what contool
should do with this message.
.IP ""
The \*(lqBeep\*(rq choice causes the terminal bell to be sounded.  If
selected, the beep counter to the right of this item is enabled, allowing
the user to choose anywhere from one brief beep up to 99 annoying beeps.
.IP ""
The \*(lqCommand\*(rq choice causes a single command to be executed.
The text field to the right of this item must contain the command to
be executed.  \f2Contool\fP will write the text of the message to the
standard input of the command.  For example, using \*(lqmail -s 'Contool
output' user\*(rq as the command would mail the message text to the
\f2user\fP.
.IP ""
The \*(lqFlash icon\*(rq choice causes the \f2contool\fP icon to flash,
alternating between the \*(lqCheck console\*(rq and \*(lqFlash\*(rq
icons.
.IP ""
The \*(lqLog message\*(rq choice causes the message to be written to
the message log, if logging is enabled and is performed after filtering.
.IP ""
The \*(lqOpen window\*(rq choice causes \f2contool\fP to open from
its iconic state, and to move in front of any obscuring windows.
.IP ""
The \*(lqTimestamp\*(rq choice causes \f2contool\fP to write a timestamp
to the console before copying the message into the console.  The timestamp
is written in conjunction with the timestamp resolution specified in the
\fBTool Properties\fP dialog.
.IP "\fBApply\fP"
This button makes the filters contained in the scrolling list the current
set of active filters.  Until this button is clicked, all changes made to
the filters are not used by \f2contool\fP.  After clicking \fBAccept\fP,
the changed filters become the current working set.
.IP ""
Note that even after clicking \fBAccept\fP, the configuration file is
not updated.  To make the changes permanent between invocations of
\f2contool\fP, press the \fBApply and Save\fP button, or use the \fBSave Configuration\fP
dialog to save the changed filters.
.IP "\fBApply and Save\fP"
This button makes the filters in the scrolling list the current set of
active filters and writes those filters and the tool properties to the
current configuration file.  To write the filters to a different file, or
to write just the filters without the tool properties, press the \fBApply\fP
button and use the \fBSave Configuration\fP dialog instead.
.IP "\fBReset\fP"
This button discards any changes made to the current filter set, 
restoring the filter list to match the current filter set in use
by \f2contool\fP.
.SH TOOL PROPERTIES
The \fBTool Properties\fP dialog allows the user to change the default behavior
of \f2contool\fP.  This includes various tool attributes, and the 
actions taken when a message arrives which does not match any filter.
The various properties include:
.IP "\fBDefault action\fP"
This non-exclusive setting determines the actions taken by \f2contool\fP
when a message arrives which does not match any filter.  The various
choices in this setting exactly correspond to the \fBWhen saved\fP
setting the \fBFilters\fP dialog, above.
.IP "\fBLog file\fP
This text field contains the path of the file to which messages will
be logged.  This field must be filled in before logging is enabled.
.IP "\fBLog messages\fP"
If this exclusive setting is set to \*(lqbefore filtering\*(rq, all
messages will be logged.  If set to \*(lqafter filtering\*(rq, 
messages that match filters whose \*(lqWhen matched\*(rq behavior is
set to \*(lqIgnore message\*(rq will not be logged.
.IP "\fBArchive messages\fP"
This exclusive setting determines how messages will be moved from the
main console display to the message archive.  If set to
\*(lqManually\*(rq, messages will only be archived when the user selects
\fBArchive Messages\fP from the \fBView\fP menu in the main \f2contool\fP
window.  If set to \*(lqWhen closing contool\*(rq, messages are copied to
the archive whenever the \f2contool\fP window is closed.  This mode assumes that
you typically open \f2contool\fP, read all the messages, and close the window.
Each time you open the window, you'll only see messages that have arrived
since you last closed \f2contool\fP.
.IP ""
Archived messages can be viewed in the message archive, described below.
.IP "\fBPrint filter\fP"
This text field specifies the command to be used to print the
console.  The default is \*(lqlpr\*(rq.  Local site dependencies
may require a different command.
.IP "\fB\\*(lqAll is well\\*(rq icon\fP"
This text field contains the path of a file in either icon or XBM format.
Icon-format files may be created with \f2iconedit\fP(1); XBM-format files
are created with a number of tools.  If the path is not absolute, the
value of the ICON_PATH environment variable will be used to find the
file.  ICON_PATH should contain a list of directories, separated by
colons.
The contained image will be used as \f2contool\fP's regular icon image.
This image is displayed whenever no flashing is in effect.
.IP "\fB\\*(lqAll is well\\*(rq icon mask\fP"
This text field contains the path of a file in either icon or XBM format.
The contained image will be used to mask \f2contool\fP's \*(lqAll is well\*(rq
icon image when \f2contool\fP is run on a color desktop.  Masking is not 
supported on monochrome desktops.  The \*(lqAll is well\*(rq icon is not masked
if this field is left blank.
.IP "\fB\\*(lqCheck console\\*(rq icon\fP"
This image is alternated with the \fB\*(lqFlash\*(rq icon\fP image whenever flashing
is required.
.IP "\fB\\*(lqCheck console\\*(rq icon mask\fP"
This image will be used to mask \f2contool\fP's \*(lqCheck console\*(rq
icon image when \f2contool\fP is run on a color desktop.  The \*(lqCheck console\*(rq icon is not masked
if this field is left blank.
.IP "\fB\\*(lqFlash\\*(rq icon\fP"
This image is alternated with the \fB\*(lqCheck console\*(rq icon\fP image whenever flashing
is required.  Ideally, all three icons should be the same size.
.IP "\fB\\*(lqFlash\\*(rq icon mask\fP"
This image will be used to mask \f2contool\fP's \*(lqFlash\*(rq
icon image when \f2contool\fP is run on a color desktop.  The \*(lqFlash\*(rq icon is not masked
if this field is left blank.
.IP "\fBTimestamp resolution\fP"
This numeric field specifies the minimum number of seconds to wait before
writing a new timestamp to the console.  Messages which require timestamping
will only write a timestamp if this number of seconds have transpired since the
last timestamp.
.IP "\fBMaximum message text\fP"
This numeric field determines the maximum size, in bytes, of messages that will
be stored in the console.  When writing a message to the console would exceed
this limit, some number of bytes, as determined by the \fBOverflow delete amount\fP,
below, will be removed from the front of the console.  This feature prevents the
console from becoming so large over time that it begins to swamp system resources.
.IP "\fBOverflow delete amount\fP"
When writing a message to the console would exceed the \fBMaximum message text\fP,
above, text will be deleted from the beginning of the console to make room.
This numeric field specifies how many bytes to remove to make room.  \f2Contool\fP
will attempt to remove whole messages within the constraints of the console
size to preserve a readable console.
.IP "\fBApply\fP"
This button makes the values in the dialog box the
current tool properties.  Until this button is clicked, all changes made to
the properties are not used by \f2contool\fP.  After clicking \fBAccept\fP,
the changed values become the current properties.
.IP ""
Note that even after clicking \fBAccept\fP, the configuration file is
not updated.  To make the changes permanent between invocations of
\f2contool\fP, use the \fBSave Configuration\fP dialog to save the
changed properties.
.IP "\fBReset\fP"
This button discards any changes in the dialog box made to the current properties, 
restoring the properties to match the current properties in use
by \f2contool\fP.
.SH MESSAGE ARCHIVE
The \fBMessage Archive\fP dialog allows the user to view archived messages.
The dialog presents a scrolling text window and two buttons.
.IP "\fBClear\fP"
The \fBClear\fP button removes all the messages from the archive.  Normally, 
the archive
works like the main \f2contool\fP display: it retains a certain amount of text,
and deletes the oldest messages as new messages arrive in excess of that
amount.  The \fBClear\fP button circumvents this feature and explicitly
clears the archive display.
.IP ""
The archive window will hold ten times the amount of text specified for the
main console display, as determined by the \fBMaximum message text\fP
value in the \fBTool Properties\fP dialog, described above.
.IP "\fBPrint\fP
The \fBPrint\fP button prints the contents of the archive, using the 
\*(lqPrint Filter\*(rq specified in the \fBTool Properties\fP dialog.
.SH CONFIGURATION FILE FORMAT
Previous versions of \f2contool\fP relied on the user editing the
configuration file by hand.  This version manages the file automatically,
and it is not intended that the file be edited directly by users.
See EDITING FILTERS, above, for information on modifying the behavior
of \f2contool\fP.
.SH ENVIRONMENT VARIABLES
\f2Contool\fP uses certain environment variables to control its behavior.
They are:
.IP "\fBCONTOOL_FILTERS\fP"
specifies the file from which \f2contool\fP reads its filters and properties.
If not defined, ~/.contool is used.  If \fB-c\fP is specified, it overrides
the use of CONTOOL_FILTERS.
.IP "\fBCONTOOL_LABEL\fP"
specifies the label to be placed in \f2contool\fP's main window.  The default
label contains the current release number of \f2contool\fP.
.IP "\fBCONTOOL_LOGNAME\fP"
specifies the name to be prefixed to each message written to the console log
file.  If this variable is not defined, the machine's hostname is used.
.IP "\fBICON_PATH\fP"
contains a colon-separated list of directories which \f2contool\fP will
search to find the icon files specified in various tool properties.
.SH SIGNALS
\f2Contool\fP will respond to certain Unix signals.  They are:
.IP "\fBSIGHUP\fP"
Upon receipt of SIGHUP, \f2contool\fP will close and reopen its log file,
if logging is enabled.  This guarantees that logged messages are flushed
to disk.
.IP "\fBSIGUSR1\fP"
Upon receipt of SIGUSR1, \f2contool\fP will stop blinking its icon.  This
is a handy way to stop blinking without opening \f2contool\fP.
.SH FILES
.ta 2i
\f2\fP~/.contool	configuration file
.SH SEE ALSO
cmdtool(1), ed(1), kill(1), mkfifo(2), signal(3)
.SH AUTHOR
.LP
Chuck Musciano
.br
Advanced Technology Department
.br
Harris Corporation
.br
PO Box 37, MS 16/1912
.br
Melbourne, FL 32902
.br
(407) 727-6131
.br
E-mail: chuck@trantor.harris-atd.com
.br
Fax: (407) 729-3363
.SH BUGS
.LP
\f2Contool\fP is a view-only tool, and there is no way to type commands
on the console.
.LP
Window system bugs may cause unusual, but harmless, quirks in the behavior
of \f2contool\fP.  In particular, displaying a menu in a dialog box without
actually selecting an item from that menu may cause the dialog box to close.
