/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	busy.c	turn frame busy attribute on and off			*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<xview/xview.h>
#include	<xview/panel.h>

#include	"manifest.h"

/************************************************************************/
PRIVATE	set_busy(base, busy, skip)

Frame	base;
int	busy;
Frame	skip;

{	Frame	subframe;
	int	i;

	for (i = 1; subframe = (Frame) xv_get(base, FRAME_NTH_SUBFRAME, i); i++)
	   if (subframe != skip)
	      if (xv_get(subframe, XV_SHOW))
	         xv_set(subframe, FRAME_BUSY, busy, NULL);
	xv_set(base, FRAME_BUSY, busy, NULL);
}

/************************************************************************/
EXPORT	lets_get_busy(base, busy, skip)

Frame	base;
int	busy;
Frame	skip;

{	static	int	depth = 0;

	if (busy) {
	   if (depth == 0)
	      set_busy(base, TRUE, skip);
	   depth++;
	   }
	else if (depth > 0)
	   if (--depth == 0)
	      set_busy(base, FALSE, NULL);
}
