/************************************************************************/
/*	Copyright 1987-1994 by Chuck Musciano and Harris Corporation 	*/
/*									*/
/*	Full ownership of this software, and all rights pertaining to 	*/
/*	the for-profit distribution of this software, are retained by 	*/
/*	Chuck Musciano and Harris Corporation.  You are permitted to 	*/
/*	use this software without fee.  This software is provided "as 	*/
/*	is" without express or implied warranty.  You may redistribute 	*/
/*	this software, provided that this copyright notice is retained,	*/
/*	and that the software is not distributed for profit.  If you 	*/
/*	wish to use this software in a profit-making venture, you must 	*/
/*	first license this code and its underlying technology from 	*/
/*	Harris Corporation. 						*/
/*									*/
/*	Bottom line: you can have this software, you can use it, you 	*/
/*	can give it away.  You just can't sell any or all parts of it 	*/
/*	without prior permission from Harris Corporation. 		*/
/************************************************************************/

/************************************************************************/
/*									*/
/*	archive.c	contool message archive manager			*/
/*									*/
/************************************************************************/

#include	<stdio.h>
#include	<time.h>

#include	<xview/xview.h>
#include	<xview/panel.h>
#include	<xview/textsw.h>

#include	"manifest.h"
#include	"contool.h"
#include	"contool_ui.h"

PUBLIC	contool_base_objects	*contool_base;

PRIVATE	contool_message_archive_objects	*dialog = NULL;

/************************************************************************/
PRIVATE	void	stamp_archive(s)

char	*s;

{	time_t	t;
	char	msg[128];

	t = time(0);
	sprintf(msg, "%s %.25s", s, ctime(&t));
	xv_set(dialog->message_archive, FRAME_LEFT_FOOTER, msg, NULL);
}

/************************************************************************/
EXPORT	void	reset_archive_size()

{	int	sw_len;
	char	*temp;

	if (dialog) {
	   sw_len = (int) xv_get(dialog->archive, TEXTSW_LENGTH);
	   temp = (char *) malloc((unsigned) sw_len);
	   xv_get(dialog->archive, TEXTSW_CONTENTS, 0, temp, sw_len);
	   xv_set(dialog->archive, TEXTSW_MEMORY_MAXIMUM, defaults.max_size * 11, NULL);
	   textsw_reset(dialog->archive, 0, 0);
	   if (sw_len > defaults.max_size * 10)
	      textsw_insert(dialog->archive, temp + sw_len - defaults.max_size * 10, defaults.max_size * 10);
	   else
	      textsw_insert(dialog->archive, temp, sw_len);
	   free(temp);
	   }
}

/************************************************************************/
EXPORT	void	create_archive()

{
	if (dialog == NULL) {
	   dialog = contool_message_archive_objects_initialize(NULL, contool_base->base);
	   place_dialog(contool_base->base, dialog->message_archive);
	   reset_archive_size();
	   }
}

/************************************************************************/
EXPORT	Menu_item	popup_archive(item, op)

Menu_item	item;
Menu_generate	op;

{
	if (op == MENU_NOTIFY) {
	   create_archive();
	   xv_set(dialog->message_archive, XV_SHOW, TRUE, NULL);
	   }
	return(item);
}

/************************************************************************/
EXPORT	void	clear_archive()

{
	textsw_reset(dialog->archive, 0, 0);
	stamp_archive("Archive cleared");
}

/************************************************************************/
EXPORT	void	print_archive()

{	int	size;
	char	*buf;
	FILE	*cmd;

	if (is_empty(defaults.print_filter))
	   error("You must specify a printer command in the Properties dialog");
	else if ((cmd = popen(defaults.print_filter, "w")) == NULL)
	   error("Could not execute %s", defaults.print_filter);
	else {
	   lets_get_busy(contool_base->base, TRUE, NULL);
	   size = (int) xv_get(dialog->archive, TEXTSW_LENGTH);
	   buf = (char *) malloc(size);
	   xv_get(dialog->archive, TEXTSW_CONTENTS, 0, buf, size);
	   if (fwrite(buf, 1, size, cmd) != size)
	      error("Could not write console contents to printer");
	   pclose(cmd);
	   free(buf);
	   lets_get_busy(contool_base->base, FALSE, NULL);
	   }
}

/************************************************************************/
EXPORT	void	archive_messages()

{	Textsw_index	first, last;
	int	size, sw_len;
	char	*temp, *buf;

	create_archive();
	size = (int) xv_get(contool_base->display, TEXTSW_LENGTH);
	buf = (char *) malloc(size);
	xv_get(contool_base->display, TEXTSW_CONTENTS, 0, buf, size);
	while ((int) xv_get(dialog->archive, TEXTSW_LENGTH) + size > defaults.max_size * 10) {
	   sw_len = (int) xv_get(dialog->archive, TEXTSW_LENGTH);
	   first = 1;
	   last = TEXTSW_INFINITY;
	   if (textsw_find_bytes(dialog->archive, &first, &last, "\n<<<", 4, 0) == -1 || first == 0)
	      if (textsw_find_bytes(dialog->archive, &first, &last, "\n", 1, 0) == -1 || first == 0)
	         first = (defaults.delete_amount < sw_len)? defaults.delete_amount : sw_len;
	   temp = (char *) malloc((unsigned) sw_len);
	   xv_get(dialog->archive, TEXTSW_CONTENTS, 0, temp, sw_len);
	   textsw_reset(dialog->archive, 0, 0);
	   textsw_insert(dialog->archive, temp + first, sw_len - first);
	   free(temp);
	   }
	xv_set(dialog->archive, TEXTSW_INSERTION_POINT, TEXTSW_INFINITY, NULL);
	textsw_insert(dialog->archive, buf, size);
	free(buf);
	stamp_archive("Messages last archived");
	textsw_reset(contool_base->display, 0, 0);
}
