/*
 * Copyright (C) 2000-2001 Peter J Jones (pjones@pmade.org)
 * All Rights Reserved
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "Command.hh"
//# method get_varname ########################################################
/** Get a valid C++ variable name
	
	This method will generate a valid variable name from the
	commands name.

	@return the varname
	@author Peter Jones
**/
//#############################################################################
string Command::get_varname() {
	if (m_varname.size()) return m_varname;

	string::size_type i=0;
	m_varname = m_name;

	while (i < m_varname.size()) {
		if ((!isalnum(m_varname[i])) && (m_varname[i] != '_'))
			m_varname.replace(i, 1, 1, '_');
		i++;
	}

	m_varname.insert(0, "v_");
	return m_varname;
}
//# method get_description ####################################################
/** Get the description for this command
	
	This method will return the description for this command.

	@return a string containing the description
	@author Peter Jones
**/
//#############################################################################
string Command::get_description() {
	if (m_description.empty()) return "no description for this command";
	return m_description;
}
//####################################################################
/** 
 * add_option Add a option object to this command
 *
 * @param option The option to add
 * @author Peter Jones
**/
//####################################################################
void Command::add_option (Option &option) {
	// add the option
	m_options.push_back(option);

	// check for short and long names
	if (!m_have_short_options)
		m_have_short_options = option.has_short_name();
	if (!m_have_long_options)
		m_have_long_options = option.has_long_name();
}

