/*
 *
 * CLEX File Manager
 *
 * Copyright (C) 2001-2005 Vlado Potisk <vlado_potisk@clex.sk>
 *
 * CLEX is free software without warranty of any kind; see the
 * GNU General Public License as set out in the "COPYING" document
 * which accompanies the CLEX File Manager package.
 *
 * CLEX can be downloaded from http://www.clex.sk
 *
 */

#include <config.h>

#include <sys/types.h>	/* clex.h */
#include <stdlib.h>		/* free() */
#include <string.h>		/* strncmp() */

#include "clex.h"
#include "locate.h"

#include "cfg.h"		/* config_num() */
#include "control.h"	/* get_current_mode() */
#include "edit.h"		/* edit_setprompt() */
#include "panel.h"		/* pan_adjust() */
#include "inout.h"		/* win_panel() */
#include "match.h"		/* match() */
#include "sdstring.h"	/* SDSTR() */
#include "ustring.h"	/* USTR() */
#include "util.h"		/* emalloc() */

static FLAG mode_pattern;

static int
substring(const char *haystack, const char *needle)
{
	const char *h, *n;

	for ( ; ; haystack++ ) {
		for (h = haystack, n = needle; ; h++, n++) {
			if (*n == '\0')
				return 1;
			if (*h == '\0')
				return 0;
			if (*h != *n)
				break;
		}
	}
	/* NOTREACHED */
	return 0;
}

void
locate_prepare(void)
{
	int i, cnt;

	mode_pattern = get_current_mode() == MODE_P_LOCATE;

	panel_locate.pd->top = ppanel_file->pd->top;
	panel_locate.pd->curs = ppanel_file->pd->curs;
	cnt = panel_locate.pd->cnt = ppanel_file->pd->cnt;
	if (panel_locate.fe_alloc < cnt) {
		if (panel_locate.files)
			free(panel_locate.files);
		panel_locate.files = emalloc(cnt * sizeof(FILE_ENTRY *));
		panel_locate.fe_alloc = cnt;
	}
	for (i = 0; i < cnt; i++)
		panel_locate.files[i] = ppanel_file->files[i];
	panel = panel_locate.pd;

	edit_setprompt(&line_tmp,
	  mode_pattern ? "Show filenames matching the pattern: "
	  : "Show filenames containing the string: ");
	textline = &line_tmp;
	edit_nu_kill();
}

void
locate_update(void)
{
	int i, j;
	const char *str;
	FILE_ENTRY *pfe, *curspfe;

	if (ppanel_file->pd->cnt == 0)
		return;

	str = USTR(textline->line);
	if (mode_pattern && check_sre(str) != 0) {
		win_remark("pattern is incomplete");
		return;
	}
	curspfe = panel_locate.files[panel_locate.pd->curs];
	for (i = j = 0; i < ppanel_file->pd->cnt; i++) {
		pfe = ppanel_file->files[i];
		if (pfe == curspfe)
			panel_locate.pd->curs = j;
		if (mode_pattern ? (*str == '\0' || match(SDSTR(pfe->file)))
		  : substring(SDSTR(pfe->file),str))
			panel_locate.files[j++] = pfe;
	}
	panel_locate.pd->cnt = j;

	pan_adjust(panel);
	win_panel();
}

/* leave the locate mode, cursor is set to the selected file name */
void
cx_locate_go(void)
{
	int i;
	FILE_ENTRY *pfe;

	if (panel_locate.pd->cnt) {
		pfe = panel_locate.files[panel_locate.pd->curs];
		for (i = 0 ; i < ppanel_file->pd->cnt; i++)
			if (ppanel_file->files[i] == pfe) {
				ppanel_file->pd->curs = i;
				pan_adjust(ppanel_file->pd);
				break;
			}
	}
	next_mode = MODE_SPECIAL_RETURN;
}

/* tab = insert selected filename to the command line */
void
cx_locate_tab(void)
{
	if (panel_locate.pd->cnt == 0)
		return;

	if (kbd_esc())
		cx_edit_fullpath();
	else
		cx_edit_filename();
}
