<?php
// $Horde: chora/lib/base.php,v 1.66.2.1 2002/03/20 20:30:07 chuck Exp $

/*
 * Chora base inclusion file.
 *
 * This file brings in all of the dependencies that every Chora script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Chora
@define('CHORA_BASE', dirname(__FILE__) . '/..');

require_once CHORA_BASE . '/lib/Chora.php';
require_once CHORA_BASE . '/lib/version.php';
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once CHORA_BASE . '/lib/CVSLib.php';
require_once HORDE_BASE . '/config/horde.php';
require_once HORDE_BASE . '/config/lang.php';
require_once CHORA_BASE . '/config/conf.php';
require_once CHORA_BASE . '/config/cvsroots.php';
require_once CHORA_BASE . '/config/mime_drivers.php';

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('chora');
$conf = &$GLOBALS['conf'];
@define('CHORA_TEMPLATES', $registry->getParam('templates'));

/* Variable we wish to propagate across web pages
 *  sbt = Sort By Type (name, age, author, etc)
 *  ha  = Hide Attic Files
 *  ord = Sort order
 *
 * Obviously, defaults go into $defaultActs :)
 * TODO: defaults of 1 will not get propagated correctly - avsm
 * XXX: Rewrite this propagation code, since it sucks - avsm
 */

$defaultActs = array ('sbt'   => $conf['options']['defaultsort'],
                      'sa'    => 0,
                      'login' => 0,
                      'ord'   => CVSLIB_SORT_ASCENDING,
                      'ws'    => 1);

/* Use the last cvsroot used as the default value if the user has that
 * preference. */
$remember_last_file = $prefs->getValue('remember_last_file');
if ($remember_last_file) {
    $last_file = $prefs->getValue('last_file') ? $prefs->getValue('last_file') : null;
    $last_cvsroot = $prefs->getValue('last_cvsroot') ? $prefs->getValue('last_cvsroot') : null;
}

if ($remember_last_file && !empty($last_cvsroot)) {
    $defaultActs['rt'] = $last_cvsroot;
} else {
    foreach ($cvsroots as $key => $val) {
        if (isset($val['default']) || !isset($defaultActs['rt'])) {
            $defaultActs['rt'] = $key;
        }
    }
}

/* See if any have been passed as GET variables, and if
 * so, assign them into the acts array */
while (list($key,) = each($defaultActs)) {
    $acts[$key] = Horde::getFormData($key, $defaultActs[$key]);
}

if (!isset($cvsroots[$acts['rt']])) {
    fatal(404, 'Malformed URL');
}

$cvsrootopts = $cvsroots[$acts['rt']];
$cvsroot = $cvsrootopts['location'];

$conf['paths']['cvsRoot'] = $cvsrootopts['location'];
$conf['paths']['cvsusers'] = "$cvsroot/". @$cvsrootopts['cvsusers'];
$conf['paths']['introText'] = CHORA_BASE . '/config/' . @$cvsrootopts['intro'];
$conf['options']['introTitle'] = @$cvsrootopts['title'];
$conf['options']['cvsRootName'] = $cvsrootopts['name'];

$CVS = new CVSLib($conf);

/**
 * Generate A HREF tags for urls found within an input string
 * Only http and ftp URIs are scanned for.
 *
 * @param text The input text to be scanned for URLs
 * @return The processed text with <A HREF> tags
 */
function htmlify ($text) {
    /* TODO: cleanup all this - avsm */
    return preg_replace('|<br />(\W*<br />)+|','<br />',preg_replace('|<br>|','<br />',nl2br(trim(preg_replace('%(http|ftp)(://\S+)%', '<a href="\1\2">\1\2</a>', htmlspecialchars($text))))));
}

/**
 * Output an error page with relevant HTTP error headers
 *
 * @param errcode The HTTP error number and text
 * @param errmsg The verbose error message to be displayed
 */
function fatal($errcode, $errmsg)
{
    global $registry, $conf;
    header("Status: $errcode");
    $errmsg = htmlspecialchars($errmsg);
    include CHORA_TEMPLATES . '/error_page.inc';
    exit;
}

/**
 * Given a return object from a CVSLib call, make sure
 * that it's not a CVSLib_Error object.
 * @param e Return object from a CVSLib call
 */
function checkError($e) {
    if (is_object($e) && ($e->id() == CVSLIB_ERROR)) {
        fatal($e->error_header(), $e->error_body());
    }
}

$f = Horde::getFormData('f', '');
$where = $f;

/* Override $where with PATH_INFO if appropriate */
if ($conf['options']['use_path_info'] && isset($HTTP_SERVER_VARS['PATH_INFO'])) {
    $where = $HTTP_SERVER_VARS['PATH_INFO'];
}

/* Location relative to the CVSROOT */
$where = stripslashes($where);
$where = preg_replace("|^/|", '', $where);
$where = preg_replace("|\.\.|", '', $where);
$where = preg_replace('|/$|', '', $where); 

/* Location of this script (e.g. /chora/cvs.php) */
$scriptName = preg_replace('|^/?|', '/', $HTTP_SERVER_VARS['SCRIPT_NAME']); 
$scriptName = preg_replace('|/$|', '', $scriptName); 

/* Store last file/repository viewed, and set 'where' to last_file if
 * necessary. */
if ($remember_last_file) {
    /* We store last_cvsroot and last_file only when we have already
     * displayed at least one page. */
    if ($acts['login'] == 2) {
        $prefs->setValue('last_cvsroot', $acts['rt']);
        $prefs->setValue('last_file', $where);
        $prefs->store();
    }
    /* We are displaying the first page. */
    if ($acts['login'] == 1) {
        $where = $last_file;
        $acts['login'] = 2;
    }
}

$fullname = "$cvsroot/$where";

if (!@is_dir($cvsroot)) {
    fatal("500 Internal Error","CVSROOT not found!  This could be a misconfiguration by the server administrator, or the server could be having temporary problems.  Please try again later.");
}

// Don't allow access unless there is a Horde login, or guests are
// allowed.
if (!Auth::getAuth() && !$registry->allowGuests()) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    echo "\n";
    exit;
}

?>
