<?php
// $Horde: chora/lib/Chora.php,v 1.15.2.2 2002/03/20 20:30:07 chuck Exp $

require_once CHORA_BASE . '/lib/constants.php';

/**
 * Chora Base Class.
 *
 * @author Anil Madhavapeddy <avsm@horde.org>
 * @version $Revision: 1.15.2.2 $
 * @package chora
 */
class Chora {

    function whereMenu()
    {
        global $where;

        $bar = '';
        $wherePath = '';

        foreach (explode('/', $where) as $dir) {
            $wherePath .= "/$dir"; 
            if (!empty($dir) && ($dir != 'Attic')) {
                $bar .= '/ <a href="' . Chora::url('cvs', $wherePath) . '">'. Text::htmlallspaces($dir) . '</a>';
            }
        }
        return $bar;
    }

    /*
     * Return an array with the names of any of the variables we
     * need to keep, that are different from the defaults
     *
     * @ret Array containing names/vals of differing variables
     */
    function differingVars() {
        global $acts, $defaultActs;
        reset($acts);
        $ret = array();
        while (list($key,$val) = each($acts)) {
            if ($val != $defaultActs[$key]) {
                $ret[$key] = $val;
            }
        }
        return $ret;
    }
     
    /**
     * Generate a series of HIDDEN input forms based on the
     * GET parameters which are different from the defaults
     *
     * @param except Array of exceptions to never output
     * @return A set of INPUT tags with the different variables
     */
    function generateHiddens($except = array()) {
        global $acts;
        $toOut = Chora::differingVars();
        $ret = "";
        while (list($key,$val) = each($toOut)) {
            if (is_array($except) && !in_array($key, $except)) {
                $ret .= "<input type=\"hidden\" name=\"$key\" value=\"$val\" />\n";
            }
        }
        return $ret;
    }

    /**
     * Convert a commit-name into whatever the user wants
     * @param commit name
     * @return transformed name
     */
    function showAuthorName($name, $fullname = false) {
        global $CVS;

        if ($CVS->parseCVSUsers() && is_array($CVS->cvsusers) && isset($CVS->cvsusers[$name])) {
            return '<a href="mailto:'.$CVS->cvsusers[$name]['mail']. '">' .
            ($fullname ? $CVS->cvsusers[$name]['name'] : $name) .
            '</a>' . ($fullname ? " <i>($name)</i>" : '');
        } else {
            return $name;
        }
    }

    /**
     * Generate a URL that links into Chora.
     * @param script Name of the Chora script to link into
     * @param uri Any PATH_INFO portion that should be included
     * @param args Key/value pair of any GET parameters to append
     * @param anchor Anchor entity name
     */
    function url($script, $uri='', $args = array(), $anchor='')
    {
        global $registry, $conf;
     
        $url = $registry->getParam('webroot') . '/' . $script . '.php';
        $uri = rawurlencode($uri);
     
        $arglist = array_merge(Chora::differingVars(), $args);
     
        if ($conf['options']['use_path_info']) {
            $url .= '/' . $uri;
        } else {
            $arglist['f'] = $uri;
        }
     
        if (!isset($GLOBALS['HTTP_COOKIE_VARS'][session_name()])) {
            $arglist[urlencode(session_name())] = session_id();
        }

        $argarr = array();
        foreach ($arglist as $key => $val) {
            if (!empty($val)) {
                $val = htmlspecialchars($val);
                $argarr[] = "$key=$val";
            }
        }

        if (sizeof($argarr) > 0) {
            $url = "$url?" . implode('&', $argarr);
            $glue = '&';
        } else {
            $glue = '?';
        }
     
        if (!empty($anchor)) {
            $url .= "#$anchor";
        }
     
        $url = preg_replace('|/\?|', '?', $url);
        $url = preg_replace('|%2F|', '/', $url);
        $url = preg_replace('|/+|', '/', $url);
        $url = str_replace('&', '&amp;', $url);
     
        return $url;
    }

    /**
     * Generate a list of repositories available from this installation
     * of Chora. 
     * @return XHTML code representing links to the repositories
     */
    function repositories() {
        global $cvsroot, $cvsroots, $defaultActs;

        $arr = array();
        foreach ($cvsroots as $key=>$val) {
            if ($cvsroot != $val['location']) {
                $arg = array('rt' => (($defaultActs['rt'] == $key) ? '' : $key));
                $arr[] = '<b><a href="' . Chora::url('cvs', '', $arg) . '">' .
                         $val['name'] . '</a></b>';
            }
        }
         
        if (sizeof($arr)) {
            return _("Other Repositories") . ': ' . implode(' , ', $arr);
        } else {
            return "";
        }
    }

    /**
     * Check if the given item is restricted from being shown.
     * @return boolean whether or not the item is allowed to be displayed
     **/
    function isRestricted($item) {
        global $conf, $cvsroots, $cvsroot;
        static $restricted;

        if (!isset($restricted)) {
            $restricted = array();
            if (isset($conf['restrictions']) && is_array($conf['restrictions'])) {
                $restricted = $conf['restrictions'];
            }

            foreach ($cvsroots as $key => $val) {
                if ($cvsroot == $val['location']) {
                    if (isset($val['restrictions']) && is_array($val['restrictions'])) {
                        $restricted = array_merge($restricted, $val['restrictions']);
                        break;
                    }
                }
            }
        }

        if (!empty($restricted) && is_array($restricted) && count($restricted)) {
            for ($i = 0; $i < count($restricted); $i++) {
                if (preg_match('|' . str_replace('|', '\|', $restricted[$i]) . '|', $item)) {
                    return true;
                }
            }
        }

        return false;
    }

}

?>
