/*
 * libmsn
 *
 * Copyright (C) 1999, Shane P. Brady <shane@jxie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "chat_lists.h"
#include "libmsn.h"

extern MSN_Conn mainMSNConnection;

ChatUser *findChatUser(vector<ChatUser *> lst, const char *handle);

/*
** Name:    AddUserToChatList
** Purpose: This function adds a user to the current chat list
** Input:   chatSession   - chat list structure
**          userHandle    - user's handle
**          userFriendlyHandle - user's friendly handle 
**          index         - index of user
**          userState     - user state
** Output:  0 on success, -1 on failure
*/

int AddUserToChatList(ChatSession *chatSession, char *userHandle, 
char *userFriendlyHandle, int index, UserState userState) {
    ChatUser *cu;
    ChatUser *newUser;
    MSN_StatusChange sc;
    char *ourhandle;

    if(!chatSession) return -1;

    cu = findChatUser(chatSession->users, userHandle);

    if(cu) {
	cu->state = userState;
    } else {
/*
	RemoveHotmail(mainMSNConnection.handle, &ourhandle);
	RemoveHotmail(userHandle, &sc.handle);

	if(strcmp(sc.handle, ourhandle)) {
	    sc.friendlyhandle = userFriendlyHandle;
	    sc.newStatus = userState;

	    if(msn_event[MSN_ILN])
		(*msn_event[MSN_ILN])(&sc);
	}

	free(sc.handle);
	free(ourhandle);
*/
    }

    newUser = (ChatUser *)malloc(sizeof(ChatUser));
    if(!newUser) return -1;

    strcpy(newUser->userHandle, userHandle);
    strcpy(newUser->userFriendlyHandle, userFriendlyHandle);

    newUser->index = index;
    newUser->state = userState;
 
    chatSession->users.push_back(newUser);

    return 0;
}

/*
** Name:    RemoveUserFromChatList
** Purpose: This function removes a user from the list
** Input:   chatSession    - chat list structure
**          userHandle     - user handle
** Output:  0 on success, -1 on failure
*/

int RemoveUserFromChatList(ChatSession *chatSession, char *userHandle)
{
    vector<ChatUser *>::iterator ui;
    ChatUser *u;

    if(u = findChatUser(chatSession->users, userHandle)) {
	ui = find(chatSession->users.begin(), chatSession->users.end(), u);

	if(ui != chatSession->users.end()) {
	    chatSession->users.erase(ui);
	}
    }

    return 0; 
}

/*
** Name:    SearchForUser
** Purpose: This function searches a chat list and returns whether the
**          user is indeed, on a list
** Input:   chatSession - chat list structure
**          handle      - handle to search for
** Output:  0 if found, -1 if not
*/

int SearchForUser(ChatSession chatSession, const char *handle)
{
    return findChatUser(chatSession.users, handle) ? -1 : 0;
}

/*
** Name:    ChangeUserState
** Purpose: This function changes a users state
** Input:   chatSession - chat list structure
**          userHandle  - user handle
**          newState    - new state of user
** Output:  0 on success, -1 on failure
*/

int ChangeUserState(ChatSession *chatSession, char *userHandle,
		    UserState userState)
{
    ChatUser  *cu;

    cu = findChatUser(chatSession->users, userHandle);

    if(cu) {
	cu->state = userState;
    } else {
	return -1;
    }

    return 0;
}

/*
** Name:    DestroyChatList
** Purpose: This function destroys the list of chat users
** Input:   chatSession - chat list structure
** Output:  0 on success, -1 on failure
*/

int DestroyChatList(ChatSession chatSession)
{
    while(!chatSession.users.empty()) {
	free(*chatSession.users.begin());
	chatSession.users.erase(chatSession.users.begin());
    }
    return 0;         
}

/*
** Name:    CompareUserName
** Purpose: This function is used to compare nodes in the list
** Input:   a - node
**          b - name
** Output:  0 if found, something else
*/
/*
gint CompareUserName(gconstpointer a, gconstpointer b)
{
    ChatUser *cu;
    char     *handle;

    handle = (char *)b;
    cu = (ChatUser *)a;

    if (!handle || !cu->userHandle)
	return (-1);

    return strcmp(handle, cu->userHandle);
}
*/

ChatUser *findChatUser(vector<ChatUser *> lst, const char *handle) {
    vector<ChatUser *>::const_iterator i;
    ChatUser *u;

    if(handle)
    for(i = lst.begin(); i != lst.end(); i++) {
	u = *i;

	if(u->userHandle)
	if(!strcmp(handle, u->userHandle)) {
	    return u;
	}
    }

    return 0;
}
