/*
*
* $Id: proxy.c,v 1.3 2001/06/02 07:10:45 konst Exp $
*
* Copyright (C) 2000 Denis V. Dmitrienko <denis@null.net>
* Copyright (C) 2000 Bill Soudan <soudan@kde.org>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or (at
* your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
*/

#ifndef _WIN32
#include <unistd.h>
#endif

#ifdef _WIN32
#include <winsock.h>
#endif

#include <stdlib.h>

#include "util.h"
#include "icqtypes.h"
#include "icq.h"
#include "icqlib.h"

void icq_HandleProxyResponse(ICQLINK *link)
{
  int s;
  char buf[256];
#ifdef _WIN32
  s = recv(link->icq_ProxySok, buf, sizeof(buf), 0);
#else
  s = read(link->icq_ProxySok, &buf, sizeof(buf));
#endif
  if(s<=0)
  {
    icq_FmtLog(link, ICQ_LOG_FATAL, "[SOCKS] Connection terminated\n");
    icq_Disconnect(link);
    if(link->icq_Disconnected)
      (*link->icq_Disconnected)(link);
  }
}

/*******************
SOCKS5 Proxy support
********************/
void icq_SetProxy(ICQLINK *link, const char *phost, unsigned short pport, int pauth, const char *pname, const char *ppass)
{
  if(link->icq_ProxyHost)
    free(link->icq_ProxyHost);
  if(link->icq_ProxyName)
    free(link->icq_ProxyName);
  if(link->icq_ProxyPass)
    free(link->icq_ProxyPass);
  if(strlen(pname)>255)
  {
    icq_FmtLog(link, ICQ_LOG_ERROR, "[SOCKS] User name greater than 255 chars\n");
    link->icq_UseProxy = 0;
    return;
  }
  if(strlen(ppass)>255)
  {
    icq_FmtLog(link, ICQ_LOG_ERROR, "[SOCKS] User password greater than 255 chars\n");
    link->icq_UseProxy = 0;
    return;
  }
  link->icq_UseProxy = 1;
  link->icq_ProxyHost = strdup(phost);
  link->icq_ProxyPort = pport;
  link->icq_ProxyAuth = pauth;
  link->icq_ProxyName = strdup(pname);
  link->icq_ProxyPass = strdup(ppass);
}

void icq_UnsetProxy(ICQLINK *link)
{
  link->icq_UseProxy = 0;
}

int icq_GetProxySok(ICQLINK *link)
{
  return link->icq_ProxySok;
}
