#ifndef __KONST_SOCKET_H_
#define __KONST_SOCKET_H_

#include "konst.string.h"
#include "konst.conf.h"

__KTOOL_BEGIN_NAMESPACE

class streamsocketabstract {
    protected:
        int sockfd;
        bool fconnected;

    public:
        streamsocketabstract();
        ~streamsocketabstract();

        int getfd();
        virtual bool connected();
        virtual bool readready();
        virtual bool writeready();
        virtual void disconnect();
};

class streamsocketclient: public streamsocketabstract {
    protected:
    public:
        streamsocketclient();
        streamsocketclient(string dest, int port);

        bool readready();
        bool writeready();

        void connect(string dest, int port);
        void disconnect();

        string readline();
        int readblock(void *buf, int size);

        void write(string text);
        void writeline(string text);
        
        streamsocketclient& operator<<(string s);
        streamsocketclient& operator<<(int n);
};

__KTOOL_END_NAMESPACE

__KTOOL_BEGIN_C

int atoport(char *service, char *proto);
struct in_addr *atoaddr(const char *address);
void ignore_pipe();
int sockWaitForWrite(int sock, int seconds);
int sockWaitForData(int sock, int seconds);

__KTOOL_END_C

#ifdef __KTOOL_USE_NAMESPACES

using ktool::streamsocketabstract;
using ktool::streamsocketclient;

#endif

#endif
