#include "konst.ui.menu.h"
#include "konst.ui.text.h"
#include "konst.ui.edit.h"
#include "konst.ui.input.h"
#include "konst.ui.fm.h"
#include "konst.ui.tree.h"

#define TEST_TEXTWINDOW
#define TEST_TREEVIEW
#define TEST_TEXTINPUTLINE
#define TEST_TEXTEDITOR
#define TEST_TEXTBROWSER
#define TEST_HORIZONTALMENU
#define TEST_FILEMANAGER

#ifdef TEST_TREEVIEW

treeview tree(color(1), color(2), boldcolor(1), color(1));

int treekeys(verticalmenu *ref, int k) {
    int nid = tree.getid(ref->getpos());

    switch(k) {
        case '-':
            tree.closenode(nid);
            tree.menu.redraw();
            break;
        case '+':
            tree.opennode(nid);
            tree.menu.redraw();
            break;
    }

    return -1;
}

#endif


#ifdef TEST_TEXTEDITOR

int editkeys(texteditor *ref, int k) {
    switch(k) {
        case KEY_ESC:
            return -1;
    }

    return 0;
}

#endif

int main() {
    int i;
    kinterface();

    init_pair(1, COLOR_WHITE, COLOR_BLUE);
    init_pair(2, COLOR_BLACK, COLOR_WHITE);
    init_pair(3, COLOR_YELLOW, COLOR_BLUE);

    textwindow tw(0, 0, 65, 18, color(1), TW_CENTERED);
    tw.set_title(boldcolor(1), " Simple window ");
    tw.open();
    tw.write(2, 1, "simple text");
    getkey();

#ifdef TEST_TREEVIEW

    int node;

    tree.menu.setwindow(tw);
    tw.redraw();
    tw.set_title(boldcolor(1), " Tree view, [+-] to unfold/collapse, Enter to select ");

    node = tree.addnode(0, 0, 0, " Source files ");
    tree.addleaf(node, 0, (void *) "1", " src/proggie.cc ");
    tree.addleaf(node, 0, (void *) "2", " src/util.cc ");

    node = tree.addnode(0, 0, (void *) "3", " Header files ");
    tree.addleaf(node, 0, (void *) "4", " include/proggie.h ");

    tree.menu.otherkeys = &treekeys;
    tree.collapsable = true;
    tw.set_title(boldcolor(1), " Result = %s, press any key.. ", tree.open(&i));
    getkey();

#endif

#ifdef TEST_TEXTINPUTLINE

    textinputline line(boldcolor(2));
//    line->passwordchar = '*';

    tw.redraw();
    tw.set_title(boldcolor(1), " Text input box ");

    tw.write(2, 5, "An alphabet input line: ");
    line.open(tw.x1+26, tw.y1+5, "abcdefghijklmnopqrstuvwxyz", 20, 30);

#endif

#ifdef TEST_TEXTEDITOR

    tw.redraw();
    tw.set_title(boldcolor(1), " texteditor class example. ESC-ESC to close ");

    texteditor e;
    FILE *f = fopen("/etc/passwd", "r");

    e.setcoords(tw.x1+1, tw.y1+1, tw.x2-1, tw.y2);
    e.addscheme(1, 2, 0, 0);
//    e.wrap = true;
//    e.load("", "1");
    e.otherkeys = &editkeys;
    e.load(f, "1");
    e.open();

    fclose(f);

#endif

#ifdef TEST_TEXTBROWSER

    tw.redraw();
    tw.set_title(boldcolor(1), " Browsing some text.. ESC-ESC to close ");

    textbrowser tb(tw.x1+1, tw.y1+1, tw.x2-1, tw.y2, color(1));
    tb.setbuf("That's a text you can scroll up and down. Long lines will be wrapped, etc. As it should be :)");
    tb.open();
    tb.close();

#endif

#ifdef TEST_HORIZONTALMENU

    horizontalmenu m(1, 0, boldcolor(1), color(2), color(1));

    m.additem(" First ");
    m.pulldown(0)->additem(" first 1");
    m.pulldown(0)->additem(" first 2");
    m.pulldown(0)->additem(" first 3");

    m.additem(" Second ");
    m.pulldown(1)->additem(" second 1");
    m.pulldown(1)->additem(" second 2");
    m.pulldown(1)->additem(" second 3");
    m.pulldown(1)->additem(" second 4");
    m.pulldown(1)->additem(" second 5");

    m.additem(" Third ");
    m.pulldown(2)->additem(" third 1");
    m.pulldown(2)->additem(" third 2");
    m.pulldown(2)->additem(" third 3");

    int h, v;

    m.open(&h, &v);
    m.close();

    tw.set_title(boldcolor(1), " Reporing menu selection results ");
    tw.redraw();
    tw.writef(2, 10, "Horizontal %d and vertical %d were selected ", h, v);
    tw.write(2, 11, "Any key to continue..");
    getkey();

#endif

#ifdef TEST_FILEMANAGER

    filemanager fm(1, 1, 50, 15, color(1), boldcolor(1), boldcolor(3), color(2), boldcolor(1));
    fm.setstartpoint("/home/konst/");
    fm.multi = false;
    fm.fullpath = true;
    fm.onlydirs = true;
    fm.chroot = true;
    fm.open();
    fm.close();

    tw.redraw();
    tw.set_title(boldcolor(1), " File selection dialog results ");

    for(int i = 0; i < fm.selected->count; i++) {
        char *p = (char *) fm.selected->at(i);
        tw.write(2, 1+i, p);
    }

    getkey();

#endif

    tw.close();
}
