/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
$Id: tcpchathandle.c,v 1.8 2000/07/24 03:10:08 bills Exp $
$Log: tcpchathandle.c,v $
Revision 1.8  2000/07/24 03:10:08  bills
added support for real nickname during TCP transactions like file and
chat, instead of using Bill all the time (hmm, where'd I get that from? :)

Revision 1.7  2000/07/09 22:19:35  bills
added new *Close functions, use *Close functions instead of *Delete
where correct, and misc cleanup

Revision 1.6  2000/05/04 15:57:20  bills
Reworked file transfer notification, small bugfixes, and cleanups.

Revision 1.5  2000/05/03 18:29:15  denis
Callbacks have been moved to the ICQLINK structure.

Revision 1.4  2000/04/05 14:37:02  denis
Applied patch from "Guillaume R." <grs@mail.com> for basic Win32
compatibility.

Revision 1.3  2000/02/07 02:54:45  bills
warning cleanups.

Revision 1.2  2000/02/07 02:43:37  bills
new code for special chat functions (background, fonts, etc)

Revision 1.1  1999/09/29 19:47:21  bills
reworked chat/file handling.  fixed chat. (it's been broke since I put
non-blocking connects in)

*/

#include <time.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#include <stdlib.h>

#include "icqtypes.h"
#include "icq.h"
#include "icqlib.h"

#include "stdpackets.h"
#include "tcplink.h"
#include "chatsession.h"

void icq_ChatConnect(ICQLINK *link, icq_ChatSession *pchat, DWORD uin, unsigned long port);

void icq_HandleChatAck(icq_TCPLink *plink, icq_Packet *p, int status, int port)
{
  icq_TCPLink *pchatlink, *plisten;
  icq_ChatSession *pchat;
  icq_Packet *p2;

  if(plink->icqlink->icq_RequestNotify)
    (*plink->icqlink->icq_RequestNotify)(plink->icqlink, p->id, ICQ_NOTIFY_ACK, status, 0);
  if (status == ICQ_TCP_STATUS_REFUSE) return;

  pchat=icq_FindChatSession(plink->icqlink, p->id);
  
  if (pchat) {
    /* remote side acknowledged joining multichat session
       it's up to them to connect to the supplied listen() socket
       so we'll do nothing */
  } else {
    /* starting a new head2head chat */

    pchat=icq_ChatSessionNew(plink->icqlink);
    pchat->id=p->id;
    
    /* open a new listening socket which will be used when another user
     wants to join this chat session */
    plisten=icq_TCPLinkNew(plink->icqlink);
    plisten->id = pchat->id;
    plisten->type=TCP_LINK_CHAT;
    icq_TCPLinkListen(plisten);
    pchat->listen_link = plisten;

    pchatlink=icq_TCPLinkNew(plink->icqlink);
    pchatlink->type=TCP_LINK_CHAT;
    pchatlink->id=p->id;
  
    icq_ChatConnect(plink->icqlink, pchat, plink->remote_uin, port);

    p2=icq_TCPCreateChatInfoPacket(pchatlink, plink->icqlink->icq_Nick,
                                   0x00ffffff, 0x00000000,
				   pchat->listen_link->socket_address.sin_port);
    icq_TCPLinkSend(pchatlink, p2);
  }

}

void icq_HandleChatHello(icq_TCPLink *plink)
{
  icq_ChatClient *c;
  
  icq_ChatSession *pchat=icq_FindChatSession(plink->icqlink,
    plink->id);

  if(pchat)
  {
    plink->session=pchat;
    c = icq_FindChatClient(plink->session, plink->remote_uin);
    if (!c) {
      /* if this is a new UIN, create another entry in the chat buddy list */
      c = (icq_ChatClient *)malloc(sizeof(icq_ChatClient));
      list_insert(pchat->clients, 0, c);
      c->tcplink=plink;
      c->status = CHAT_STATUS_WAIT_NAME;
      c->uin = plink->remote_uin;
    }
    icq_ChatSessionSetStatus(pchat, plink->remote_uin, CHAT_STATUS_WAIT_NAME);

  } else {

    icq_FmtLog(plink->icqlink, ICQ_LOG_WARNING,
      "unexpected chat hello received from %d, closing link\n",
      plink->remote_uin);
    icq_TCPLinkClose(plink);
  }

}

void icq_TCPOnChatReqReceived(ICQLINK *link, DWORD uin, const char *message,
                              const char *session, DWORD port, DWORD id)
{
#ifdef TCP_PACKET_TRACE
  printf("chat request packet received from %lu { sequence=%lx, message=%s }\n",
     uin, id, message);
#endif /* TCP_PACKET_TRACE */

  if(link->icq_RecvChatReq) {

    /* use the current system time for time received */
    time_t t=time(0);
    struct tm *ptime=localtime(&t);

    (*link->icq_RecvChatReq)(link, uin, ptime->tm_hour, ptime->tm_min,
       ptime->tm_mday, ptime->tm_mon+1, ptime->tm_year+1900, message, id, session, port);

    /* don't send an acknowledgement to the remote client!
     * GUI is responsible for sending acknowledgement once user accepts
     * or denies using icq_TCPSendChatAck */
  }
}

void icq_TCPChatUpdateFont(icq_TCPLink *plink, const char *font, WORD encoding, DWORD style, DWORD size)
{
  int packet_len, fontlen;
  char *buffer;
  if(!plink->icqlink->icq_RequestNotify)
    return;
  buffer = malloc(packet_len = (2 + (fontlen = strlen(font) + 1)) + 2 + 1 + (4+1)*2);
  buffer[0] = '\x11';
  *((DWORD *)&buffer[1]) = style;
  buffer[5] = '\x12';
  *((DWORD *)&buffer[6]) = size;
  buffer[10] = '\x10';
  *((WORD *)&buffer[11]) = fontlen;
  strcpy(&buffer[13], font);
  icq_RusConv("wk", &buffer[13]);
  *((WORD *)&buffer[13 + fontlen]) = encoding;
  if(plink->icqlink->icq_RequestNotify)
    (*plink->icqlink->icq_RequestNotify)(plink->icqlink, plink->id, ICQ_NOTIFY_CHATDATA, packet_len, buffer);
  free(buffer);
}

void icq_TCPChatUpdateColors(icq_TCPLink *plink, DWORD foreground, DWORD background)
{
  char buffer[10];

  if(!plink->icqlink->icq_RequestNotify)
    return;  
  buffer[0] = '\x00';
  *((DWORD *)&buffer[1]) = foreground;
  buffer[5] = '\x01';
  *((DWORD *)&buffer[6]) = background;
  if(plink->icqlink->icq_RequestNotify)
    (*plink->icqlink->icq_RequestNotify)(plink->icqlink, plink->id, ICQ_NOTIFY_CHATDATA,
                                         sizeof(buffer), buffer);
}

int _icq_CountReadyBuddy(void *vcl, va_list data)
{
  icq_ChatClient *c = (icq_ChatClient *)vcl;
  int *i=va_arg(data, int *);

  if (c->status == CHAT_STATUS_READY) {
    *i++;
  }
  
}

int _icq_AppendBuddyInfo(void *vcl, va_list data)
{
  icq_ChatClient *c = (icq_ChatClient *)vcl;
  icq_Packet *p=va_arg(data, icq_Packet *);

  if (c->status == CHAT_STATUS_READY) {
    icq_PacketAppend16(p, c->version);
    icq_PacketAppend16(p, c->revision);
    icq_PacketAppend32(p, c->port);
    icq_PacketAppend32(p, c->uin);
    icq_PacketAppend32(p, c->ip);
    icq_PacketAppend32(p, c->real_ip);
    icq_PacketAppend16(p, c->rev_port);
    icq_PacketAppend8(p, c->tcp_capable);
    icq_PacketAppend16(p, c->rand);
    icq_PacketAppend32(p, c->handshake);
  }
  
}

void icq_TCPProcessChatPacket(icq_Packet *p, icq_TCPLink *plink)
{
  DWORD handshake, listen_port;
  WORD version, revision, rev_port;
  DWORD remote_uin;
  DWORD ip1, ip2;
  DWORD fg, bg, fontstyle, fontsize;
  WORD rand, encoding;
  BYTE tcpflag;
  icq_Packet *presponse;
  icq_ChatSession *pchat=(icq_ChatSession *)plink->session;
  const char *font, *user;
  icq_ChatClient *c = icq_FindChatClient(pchat, plink->remote_uin);
  int i, buddy_count;
	
  icq_PacketBegin(p);

  switch (c->status) {
  case CHAT_STATUS_WAIT_NAME:
    handshake=icq_PacketRead32(p);
    version=icq_PacketRead16(p);
    revision=icq_PacketRead16(p);
    remote_uin=icq_PacketRead32(p);
    user = icq_PacketReadString(p);
    rev_port = icq_PacketRead16(p); /* chat session port in network order */;
    fg = icq_PacketRead32(p);
    bg = icq_PacketRead32(p);
    icq_PacketRead8(p); /* unknown, always 0x00 */;

    c->handshake = handshake;
    strncpy(c->handle, user, 64);
    c->handle[63] = 0;

    icq_TCPChatUpdateColors(plink, fg, bg);

    presponse=icq_TCPCreateChatInfo2Packet(plink, plink->icqlink->icq_Nick,
                                           0x00ffffff, 0x00000000,
                                           pchat->listen_link->socket_address.sin_port);
    list_traverse(pchat->clients, _icq_CountReadyBuddy, buddy_count);
    icq_PacketAppend8(p, buddy_count);
    list_traverse(pchat->clients, _icq_AppendBuddyInfo, presponse);
    icq_PacketSend(presponse, plink->socket);
    icq_PacketDelete(presponse);
    icq_ChatSessionSetStatus(pchat, plink->remote_uin, CHAT_STATUS_WAIT_FONT);
    break;
  case CHAT_STATUS_WAIT_FONT:
    font = (char *)NULL;
    encoding = 0;
    fontstyle = 0;
    fontsize = 0;
    version=icq_PacketRead16(p);
    revision=icq_PacketRead16(p);
    listen_port=icq_PacketRead32(p);
    if(version == 0x0004 && revision == 0x0007)
      {
        ip1 = icq_PacketRead32(p);
        ip2 = icq_PacketRead32(p);
        tcpflag = icq_PacketRead8(p);
        rand = icq_PacketRead16(p);
        fontsize = icq_PacketRead32(p);
        fontstyle = icq_PacketRead32(p);
        font = icq_PacketReadString(p);
        encoding = icq_PacketRead16(p);
      }
    else
      {
        ip1 = icq_PacketRead32(p);
        ip2 = icq_PacketRead32(p);
        rand = icq_PacketRead16(p);
        tcpflag = icq_PacketRead8(p);
        fontsize = icq_PacketRead32(p);
        fontstyle = icq_PacketRead32(p);
        font = icq_PacketReadString(p);
        encoding = icq_PacketRead16(p);
      }
    c->version = version;
    c->revision = revision;
    c->port = listen_port;
    /* c->uin is set with the hello packet */
    c->ip = ip1;
    c->real_ip = ip2;
    c->rev_port = htons(listen_port);
    c->tcp_capable = tcpflag;
    c->rand = rand;
    /* c->handshake is set with the name packet */
    if(font)
      icq_TCPChatUpdateFont(plink, font, encoding, fontstyle, fontsize);
    icq_ChatSessionSetStatus(pchat, plink->remote_uin, CHAT_STATUS_READY);
    plink->mode|=TCP_LINK_MODE_RAW;
    /* allow another connections */
    pchat->blocked = 0;
    break;
  case CHAT_STATUS_WAIT_ALLINFO:
    handshake=icq_PacketRead32(p);
    remote_uin=icq_PacketRead32(p);
    user = icq_PacketReadString(p);
    fg = icq_PacketRead32(p);
    bg = icq_PacketRead32(p);
    icq_TCPChatUpdateColors(plink, fg, bg);
    font = (char *)NULL;
    encoding = 0;
    fontstyle = 0;
    fontsize = 0;
    version=icq_PacketRead16(p);
    revision=icq_PacketRead16(p);
    if(version == 0x0004 && revision == 0x0007)
      {
        listen_port = icq_PacketRead32(p);
        ip1 = icq_PacketRead32(p);
        ip2 = icq_PacketRead32(p);
        tcpflag = icq_PacketRead8(p);
        rand = icq_PacketRead16(p);
        fontsize = icq_PacketRead32(p);
        fontstyle = icq_PacketRead32(p);
        font = icq_PacketReadString(p);
        encoding = icq_PacketRead16(p);
      }
    else /* if(version == 0x0006 && revision == 0x0000) */
      {
        listen_port = icq_PacketRead32(p);
        ip1 = icq_PacketRead32(p);
        ip2 = icq_PacketRead32(p);
        rand = icq_PacketRead16(p);
        tcpflag = icq_PacketRead8(p);
        fontsize = icq_PacketRead32(p);
        fontstyle = icq_PacketRead32(p);
        font = icq_PacketReadString(p);
        encoding = icq_PacketRead16(p);
      }

    c->version = version;
    c->revision = revision;
    /* c->port & c->uin have been already set in icq_ChatConnect */
    c->ip = ip1;
    c->real_ip = ip2;
    c->tcp_capable = tcpflag;
    c->rand = rand;
    c->handshake = handshake;

    buddy_count = icq_PacketRead8(p);
    for (i = 0; i < buddy_count; i++) {
      /* connect to the others - icq_ChatConnect takes care of
         possible duplicate connections */
      version=icq_PacketRead16(p);
      revision=icq_PacketRead16(p);
      if(version == 0x0004 && revision == 0x0007)
        {
          listen_port = icq_PacketRead32(p);
          remote_uin=icq_PacketRead32(p);
          ip1 = icq_PacketRead32(p);
          ip2 = icq_PacketRead32(p);
          rev_port = icq_PacketRead16(p); /* chat session port in network order */;
          tcpflag = icq_PacketRead8(p);
          rand = icq_PacketRead16(p);
          handshake=icq_PacketRead32(p);
        }
      else /* if(version == 0x0006 && revision == 0x0000) */
        {
          listen_port = icq_PacketRead32(p);
          remote_uin=icq_PacketRead32(p);
          ip1 = icq_PacketRead32(p);
          ip2 = icq_PacketRead32(p);
          rev_port = icq_PacketRead16(p); /* chat session port in network order */;
          rand = icq_PacketRead16(p);
          tcpflag = icq_PacketRead8(p);
          handshake=icq_PacketRead32(p);
        }
      icq_ChatConnect(plink->icqlink, pchat, remote_uin, listen_port);
    }

    if(font)
      icq_TCPChatUpdateFont(plink, font, encoding, fontstyle, fontsize);
    presponse=icq_TCPCreateChatFontInfoPacket(plink,
      pchat->listen_link->socket_address.sin_port);
    icq_PacketSend(presponse, plink->socket);
    icq_PacketDelete(presponse);
    /* notify app that chat connection has been established */
    icq_ChatSessionSetStatus(pchat, plink->remote_uin, CHAT_STATUS_READY);
    plink->mode|=TCP_LINK_MODE_RAW;
    /* allow another connections */
    pchat->blocked = 0;
    break;
  }

}

