
#include <stdlib.h>

#include "chatsession.h"
#include "list.h"

icq_ChatSession *icq_ChatSessionNew(ICQLINK *icqlink) 
{
  icq_ChatSession *p=(icq_ChatSession *)malloc(sizeof(icq_ChatSession));

  if (p)
  {
    p->icqlink = icqlink;
    p->listen_link = 0;
    p->id = 0;
    p->blocked = 1;
    p->clients = list_new();
    list_insert(icqlink->icq_ChatSessions, 0, p);
  }
	
  return p;
}

void icq_ChatSessionDelete(void *p)
{
  list_delete(((icq_ChatSession *)p)->clients, free);
  free(p);
}

int _icq_DisconnectChatBuddy(void *p, va_list data)
{
  ((icq_ChatClient *)p)->tcplink->session = 0;
  icq_TCPLinkClose(((icq_ChatClient *)p)->tcplink);
  return 0;
}

void icq_ChatSessionClose(icq_ChatSession *p)
{
  /* close the listening socket so nobody can join anymore */
  if (p->listen_link) {
    p->listen_link->session = 0;
    icq_TCPLinkClose(p->listen_link);
  }
  
  /* close all connection to buddies */
  list_traverse(p->clients, _icq_DisconnectChatBuddy);
  list_remove(p->icqlink->icq_ChatSessions, p);

  icq_ChatSessionDelete(p);
}

int _icq_FindChatSession(void *p, va_list data)
{
  DWORD id=va_arg(data, DWORD);
  return (((icq_ChatSession *)p)->id == id);
}

icq_ChatSession *icq_FindChatSession(ICQLINK *icqlink, DWORD id)
{
  return list_traverse(icqlink->icq_ChatSessions,
    _icq_FindChatSession, id);
}

int _icq_FindChatClient(void *p, va_list data)
{
  DWORD uin=va_arg(data, DWORD);
  return (((icq_ChatClient *)p)->uin == uin);
}

icq_ChatClient *icq_FindChatClient(icq_ChatSession *session, DWORD uin)
{
  return list_traverse(session->clients, _icq_FindChatClient, uin);
}

/* a buddy has disconnected so we'll remove their entry */
void icq_ChatSessionBuddyLinkClosed(icq_ChatSession *p, DWORD uin)
{
  icq_ChatClient *c = icq_FindChatClient(p, uin);
  if (c) {
    if (c->status != CHAT_STATUS_READY) {
      /* disconnected during handshake */
      p->blocked = 0;
    }
    list_remove(p->clients, c);
  }
  if (((list*)p->clients)->count == 0) {
    icq_ChatSessionClose(p);
  }
}

/* we have to maintain a status field for each buddy */
void icq_ChatSessionSetStatus(icq_ChatSession *p, DWORD uin, int status)
{
  icq_ChatClient *c = icq_FindChatClient(p, uin);
  c->status=status;
  if (p->id)
    if(p->icqlink->icq_RequestNotify)
      (*p->icqlink->icq_RequestNotify)(p->icqlink, p->id, ICQ_NOTIFY_CHAT, status, 0);
}
