#include "konst.ui.text.h"

textbrowser::textbrowser(int nx1, int ny1, int nx2, int ny2, int clr) {
    setcoord(nx1, ny1, nx2, ny2);
    setcolor(clr);
    idle = 0;
    otherkeys = 0;
}

textbrowser::textbrowser(int clr = 0) {
    setcolor(clr);
    idle = 0;
    otherkeys = 0;
}

textbrowser::~textbrowser() {
}

void textbrowser::setcolor(int clr = 0) {
    ncolor = clr;
}

void textbrowser::setcoord(int nx1, int ny1, int nx2, int ny2) {
    x1 = nx1;
    x2 = nx2;
    y1 = ny1;
    y2 = ny2;
}

void textbrowser::redraw() {
    draw(0);
}

bool textbrowser::empty() {
    return lines.empty();
}

void textbrowser::draw(int line) {
    int i;
    attrset(ncolor);

    for(i = line; (i-line < y2-y1) && (i < lines.size()); i++) {
        mvprintw(y1+i-line, x1, "");
        printstring(lines[i]);
        for(int k = lines[i].size(); k < x2-x1; k++) printw(" ");
    }

    for(; i-line < y2-y1; i++) mvhline(y1+i-line, x1, ' ', x2-x1);
    refresh();
}

void textbrowser::setbuf(const char *p) {
    formattext(p, lines, true, x2-x1);
}

int textbrowser::open() {
    bool finished = false, go;
    int line = 0, res, ch;
    
    savescr();
    draw(0);

    while(!finished) {
        if(idle) go = keypressed(); else go = true;

        if(go) switch(ch = getkey()) {
            case KEY_UP:
                if(--line < 0) line = 0; else draw(line);
                break;
                
            case KEY_DOWN:
                if(++line > lines.size()-1) line = lines.size()-1; else draw(line);
                break;
                
            case KEY_F(10):
            case 27:
                res = 0;
                finished = true;
                break;
                
            default:
                if(otherkeys) {
                    res = (*otherkeys)(this, ch);
                    if(res >= 0) finished = true;
                }

        } else {
            if(idle) (*idle)(this);
        }
    }
    
    return res;
}
