#include "konst.logic.h"
#include <stdio.h>

#define getlr \
    strncpy(rp, p+1, 126); \
    if(p1 = strpbrk(rp, "+-*/")) *p1 = 0; \
    for(i = p-expr-1; !strchr("+-*/", expr[i]) && i; i--); \
    strncpy(lp, expr+i, p-expr); \
    lp[p-expr] = 0; \
    exprlen = p-expr-i+strlen(rp)+1;

int parsecalc(char *expr) {
    char *p, *p1, lp[128], rp[128], res[128];
    int i, exprlen, k;

    if(kwordcountq(expr, " +-*/", "'") > 1 &&
    !strqpbrk(expr, 0, "=()", "'") && !strqcasestr(expr, "and", "'") &&
    !strqcasestr(expr, "or", "'") && !strqcasestr(expr, "not", "'")) {
        if(strchr(expr, '\'')) {

        } else {
            for(p = expr; p = strpbrk(p+1, "*/"); ) {
                getlr;
                switch(*p) {
                    case '*' : sprintf(res, "%d", atoi(lp) * atoi(rp)); break;
                    case '/' : sprintf(res, "%d", atoi(lp) / atoi(rp)); break;
                }

                for(k = 0; k < strlen(res); i++) expr[i] = res[k++];
                strcut(expr, i, exprlen-strlen(res));
            }

            for(p = expr; p = strpbrk(p+1, "+-"); ) {
                getlr;
                switch(*p) {
                    case '+' : sprintf(res, "%d", atoi(lp) + atoi(rp)); break;
                    case '-' : sprintf(res, "%d", atoi(lp) - atoi(rp)); break;
                }

                for(k = 0; k < strlen(res); i++) expr[i] = res[k++];
                strcut(expr, i, exprlen-strlen(res));
            }
        }
    } else return 0;
    return 1;
}

char *parsresolve(char *expr, tgetval *getval, tgetfunc *getfunc) {
    char s[1024] = "", *sout = (char *) malloc(1), *addval;
    char quote = 0, quote1, reached, inbrack[1024], param[512];
    char **fparams, wc, br;
    int i, k, j;

    sout[0] = 0;

    for(i = 0; i < strlen(expr) + 1; i++) {
        if(expr[i] == '\'') quote = !quote;
        if(!quote) {
            if(strchr("'() =<>+-*/", expr[i])) {
                if(!strchr("'0123456789", s[0]) && strcasecmp(s, "and") &&
                strcasecmp(s, "or") && strcasecmp(s, "not")) {
                    k = i;
                    for(; k < strlen(expr); k++) {
                        if(expr[k] == '(') {
                           i = k; break;
                        } else if(expr[k] != ' ') break;
                    }
                    
                    if(expr[i] == '(') {
                        quote1 = inbrack[0] = reached = br = 0;

                        for(i++; i < strlen(expr); i++) {
                            if(expr[i] == '\'') quote1 = !quote1; else
                            if(expr[i] == '(') br++;
                            
                            if(!quote1) {
                                if(expr[i] == ')' && !br--) {
                                    reached = 1;
                                    break;
                                }
                            }
                            strccat(inbrack, expr[i]);
                        }

                        if(reached) {
                            wc = kwordcountq(inbrack, ", ", "'");
                            fparams = (char **) malloc(sizeof(char *) * (wc+1));

                            for(j = 1; j <= wc; j++) {
                                kgetwordq(j, inbrack, ", ", "'", param, 512);
                                fparams[j-1] = parsresolve(param, getval, getfunc);
                                parsecalc(fparams[j-1]);
                            }

                            fparams[j-1] = 0;
                            if(!(addval = getfunc(s, fparams))) return NULL;
                            for(j = 0; j < wc; j++) free(fparams[j]);
                            free(fparams);
                        }
                        i++;
                    } else if(!(addval = getval(s))) return NULL;
                } else addval = s;

                sout = (char *) realloc(sout, strlen(sout) + strlen(addval) + 2);
                strcat(sout, addval);
                strccat(sout, expr[i]);
                s[0] = 0;
            } else strccat(s, expr[i]);
        } else strccat(sout, expr[i]);
    }
    return sout;
}

int parselogic(char *express, tgetval *getval, tgetfunc *getfunc) {

    int i, k, m, j, maxin, curin, r;
    char *pmaxin, *sidevar[2], *expr, opl, opr, wc, quote, side;
    char operation, waslogic = 0, inbrack[1024], buf[512], result;

    expr = parsresolve(express, getval, getfunc);

    do {
        maxin = quote = curin = 0;

        if(strchr(expr, '('))
        for(i = 0; i < strlen(expr); i++) {
            if(expr[i] == '\'') quote = !quote; else
            if(!quote) {
                if(expr[i] == '(') {
                    if(++curin > maxin) {
                        maxin = curin;
                        pmaxin = expr+i+1;
                    }
                } else if(expr[i] == ')') curin--;
            }
        }

        if(curin) return -1; else {
            if(maxin) {
                curin = maxin;
                inbrack[0] = quote = 0;

                for(i = 0; i < strlen(pmaxin); i++) {
                    if(pmaxin[i] == '\'') quote = !quote; else
                    if(!quote) {
                        if(pmaxin[i] == ')' && curin == maxin) {
                            k = strlen(inbrack);
                            m = i-k-1;

                            if(parsecalc(inbrack)) {
                                strncpy(&pmaxin[m], inbrack, strlen(inbrack));
                                strcut(pmaxin, m+strlen(inbrack), k-strlen(inbrack)+2);
                            } else
                            if((r = parselogic(inbrack, getval, getfunc)) > -1) {
                                pmaxin[m] = r+48;
                                strcut(pmaxin, i-strlen(inbrack), strlen(inbrack)+1);
                                i -= strlen(inbrack)-1;
                                inbrack[0] = 0;
                                curin--;
                            } else return -1;
                        } else if(pmaxin[i] == '(') {
                            curin++;
                            inbrack[0] = 0;
                            i++;
                        }
                    }
                    strccat(inbrack, pmaxin[i]);
                }
            } else {
                quote = inbrack[0] = 0;

                for(i = 0; i < strlen(expr) + 1; i++) {
                    if(expr[i] == '\'') quote = !quote; else
                    if(!quote) {
                        if(!strncasecmp(&expr[i], " or ", 4)
                        || !strncasecmp(&expr[i], " and ", 5)
                        || !expr[i]) {
                            if(!expr[i] && !waslogic) continue; else waslogic = 1;
                            if(inbrack[1]) {
                                if((r = parselogic(inbrack, getval, getfunc)) > -1) {
                                    expr[i-strlen(inbrack)] = r+48;
                                    strcut(expr, i-strlen(inbrack)+1, strlen(inbrack)-1);
                                    i -= strlen(inbrack)-1;
                                } else return -1;
                            }
                            i += 4;

                            for(k = i; k < strlen(expr); k++) {
                                if(!strncasecmp(&expr[k], "not ", 4)) {
                                    i = k + 4;
                                    break;
                                } else if(expr[k] != ' ') break;
                            }

                            inbrack[0] = 0;
                        }
                    }

                    if(!(expr[i] == ' ' && !inbrack[0])) strccat(inbrack, expr[i]);
                }

                if(waslogic) {
                    for(j = 1; j <= kwordcountq(expr, " ()", "'"); j++) {
                        k = kwordposq(j, expr, " ()", "'");
                        if(!strncasecmp(&expr[k], "not ", 4)) {
                            m = kwordposq(j+1, expr, " ()", "'");
                            expr[m] = !(expr[m] - 48) + 48;
                            strcut(expr, k, 4);
                        }
                    }
                    
                    while(expr[1]) {
                        if((wc = kwordcount(expr, " ")) < 3) return -1;
                        opl = atoi(kgetword(1, expr, " ", buf, 512));
                        opr = atoi(kgetword(3, expr, " ", buf, 512));
                        kgetword(2, expr, " ", buf, 512);

                        if(wc == 3) k = strlen(expr);
                        else k = kwordposq(4, expr, " ", "")-1;

                        if(!strcasecmp(buf, "or")) expr[0] = (opl || opr) + 48; else
                        if(!strcasecmp(buf, "and")) expr[0] = (opl && opr) + 48;

                        strcut(expr, 1, k-1);
                    }
                    return atoi(expr);
                } else {
                    inbrack[0] = quote = side = operation = 0;
                    sidevar[0] = sidevar[1] = 0;

                    for(i = 0; i < strlen(expr)+1; i++)
                    if(expr[i] != ' ') {
                        if(expr[i] == '\'') quote = !quote; else
                        if(!quote) {
                            if(strchr("=<>", expr[i]) || !expr[i]) {
                                if(!strncmp(&expr[i], "<>", 2)) operation = 1; else
                                if(expr[i] == '=') operation = 2; else
                                if(expr[i] == '<') operation = 3; else
                                if(expr[i] == '>') operation = 4;

                                sidevar[side++] = strdup(inbrack);

                                if(operation == 1) i++;
                                inbrack[0] = 0;
                                continue;
                            }
                        }

                        strccat(inbrack, expr[i]);
                    }

                    parsecalc(sidevar[0]);
                    parsecalc(sidevar[1]);

                    switch(operation) {
                        case 1: result = (strcmp(sidevar[0], sidevar[1]) != 0); break;
                        case 2: result = (strcmp(sidevar[0], sidevar[1]) == 0); break;
                        case 3: result = (atoi(sidevar[0]) < atoi(sidevar[1])); break;
                        case 4: result = (atoi(sidevar[0]) > atoi(sidevar[1])); break;
                    }

                    free(sidevar[0]);
                    free(sidevar[1]);
                    return result;
                }
            }
        }
    } while(maxin);

    return result;
}
