#ifndef __KONST_UI_TEXT_H_
#define __KONST_UI_TEXT_H_

#include <vector>

#include "konst.conf.h"
#include "konst.ui.func.h"
#include "konst.ui.skel.h"

__KTOOL_BEGIN_NAMESPACE

class textbrowser: public abstractuicontrol {
    protected:
        int ncolor;
        vector<string> lines;

        void draw(int line);

        static void freestr(char *p);
        
    public:
        int (*otherkeys)(textbrowser *caller, int k);
        void (*idle)(textbrowser *caller);
        
        textbrowser(int nx1, int ny1, int nx2, int ny2, int clr);
        textbrowser(int clr = 0);
        ~textbrowser();

        void setcolor(int clr);
        void setcoord(int nx1, int ny1, int nx2, int ny2);
        void setbuf(const char *p);
        void redraw();
	bool empty();

        int open();
};

__KTOOL_END_NAMESPACE

using ktool::textbrowser;

#endif
