#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include "catdoc.h"
#ifdef __TURBOC__
#include <dir.h>
#include <dos.h>
#endif
#if defined(MSDOS) && !defined(__MSDOS__)
#define __MSDOS__
#endif
#ifdef __WATCOMC__
extern char **_argv;
extern int _argc;
#endif
/************************************************************************/
/* Searches for file name in specified list of directories. Sets        */
/* full_path to empty string if nothing appropriate                     */
/************************************************************************/
void find_file(char *full_path,const char *name, const char *path)
{ const char *p;
  char *q;
  char dir_sep[2]={DIR_SEP,0};
    for (p=path;p;p=q+1) {
      q=strchr(p,LIST_SEP);

      if (q) {
	 strncpy(full_path,p,q-p);
	 full_path[q-p]=0;
      } else {
	q--;
	strcpy(full_path,p);
      }
      /* Empty list element means current directory */
      if (!*full_path) {
	full_path[0]='.';
	full_path[1]=0;
#ifdef __MSDOS__
      } else {
	strcpy(full_path,add_exe_path(full_path));
#endif
      }
      strcat(full_path,dir_sep);
      strcat(full_path,name);
      if (access(full_path,0)==0) {
	 return;
      }
    }
    /* if we are here, nothing found */
    *full_path=0;
    return;
}
/************************************************************************/
/* Searches for charset with given name and put pointer to malloced copy*/
/* of its name into first arg if found. Otherwise leaves first arg      */
/*  unchanged                                                           */
/************************************************************************/
void check_charset(char **filename,const char *charset) {
   char namebuf[128];
   char pathbuf[512];
   strcpy(namebuf,charset);
   strcat(namebuf,CHARSET_EXT);
   find_file(pathbuf,namebuf,charset_path);
   if (*pathbuf) {
     *filename=strdup(charset);
   }
}
/*
 * In DOS, argv[0] contain full path to the program, and it is a custom
 * to keep configuration files in same directory as program itself
 */
#ifdef __MSDOS__
char *exe_dir(void) {
  static char pathbuf[127];
  char *q;
  strcpy(pathbuf,_argv[0]);
  q=strrchr(pathbuf,DIR_SEP);
  if (q) {
    *q=0;
  } else {
    pathbuf[0]=0;
  }
  return pathbuf;
}
char *add_exe_path(const char *name) {
static char path[128];
  sprintf(path,name,exe_dir());
  return path;
}
#endif
