(* camlp4r *)
(***********************************************************************)
(*                                                                     *)
(*                             Camlp4                                  *)
(*                                                                     *)
(*        Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt     *)
(*                                                                     *)
(*  Copyright 1998 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: token.ml,v 2.2 2000/03/28 19:19:16 ddr Exp $ *)

type t = (string * string);
type pattern = (string * string);

exception Error of string;

type location_function = int -> (int * int);

type lexer =
 { func : Stream.t char -> (Stream.t t * location_function);
   using : pattern -> unit;
   removing : pattern -> unit;
   tparse : pattern -> option (Stream.t t -> string);
   text : pattern -> string }
;
