(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

val load : string -> Image.load_option list -> Image.t;;
  (* Loads a postscript image. *)

val save : string -> Image.save_option list -> Image.t -> unit;;
  (* Save a full-color image in the Encapuslated PS format file.
     Raises [Invalid_argument] if the image is not a full-color image. *)

val load_ps : string -> (int * int * int * int) option -> 
                Image.load_option list -> Image.t;;
  (* Loads a postscript image within a bounding box. *)

