/*
 * Calcoo: b_options.c
 *
 * creates and operates the options window
 *
 * Copyright (C) 2001,2002 Alexei Kaminski
 *
 */

#include <gtk/gtk.h>

#include "codes.h"
#include "b_headers.h"

#define INFO_SPACING 10
#define INFO_LINE_SPACING 5
#define RPN_BOX_BORDER_WIDTH 5

static int rpn_set, rpn_last,
	enter_set, enter_last,
	stack_set, stack_last,
	arc_set, arc_last,
	hyp_set, hyp_last;
static	GtkWidget *arc_check, *hyp_check;
static	GtkWidget *enter_radio1, *enter_radio2;
static	GtkWidget *stack_radio1, *stack_radio2;

void apply_new_options(void)
{
	if (rpn_set != rpn_last) {
		set_rpn_mode(rpn_set);
		rpn_last = rpn_set;
	}

	if (enter_set != enter_last) {
		set_enter_mode(enter_set);
		enter_last = enter_set;
	}

	if (stack_set != stack_last) {
		set_stack_mode(stack_set);
		stack_last = stack_set;
	}

	if (arc_set != arc_last) {
		set_arc_autorelease(arc_set);
		arc_last = arc_set;
	}

	if (hyp_set != hyp_last) {
		set_hyp_autorelease(hyp_set);
		hyp_last = hyp_set;
	}

	save_options();
}

void toggled_rpn_on(void)
{
	rpn_set = TRUE;
	activate_enter_mode(TRUE);
}

void toggled_rpn_off(void)
{
	rpn_set = FALSE;
	activate_enter_mode(FALSE);
}

void activate_enter_mode(int activate)
{
	if (activate) {
		gtk_widget_set_sensitive(enter_radio1, TRUE);
		gtk_widget_set_sensitive(enter_radio2, TRUE);
		gtk_widget_set_sensitive(stack_radio1, TRUE);
		gtk_widget_set_sensitive(stack_radio2, TRUE);
	} else {
		gtk_widget_set_sensitive(enter_radio1, FALSE);
		gtk_widget_set_sensitive(enter_radio2, FALSE);
		gtk_widget_set_sensitive(stack_radio1, FALSE);
		gtk_widget_set_sensitive(stack_radio2, FALSE);
	}
}

void toggled_enter_traditional(void)
{
	enter_set = ENTER_MODE_TRADITIONAL;
}

void toggled_enter_hp28(void)
{
	enter_set = ENTER_MODE_HP28;
}

void toggled_stack_infinite(void)
{
	stack_set = STACK_MODE_INFINITE;
}

void toggled_stack_xyzt(void)
{
	stack_set = STACK_MODE_XYZT;
}

void toggled_arc(void)
{
	arc_set = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(arc_check));;
}

void toggled_hyp(void)
{
	hyp_set = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hyp_check));;
}


void call_options (void)
{
	static GtkWidget *options_window = NULL;

	GtkWidget *close_button;

	GtkWidget *options_vbox; 
	GtkWidget *rpn_box, *rpn_radio1, *rpn_radio2, *rpn_frame;
	GtkWidget *enter_box, /* *enter_radio1, *enter_radio2,*/ *enter_frame;
	GtkWidget *stack_box, /* *stack_radio1, *stack_radio2,*/ *stack_frame;
	GtkWidget *archyp_box, /* *arc_check, *hyp_check,*/ *archyp_frame;
	GtkWidget *apply_button;
	GtkWidget *options_row1_box, *options_row2_box, *options_button_box;

	if (options_window)
		return;
	
/* Main info window */
	options_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(options_window), "Calcoo options");
	gtk_window_set_policy(GTK_WINDOW(options_window), FALSE, FALSE, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(options_window), 0);
	gtk_signal_connect(GTK_OBJECT(options_window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed), 
			   &options_window);
	gtk_widget_realize(options_window);
	
/* Options */

/* Options: RPN */
	rpn_radio1 = gtk_radio_button_new_with_label(NULL,"RPN");
	rpn_radio2 = gtk_radio_button_new_with_label_from_widget (
		           GTK_RADIO_BUTTON(rpn_radio1), "Algebraic");
	if (get_rpn_mode()) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rpn_radio1), 
					     TRUE);
		rpn_last = TRUE;
		rpn_set = TRUE;
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rpn_radio2), 
					     TRUE);
		rpn_set = FALSE;
		rpn_last = FALSE;
	}
	gtk_signal_connect(GTK_OBJECT (rpn_radio1), "toggled",
			   GTK_SIGNAL_FUNC (toggled_rpn_on), NULL);
	gtk_signal_connect(GTK_OBJECT (rpn_radio2), "toggled",
			   GTK_SIGNAL_FUNC (toggled_rpn_off), NULL);

	rpn_box = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start (GTK_BOX (rpn_box), rpn_radio1, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (rpn_box), rpn_radio2, TRUE, TRUE, 2);
	gtk_container_set_border_width  (GTK_CONTAINER(rpn_box), 
					 RPN_BOX_BORDER_WIDTH);
	rpn_frame = gtk_frame_new ("Mode");
	gtk_frame_set_shadow_type (GTK_FRAME(rpn_frame), GTK_SHADOW_ETCHED_IN);
	gtk_container_add(GTK_CONTAINER(rpn_frame), rpn_box);

/* Options: Enter */
	enter_radio1 = gtk_radio_button_new_with_label(NULL,"Traditional");
	enter_radio2 = gtk_radio_button_new_with_label_from_widget (
		           GTK_RADIO_BUTTON(enter_radio1), "HP-28");
	if (get_enter_mode() == ENTER_MODE_TRADITIONAL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enter_radio1), 
					     TRUE);
		enter_last = ENTER_MODE_TRADITIONAL;
		enter_set = ENTER_MODE_TRADITIONAL;
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enter_radio2), 
					     TRUE);
		enter_set = ENTER_MODE_HP28;
		enter_last = ENTER_MODE_HP28;
	}
	gtk_signal_connect(GTK_OBJECT (enter_radio1), "toggled",
			   GTK_SIGNAL_FUNC (toggled_enter_traditional), NULL);
	gtk_signal_connect(GTK_OBJECT (enter_radio2), "toggled",
			   GTK_SIGNAL_FUNC (toggled_enter_hp28), NULL);

	enter_box = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start (GTK_BOX (enter_box), enter_radio1, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (enter_box), enter_radio2, TRUE, TRUE, 2);
	gtk_container_set_border_width  (GTK_CONTAINER(enter_box), 
					 RPN_BOX_BORDER_WIDTH);
	enter_frame = gtk_frame_new ("RPN Enter");
	gtk_frame_set_shadow_type (GTK_FRAME(enter_frame), 
				   GTK_SHADOW_ETCHED_IN);
	gtk_container_add(GTK_CONTAINER(enter_frame), enter_box);

/* Options: Stack */
	stack_radio1 = gtk_radio_button_new_with_label(NULL,"Infinite");
	stack_radio2 = gtk_radio_button_new_with_label_from_widget (
		               GTK_RADIO_BUTTON(stack_radio1), "XYZT");
	if (get_stack_mode() == STACK_MODE_INFINITE) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stack_radio1), 
					     TRUE);
		stack_last = STACK_MODE_INFINITE;
		stack_set = STACK_MODE_INFINITE;
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(stack_radio2), 
					     TRUE);
		stack_set = STACK_MODE_XYZT;
		stack_last = STACK_MODE_XYZT;
	}
	gtk_signal_connect(GTK_OBJECT (stack_radio1), "toggled",
			   GTK_SIGNAL_FUNC (toggled_stack_infinite), NULL);
	gtk_signal_connect(GTK_OBJECT (stack_radio2), "toggled",
			   GTK_SIGNAL_FUNC (toggled_stack_xyzt), NULL);

	stack_box = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start (GTK_BOX (stack_box), stack_radio1, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (stack_box), stack_radio2, TRUE, TRUE, 2);
	gtk_container_set_border_width  (GTK_CONTAINER(stack_box), 
					 RPN_BOX_BORDER_WIDTH);
	stack_frame = gtk_frame_new ("RPN Stack");
	gtk_frame_set_shadow_type (GTK_FRAME(stack_frame), 
				   GTK_SHADOW_ETCHED_IN);
	gtk_container_add(GTK_CONTAINER(stack_frame), stack_box);

/* Options: arc & hyp */
/* arc */
	arc_check = gtk_check_button_new_with_label("arc button");
	if (get_arc_autorelease()) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(arc_check), 
					     TRUE);
		arc_last = TRUE;
		arc_set = TRUE;
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(arc_check), 
					     FALSE);
		arc_last = FALSE;
		arc_set = FALSE;
	}
	gtk_signal_connect(GTK_OBJECT (arc_check), "toggled",
			   GTK_SIGNAL_FUNC (toggled_arc), NULL);
/* hyp */
	hyp_check = gtk_check_button_new_with_label("hyp button");
	if (get_hyp_autorelease()) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hyp_check), 
					     TRUE);
		hyp_last = TRUE;
		hyp_set = TRUE;
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hyp_check), 
					     FALSE);
		hyp_last = FALSE;
		hyp_set = FALSE;
	}
	gtk_signal_connect(GTK_OBJECT (hyp_check), "toggled",
			   GTK_SIGNAL_FUNC (toggled_hyp), NULL);

	archyp_box = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start (GTK_BOX (archyp_box), arc_check, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (archyp_box), hyp_check, TRUE, TRUE, 2);
	gtk_container_set_border_width  (GTK_CONTAINER(archyp_box), 
					 RPN_BOX_BORDER_WIDTH);
	archyp_frame = gtk_frame_new ("Autorelease");
	gtk_frame_set_shadow_type (GTK_FRAME(archyp_frame), 
				   GTK_SHADOW_ETCHED_IN);
	gtk_container_add(GTK_CONTAINER(archyp_frame), archyp_box);

/* "Apply" button */
	apply_button = gtk_button_new_with_label("Apply");
	gtk_signal_connect(GTK_OBJECT (apply_button), "clicked",
			   GTK_SIGNAL_FUNC (apply_new_options), NULL);

/* "Close" button */
	close_button = gtk_button_new_with_label("Close");
	gtk_signal_connect_object(GTK_OBJECT(close_button), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(options_window));

/* Options: packing all together */
	options_row1_box = gtk_hbox_new (FALSE,0);
	gtk_box_set_spacing(GTK_BOX(options_row1_box), 
			    INFO_SPACING);
	gtk_box_pack_start(GTK_BOX(options_row1_box), archyp_frame, 
			   TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(options_row1_box), rpn_frame, 
			   TRUE, FALSE, 0);

	options_row2_box = gtk_hbox_new (FALSE,0);
	gtk_box_set_spacing(GTK_BOX(options_row2_box), 
			    INFO_SPACING);
	gtk_box_pack_start(GTK_BOX(options_row2_box), enter_frame, 
			   TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(options_row2_box), stack_frame, 
			   TRUE, FALSE, 0);

	options_button_box = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(options_button_box), 
				  GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(options_button_box), 
				   INFO_SPACING);
	gtk_box_pack_start(GTK_BOX(options_button_box), apply_button, 
			   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(options_button_box), close_button, 
			   TRUE, TRUE, 0);


	options_vbox = gtk_vbox_new(FALSE, INFO_LINE_SPACING);
	gtk_container_set_border_width(GTK_CONTAINER(options_vbox), 
				       INFO_SPACING);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_row1_box, 
			   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_row2_box, 
			   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_button_box, 
			   FALSE, FALSE, 20);


	gtk_container_add(GTK_CONTAINER(options_window), options_vbox);

	gtk_widget_show_all(options_window);
	activate_enter_mode(rpn_set);
}

