/*
 * Calcoo: b_accel.c
 *
 * Copyright (C) 2001,2002 Alexei Kaminski
 *
 * all about the keyboard accelerators
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "codes.h"
#include "body.h"
#include "b_headers.h"

/* One may ask why I assign accelerators here instead of body_create. 
 * The answer is to provide maximum portability. I mean that different
 * widget libraries may use different means to denote keycodes, and this
 * would make body_create.c library-dependent */
void accel_button(int, guint, guint);
void decel_button(int, guint, guint);

void assign_accel(void)
{
	body->accel_group = gtk_accel_group_new();

	accel_button(CODE_0, 0, GDK_0);
	accel_button(CODE_0, 0, GDK_KP_0);
/*	accel_button(CODE_0, 0, GDK_KP_Insert); */

	accel_button(CODE_1, 0, GDK_1);
	accel_button(CODE_1, 0, GDK_KP_1);
/*	accel_button(CODE_1, 0, GDK_KP_End); */

	accel_button(CODE_2, 0, GDK_2);
	accel_button(CODE_2, 0, GDK_KP_2);
/*	accel_button(CODE_2, 0, GDK_KP_Down); */

	accel_button(CODE_3, 0, GDK_3);
	accel_button(CODE_3, 0, GDK_KP_3);
/*	accel_button(CODE_3, 0, GDK_KP_Next); */

	accel_button(CODE_4, 0, GDK_4);
	accel_button(CODE_4, 0, GDK_KP_4);
/*	accel_button(CODE_4, 0, GDK_KP_Left); */

	accel_button(CODE_5, 0, GDK_5);
	accel_button(CODE_5, 0, GDK_KP_5);
/*	accel_button(CODE_5, 0, GDK_KP_Begin); */

	accel_button(CODE_6, 0, GDK_6);
	accel_button(CODE_6, 0, GDK_KP_6);
/*	accel_button(CODE_6, 0, GDK_KP_Right); */

	accel_button(CODE_7, 0, GDK_7);
	accel_button(CODE_7, 0, GDK_KP_7);
/*	accel_button(CODE_7, 0, GDK_KP_Home); */

	accel_button(CODE_8, 0, GDK_8);
	accel_button(CODE_8, 0, GDK_KP_8);
/*	accel_button(CODE_8, 0, GDK_KP_Up); */

	accel_button(CODE_9, 0, GDK_9);
	accel_button(CODE_9, 0, GDK_KP_9);
/*	accel_button(CODE_9, 0, GDK_KP_Prior); */

/*  	accel_button(CODE_UNDO, 0, GDK_Clear); */

	accel_button(CODE_ADD, 0, GDK_KP_Add);
	accel_button(CODE_ADD, GDK_SHIFT_MASK, GDK_plus); 

	accel_button(CODE_LEFT_PAREN, GDK_SHIFT_MASK, GDK_parenleft);
	accel_button(CODE_RIGHT_PAREN, GDK_SHIFT_MASK, GDK_parenright);

	accel_button(CODE_LEFT_PAREN, 0, GDK_bracketleft);
	accel_button(CODE_RIGHT_PAREN, 0, GDK_bracketright);

	accel_button(CODE_SUB, 0, GDK_KP_Subtract);
	accel_button(CODE_SUB, 0, GDK_minus);

	accel_button(CODE_MUL, 0, GDK_KP_Multiply);
	accel_button(CODE_MUL, GDK_SHIFT_MASK, GDK_asterisk);

	accel_button(CODE_DIV, 0, GDK_KP_Divide);
	accel_button(CODE_DIV, 0, GDK_slash);

	accel_button(CODE_POW, GDK_SHIFT_MASK, GDK_asciicircum);

	accel_button(CODE_SIN, 0, GDK_s);
	accel_button(CODE_COS, 0, GDK_c);
	accel_button(CODE_TAN, 0, GDK_t);


	accel_button(CODE_EQ, 0, GDK_equal);

	accel_button(CODE_DOT, 0, GDK_KP_Decimal);
	accel_button(CODE_DOT, 0, GDK_period);
	accel_button(CODE_DOT, 0, GDK_comma);

	accel_button(CODE_CLEAR_ALL, 0, GDK_Escape);
  	accel_button(CODE_CLEAR_ALL, 0, GDK_Delete); 

	accel_button(CODE_INFO, GDK_SHIFT_MASK, GDK_question);
	accel_button(CODE_OPTIONS, GDK_SHIFT_MASK, GDK_exclam);

	accel_button(CODE_UNDO, GDK_CONTROL_MASK, GDK_z);
/*  	accel_button(CODE_UNDO, 0, GDK_BackSpace); */

	accel_button(CODE_REDO, GDK_CONTROL_MASK, GDK_r);

	accel_button(CODE_COPY, GDK_CONTROL_MASK, GDK_c);
	accel_button(CODE_PASTE, GDK_CONTROL_MASK, GDK_v);

	accel_button(CODE_EXP, 0, GDK_e);

	accel_button(CODE_SIGN, GDK_CONTROL_MASK, GDK_KP_Subtract);
	accel_button(CODE_SIGN, GDK_CONTROL_MASK, GDK_minus);

	accel_button(CODE_EXP_SIGN, GDK_CONTROL_MASK, GDK_e);

	accel_button(CODE_EXIT, GDK_CONTROL_MASK,GDK_q);

	gtk_window_add_accel_group(GTK_WINDOW(body->main_window),
				   body->accel_group);
}

void set_accel_mode(int rpn_mode)
{
	gtk_window_remove_accel_group(GTK_WINDOW(body->main_window),
				   body->accel_group);

	if (rpn_mode) {
		decel_button(CODE_EQ, 0, GDK_Return);
		decel_button(CODE_EQ, 0, GDK_KP_Enter);
		accel_button(CODE_ENTER, 0, GDK_Return);
		accel_button(CODE_ENTER, 0, GDK_KP_Enter);
	} else {
		decel_button(CODE_ENTER, 0, GDK_Return);
		decel_button(CODE_ENTER, 0, GDK_KP_Enter);
		accel_button(CODE_EQ, 0, GDK_Return);
		accel_button(CODE_EQ, 0, GDK_KP_Enter);
	}

	gtk_window_add_accel_group(GTK_WINDOW(body->main_window),
				   body->accel_group);
}

void accel_button(int button_code, guint button_mods, guint button_key)
{
	gtk_widget_add_accelerator(body->button[button_code],
				   "clicked",
				   body->accel_group,
				   button_key, button_mods,
				   GTK_ACCEL_VISIBLE);
}

void decel_button(int button_code, guint button_mods, guint button_key)
{
	gtk_widget_remove_accelerator(body->button[button_code],
				      body->accel_group,
				      button_key, button_mods);
}


