/*
 * Calcoo: texts.h
 *
 * Copyright (C) 2001, 2002 Alexei Kaminski
 *
 */

#ifndef TEXTS_H
#define TEXTS_H

static char *about_text[] = 
{
	" ",
	NULL,
	"Calcoo 1.3.5 -  Scientific calculator",
	NULL,
	"Copyright (C) 2001, 2002 Alexei Kaminski",
	NULL,
	"Project homepage: http://calcoo.sourceforge.net/",
	NULL,
	"Please report bugs to kaminski@tpi.umn.edu",
	NULL,
	" ",
	NULL, NULL
};

static char *license_text[] =
{
	"This program is free software; you can redistribute it and/or",
	"modify it under the terms of the GNU General Public License",
	"as published by the Free Software Foundation; either version 2",
	"of the License, or (at your option) any later version.",
	NULL,
	"This program is distributed in the hope that it will be useful,",
	"but WITHOUT ANY WARRANTY; without even the implied warranty of",
	"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.",  
	"See the GNU General Public License for more details.",
	NULL,
	"You should have received a copy of the GNU General Public License",
	"along with this program; if not, write to the Free Software",
	"Foundation, Inc., 59 Temple Place - Suite 330,",
	"Boston, MA  02111-1307, USA.",
	NULL, NULL
};

static char *help_text[] =
{
	"Even though it must be clear in general how to use calcoo,",
	"some subtleties may need clarification.",
	NULL,
	"In the RPN mode, there are four registers, X, Y, Z, T, like in",
	"real RPN calculators. In the algebraic mode, the number of",
	"registers is unlimited, but only the lowest four have their",
	"contents displayed.",
	NULL,
	"Several adjacent opening parens are possible. However, calcoo",
	"will show only one paren in the corresponding display, due to",
	"display limitations. Calcoo does keep track of all of them, even",
	"though it is unable to show them.",
	NULL,
	"The closing paren button acts as \"=\" button if there are no",
	"matching opening parens.",
	NULL,
	"If an expression begins with an opening paren, the paren will",
	"not be displayed (actually the paren will be ignored).",
	"Nevertheless, you should go ahead and type the whole expression,",
	"since an unmatched closing paren acts as \"=\", the whole",
	"expression will be evaluated properly, as though the (ignored)",
	"opening paren and the closing paren (interpreted as \"=\") were",
	"interpreted as parens.",
	NULL,
	"Undo remembers only the last 64 elementary actions.",
	NULL,
	"Switching between RPN and algebraic modes does reset undo.",
	" ",
	NULL, NULL
};

static char *shortcuts_text[] =
{
	"Esc", "clear all registers",
	"0 1 2 3 4 5 6 7 8 9", "corresponding digits",
	". ,",  ".",
	"+ - * / ^", "corresponding binary operations",
	"s c t", "sin cos tan",
	"( [  ] )", "( )",
	"Enter, =", "evaluate (algebraic mode)",
	"Enter", "enter (RPN mode)",
	"Ctrl-z Ctrl-r", "undo redo",
	"Ctrl-c Ctrl-v", "copy paste",
	"Ctrl--", "change sign",
	"e", "E",
	"Ctrl-e", "change exp sign",
	"?", "info/help",
	"!", "options",
	NULL, NULL, NULL, NULL
};



static char *version_console[] =
{
	"calcoo 1.3.5",
	NULL
};

static char *help_console[] =
{
	"",
	"Calcoo - scientific calculator (GTK+) Version 1.3.5",
	"Copyright (C) 2001, 2002 Alexei Kaminski (kaminski@tpi.umn.edu)",
	"Valid options:",
	"    -v, --version for version info",
	"    -h, --help to see this help",
	" Run \"calcoo\" to start the program",
	"",
	NULL
};

static char *invalid_console[] =
{
	"Invalid option. Run \"calcoo -h\" to see the list of valid options.",
	NULL
};

#endif
