# aclocal.m4 generated automatically by aclocal 1.5

# Copyright 1996, 1997, 1998, 1999, 2000, 2001
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

#serial 1
# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)


dnl CHECK_READLINE checks for presence of readline on the
dnl system.

AC_DEFUN([CHECK_READLINE], [

AC_ARG_ENABLE(readline,
	[  --disable-readline      disable readline support ],
	[use_readline=$enableval],
	[use_readline=yes])  dnl Defaults to ON (if found)

if test "$use_readline" = "yes"; then
	AC_CHECK_LIB(curses, tputs, LIBS="$LIBS -lcurses",
		AC_CHECK_LIB(ncurses, tputs))
	AC_CHECK_LIB(readline, readline)

	AC_SEARCH_LIBS(add_history, history,
		AC_DEFINE(HAVE_ADD_HISTORY, 1, [Define if you have the add_history function])
	)

	AC_CHECK_HEADERS(history.h readline/history.h readline.h readline/readline.h)

	# Check for rl_completion_matches as in readline 4.2
	AC_CHECK_FUNCS(rl_completion_matches)
	
	msg_readline="enabled"
else
	msg_readline="disabled"
fi

])


# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

#
# Usage:
#
#      NEON_LIBRARY
# or   NEON_BUNDLED(srcdir, [ACTIONS-IF-BUNDLED], [ACTIONS-IF-NOT_BUNDLED]) 
# or   NEON_VPATH_BUNDLED(srcdir, builddir, 
#			  [ACTIONS-IF-BUNDLED], [ACTIONS-IF-NOT-BUNDLED])
#
#   where srcdir is the location of bundled neon 'src' directory.
#   If using a VPATH-enabled build, builddir is the location of the
#   build directory corresponding to srcdir.
#
#   If a bundled build *is* being used, ACTIONS-IF-BUNDLED will be
#   evaluated. These actions should ensure that 'make' is run
#   in srcdir, and that one of NEON_NORMAL_BUILD or NEON_LIBTOOL_BUILD 
#   is called.
#
# After calling one of the above macros, if the NEON_NEED_XML_PARSER
# variable is set to "yes", then you must configure an XML parser
# too. You can do this your own way, or do it easily using the
# NEON_XML_PARSER() macro. Example usage for where we have bundled the
# neon sources in a directory called libneon, and bundled expat
# sources in a directory called 'expat'.
#
#   NEON_BUNDLED(libneon, [
#	NEON_XML_PARSER(expat)
#	NEON_NORMAL_BUILD
#   ])
#
# Alternatively, for a simple standalone app with neon as a
# dependancy, use just:
#
#   NEON_LIBRARY
# 
# and rely on the user installing neon correctly.
#
# You are free to configure an XML parser any other way you like,
# but the end result must be, either expat or libxml will get linked
# in, and HAVE_EXPAT or HAVE_LIBXML is defined appropriately.
#
# To set up the bundled build environment, call 
#
#    NEON_NORMAL_BUILD
# or
#    NEON_LIBTOOL_BUILD
# 
# depending on whether you are using libtool to build, or not.
# Both these macros take an optional argument specifying the set
# of object files you wish to build: if the argument is not given,
# all of neon will be built.

AC_DEFUN([NEON_BUNDLED],[

neon_bundled_srcdir=$1
neon_bundled_builddir=$1

NEON_COMMON_BUNDLED([$2], [$3])

])

AC_DEFUN([NEON_VPATH_BUNDLED],[

neon_bundled_srcdir=$1
neon_bundled_builddir=$2
NEON_COMMON_BUNDLED([$3], [$4])

])

AC_DEFUN([NEON_COMMON_BUNDLED],[

AC_PREREQ(2.50)

AC_ARG_WITH(included-neon,
AC_HELP_STRING([--with-included-neon], [force use of included neon library]),
[neon_force_included="$withval"],
[neon_force_included="no"])

NEON_COMMON

# The colons are here so there is something to evaluate
# in case the argument was not passed.
if test "$neon_force_included" = "yes"; then
	:
	$1
else
	:
	$2
fi

])

dnl Not got any bundled sources:
AC_DEFUN([NEON_LIBRARY],[

AC_PREREQ(2.50)
neon_force_included=no
neon_bundled_srcdir=
neon_bundled_builddir=

NEON_COMMON

])

AC_DEFUN([NEON_VERSIONS], [

# Define the current versions.
NEON_VERSION_MAJOR=0
NEON_VERSION_MINOR=18
NEON_VERSION_RELEASE=3
NEON_VERSION_TAG=

NEON_VERSION="${NEON_VERSION_MAJOR}.${NEON_VERSION_MINOR}.${NEON_VERSION_RELEASE}${NEON_VERSION_TAG}"

# The libtool interface version is "current:revision:age".  This 
# is what the libtool manual says about how to update it:
#
# if new release is forwards&backwards compatible with previous:
#    revision++
# if new release is not backwards compatible with old:
#    current++, revision=age=0
# if new release is backwards but not forwards compatible with old:
#    current++, age++, revision=0

NEON_INTERFACE_VERSION="18:1:0"

AC_DEFINE_UNQUOTED(NEON_VERSION, "${NEON_VERSION}", 
	[Define to be the neon version string])
AC_DEFINE_UNQUOTED(NEON_VERSION_MAJOR, [(${NEON_VERSION_MAJOR})],
	[Define to be major number of neon version])
AC_DEFINE_UNQUOTED(NEON_VERSION_MINOR, [(${NEON_VERSION_MINOR})],
	[Define to be minor number of neon version])

])

dnl Define the minimum required version
AC_DEFUN([NEON_REQUIRE], [
neon_require_major=$1
neon_require_minor=$2
])

dnl Check that the external library found in a given location
dnl matches the min. required version (if any).  Requires that
dnl NEON_CONFIG be set the the full path of a valid neon-config
dnl script
dnl
dnl Usage:
dnl    NEON_CHECK_VERSION([ACTIONS-IF-OKAY[, ACTIONS-IF-FAILURE]])
dnl
AC_DEFUN([NEON_CHECK_VERSION], [

if test "x$neon_require_major" = "x"; then
    # Nothing to check.
    : 
    $1
else
    # Check whether the library is of required version
    oLIBS="$LIBS"
    oCFLAGS="$CFLAGS"
    CFLAGS="$CFLAGS `$NEON_CONFIG --cflags`"
    LIBS="$LIBS `$NEON_CONFIG --libs`"
    neon_ver=`$NEON_CONFIG --version | sed -e "s/neon //g"`
    AC_MSG_CHECKING([linking against neon])
    AC_TRY_LINK([#include <ne_utils.h>], [int i = ne_version_minimum(0,0)], [
    AC_MSG_RESULT([okay])
    AC_MSG_CHECKING(for neon library version)

    AC_TRY_RUN([
#include <ne_utils.h>
    
int main(void) {
return ne_version_minimum($neon_require_major, $neon_require_minor);
}
], [
    AC_MSG_RESULT([okay (found neon $neon_ver)])
    LIBS="$oLIBS"
    CFLAGS="$oCFLAGS"
    $1
], [
    AC_MSG_RESULT([failed, found $neon_ver wanted >=$neon_require_major.$neon_require_minor])
    LIBS="$oLIBS"
    CFLAGS="$oCFLAGS"
    $2
])
], [
    AC_MSG_RESULT([failed (see config.log for details)])
    AC_MSG_NOTICE([may be an incompatible version: neon $neon_require_major.$neon_require_minor is required, found $neon_ver.])
    LIBS="$oLIBS"
    CFLAGS="$oCFLAGS"
    $2
])

fi

])

dnl NEON_CHECK_SUPPORT(feature, var)
AC_DEFUN([NEON_CHECK_SUPPORT], [
if $NEON_CONFIG --support $1 >/dev/null; then
   neon_$1_message="supported by neon"
   $2=yes
else
   neon_$1_message="not supported by neon"
   $2=no
fi
])

AC_DEFUN([NEON_USE_EXTERNAL], [
# Configure to use an external neon, given a neon-config script
# found at $NEON_CONFIG.
neon_prefix=`$NEON_CONFIG --prefix`
NEON_CHECK_VERSION([
    CFLAGS="$CFLAGS `$NEON_CONFIG --cflags`"
    NEON_LIBS="$NEON_LIBS `$NEON_CONFIG --libs`"
    neon_library_message="library in ${neon_prefix} (`$NEON_CONFIG --version`)"
    neon_xml_parser_message="using whatever neon uses"
    NEON_CHECK_SUPPORT([ssl], [NEON_SUPPORTS_SSL])
    NEON_CHECK_SUPPORT([zlib], [NEON_SUPPORTS_ZLIB])
    neon_got_library=yes
], [neon_got_library=no])
])

AC_DEFUN([NEON_COMMON],[

AC_REQUIRE([NEON_COMMON_CHECKS])

NEON_VERSIONS

AC_ARG_WITH(neon,
[  --with-neon[[=DIR]]       specify location of neon library],
[case $withval in
yes|no) neon_force_external=$withval; neon_ext_path= ;;
*) neon_force_external=yes; neon_ext_path=$withval ;;
esac;], [
neon_force_external=no
neon_ext_path=
])

if test "$neon_force_included" = "no"; then
    # There is no included neon source directory, or --with-included-neon
    # wasn't given (so we're not forced to use it).

    # Default to no external neon.
    neon_got_library=no
    if test "x$neon_ext_path" = "x"; then
	AC_PATH_PROG([NEON_CONFIG], neon-config, none)
	if test "x${NEON_CONFIG}" = "xnone"; then
	    AC_MSG_NOTICE([no external neon library found])
	elif test -x "${NEON_CONFIG}"; then
	    NEON_USE_EXTERNAL
	else
	    AC_MSG_NOTICE([ignoring non-executable ${NEON_CONFIG}])
	fi
    else
	AC_MSG_CHECKING([for neon library in $neon_ext_path])
	NEON_CONFIG="$neon_ext_path/bin/neon-config"
	if test -x ${NEON_CONFIG}; then
	    AC_MSG_RESULT([found])
	    NEON_USE_EXTERNAL
	else
	    AC_MSG_RESULT([not found])
	    # ...will fail since force_external=yes
	fi
    fi

    if test "$neon_got_library" = "no"; then 
	if test $neon_force_external = yes; then
	    AC_MSG_ERROR([could not use external neon library])
	elif test -n "$neon_bundled_srcdir"; then
	    # Couldn't find external neon, forced to use bundled sources
	    neon_force_included="yes"
	else
	    # Couldn't find neon, and don't have bundled sources
	    AC_MSG_ERROR(could not find neon)
	fi
    fi
fi

# This isn't a simple 'else' branch, since neon_force_included
# is set to yes if the search fails.

if test "$neon_force_included" = "yes"; then
    AC_MSG_NOTICE([using bundled neon ($NEON_VERSION)])
    NEON_BUILD_BUNDLED="yes"
    LIBNEON_SOURCE_CHECKS
    CFLAGS="$CFLAGS -I$neon_bundled_srcdir"
    NEON_LIBS="-L$neon_bundled_builddir -lneon $NEON_LIBS"
    NEON_NEED_XML_PARSER=yes
    neon_library_message="included libneon (${NEON_VERSION})"
else
    # Don't need to configure an XML parser
    NEON_NEED_XML_PARSER=no
    NEON_BUILD_BUNDLED="yes"
fi

AC_SUBST(NEON_BUILD_BUNDLED)

])

dnl Replacement for AC_SEARCH_LIBS, adds to NEON_LIBS instead.
AC_DEFUN([NE_SEARCH_LIBS], [
AC_MSG_CHECKING([for library containing $1])

AC_TRY_LINK_FUNC($1, [AC_MSG_RESULT(none needed)], [
ne_save_LIBS=$LIBS
LIBS="$LIBS $NEON_LIBS"
ne_found=0
for l in $2; do
    LIBS="$LIBS -l$l"
    AC_TRY_LINK_FUNC($1, [AC_MSG_RESULT([-l$l])
    NEON_LIBS="$NEON_LIBS -l$l"
    ne_found=1
    break])
done
if test $ne_found = 0; then
   AC_MSG_RESULT(not found)
   AC_MSG_ERROR([could not find library for $1])
fi
LIBS=$ne_save_LIBS
])
])

AC_DEFUN([NEON_ZLIB], [

AC_ARG_WITH(zlib, AC_HELP_STRING([--without-zlib], [disable zlib support]),
ne_use_zlib=$withval, ne_use_zlib=yes)

NEON_SUPPORTS_ZLIB=no
if test "$ne_use_zlib" = "yes"; then
    AC_CHECK_HEADER(zlib.h, [
  	AC_CHECK_LIB(z, inflate, [ 
	    NEON_EXTRAOBJS="$NEON_EXTRAOBJS ne_compress"
	    NEON_LIBS="$NEON_LIBS -lz"
	    NEON_CFLAGS="$NEON_CFLAGS -DNEON_ZLIB"
	    neon_zlib_message="found zlib in -lz"
	    NEON_SUPPORTS_ZLIB=yes	
	], [neon_zlib_message="zlib not found"])
    ], [neon_zlib_message="zlib not found"])
else
    neon_zlib_message="zlib disabled"
fi

AC_SUBST(NEON_SUPPORTS_ZLIB)

])

AC_DEFUN([NE_MACOSX], [

# Check for Mac OS X 10.1 which needs extra cpp and linker flags.

AC_MSG_CHECKING([for Mac OS X 10.1])
case `uname -s 2>/dev/null`:`uname -r 2>/dev/null` in
Darwin:5.*)
  AC_MSG_RESULT([yes])
  CPPFLAGS="$CPPFLAGS -no-cpp-precomp"
  LDFLAGS="$LDFLAGS -flat_namespace"
;;
*) AC_MSG_RESULT([no]) ;;
esac

])

AC_DEFUN([NEON_COMMON_CHECKS], [

# Checks done whether or not the bundled neon build is used

AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([AC_PROG_CC_STDC])
AC_REQUIRE([AC_LANG_C])
AC_REQUIRE([AC_ISC_POSIX])
AC_REQUIRE([AC_C_INLINE])
AC_REQUIRE([AC_C_CONST])

AC_REQUIRE([NE_MACOSX])

AC_REQUIRE([AC_PROG_MAKE_SET])

AC_REQUIRE([AC_HEADER_STDC])

AC_CHECK_HEADERS([errno.h stdarg.h string.h stdlib.h])

NEON_FORMAT(size_t)
NEON_FORMAT(off_t)

])

AC_DEFUN([NEON_FORMAT_PREP], [
AC_CHECK_SIZEOF(int)
AC_CHECK_SIZEOF(long)
AC_CHECK_SIZEOF(long long)
])

dnl NEON_FORMAT(type[, HEADERS]) checks how to print integer
dnl type; which may be defined in HEADERS if given.
AC_DEFUN([NEON_FORMAT], [

AC_REQUIRE([NEON_FORMAT_PREP])

AC_CHECK_SIZEOF($1, [$2])

AC_CACHE_CHECK([how to print $1], [ne_cv_fmt_$1], [
ne_cv_fmt_$1=none
if test "$GCC" = yes; then
  oflags="$CPPFLAGS"
  # Consider format string mismatches as errors
  CPPFLAGS="$CPPFLAGS -Wformat -Werror"
  for str in d ld qd; do
    AC_TRY_COMPILE([#include <sys/types.h>
$2
#include <stdio.h>], [$1 i = 1; printf("%$str", i);], 
	[ne_cv_fmt_$1=$str; break])
  done
  CPPFLAGS=$oflags
else
  # Best guess. Don't have to be too precise since we probably won't
  # get a warning message anyway.
  case $ac_cv_sizeof_$1 in
  $ac_cv_sizeof_int) ne_cv_fmt_$1="d" ;;
  $ac_cv_sizeof_long) ne_cv_fmt_$1="ld" ;;
  # Maybe lld is a better guess for non-gcc
  $ac_cv_sizeof_long_long) ne_cv_fmt_$1="lld" ;;
  esac
fi
])

if test "x$ne_cv_fmt_$1" = "xnone"; then
  AC_MSG_ERROR([format string for $1 not found])
fi

AC_DEFINE_UNQUOTED([NE_FMT_]translit($1, a-z, A-Z), "$ne_cv_fmt_$1", 
	[Define to be printf format string for $1])
])

dnl Call these checks when compiling the libneon source package.

AC_DEFUN([LIBNEON_SOURCE_CHECKS],[

dnl Run all the normal C language/compiler tests
AC_REQUIRE([NEON_COMMON_CHECKS])

dnl Needed for building the MD5 code.
AC_REQUIRE([AC_C_BIGENDIAN])

AC_CHECK_HEADERS([strings.h sys/time.h limits.h sys/select.h arpa/inet.h \
	signal.h sys/socket.h netinet/in.h])

AC_REPLACE_FUNCS(strcasecmp)

AC_CHECK_FUNCS(signal setvbuf setsockopt)

dnl Unixware 7 can only link gethostbyname with -lnsl -lsocket
dnl So, pick up -lsocket first, then the gethostbyname check
dnl will work.
NE_SEARCH_LIBS(socket, socket inet)

NE_SEARCH_LIBS(gethostbyname, nsl)

AC_MSG_CHECKING([for SIGPIPE in signal.h])
AC_CACHE_VAL(ac_cv_sigpipe_in_signal_h, [
AC_EGREP_CPP(sigpipe_yes,
  [#include <signal.h>
  #ifdef SIGPIPE
       sigpipe_yes
   #endif
  ], ac_cv_sigpipe_in_signal_h=yes, ac_cv_sigpipe_in_signal_h=no)])
AC_MSG_RESULT($ac_cv_sigpipe_in_signal_h)

if test "$ac_cv_sigpipe_in_signal_h" = "yes" ; then
  AC_DEFINE(HAVE_SIGPIPE, 1, [Defined if signal.h defines SIGPIPE.])
fi

dnl timezone
AC_MSG_CHECKING(for tm_gmtoff in struct tm)
AC_TRY_COMPILE([#include <time.h>], [
struct tm t;
t.tm_gmtoff = 1;
], [AC_MSG_RESULT(yes)
AC_DEFINE([HAVE_TM_GMTOFF], 1, [Defined if struct tm has a tm_gmtoff field])
], 
[AC_MSG_RESULT(no)
AC_MSG_WARN([timezone handling may be broken on this platform])])

ifdef([neon_no_zlib], [
    neon_zlib_message="zlib disabled"
    NEON_SUPPORTS_ZLIB=no
], [
    NEON_ZLIB()
])

# Conditionally enable ACL support
AC_MSG_CHECKING([whether to enable ACL support in neon])
if test "x$neon_no_acl" = "xyes"; then
    AC_MSG_RESULT(no)
else
    AC_MSG_RESULT(yes)
    NEON_EXTRAOBJS="$NEON_EXTRAOBJS ne_acl"
fi

NEON_SSL()
NEON_SOCKS()

AC_SUBST(NEON_CFLAGS)
AC_SUBST(NEON_LIBS)

])

dnl Call to put lib/snprintf.o in LIBOBJS and define HAVE_SNPRINTF_H
dnl if snprintf isn't in libc.

AC_DEFUN([NEON_REPLACE_SNPRINTF], [

dnl Check for snprintf
AC_CHECK_FUNC(snprintf,,
	AC_DEFINE(HAVE_SNPRINTF_H, 1, [Define if need to include snprintf.h])
	LIBOBJS="$LIBOBJS lib/snprintf.o" )

])

dnl turn off webdav, boo hoo.
AC_DEFUN([NEON_WITHOUT_WEBDAV], [
neon_no_webdav=yes
neon_no_acl=yes
NEON_NEED_XML_PARSER=no
neon_xml_parser_message="none needed"
])

dnl Turn off zlib support
AC_DEFUN([NEON_WITHOUT_ZLIB], [
define(neon_no_zlib, yes)
])

AC_DEFUN([NEON_WITHOUT_ACL], [
# Turn off ACL support
neon_no_acl=yes
])

dnl Common macro to NEON_LIBTOOL_BUILD and NEON_NORMAL_BUILD
dnl Sets NEONOBJS appropriately if it has not already been set.
dnl 
dnl NOT FOR EXTERNAL USE: use LIBTOOL_BUILD or NORMAL_BUILD.
dnl

AC_DEFUN([NEON_COMMON_BUILD], [

# Using the default set of object files to build.
# Add the extension to EXTRAOBJS
ne="$NEON_EXTRAOBJS"
NEON_EXTRAOBJS=
for o in $ne; do
	NEON_EXTRAOBJS="$NEON_EXTRAOBJS $o.$NEON_OBJEXT"
done	

AC_MSG_CHECKING(whether to enable WebDAV support in neon)

dnl Did they want DAV support?
if test "x$neon_no_webdav" = "xyes"; then
  # No WebDAV support
  AC_MSG_RESULT(no)
  NEONOBJS="$NEONOBJS \$(NEON_BASEOBJS)"
  NEON_CFLAGS="$NEON_CFLAGS -DNEON_NODAV"
  NEON_SUPPORTS_DAV=no
  AC_DEFINE(NEON_NODAV, 1, [Enable if built without WebDAV support])
else
  # WebDAV support
  NEON_SUPPORTS_DAV=yes
  NEONOBJS="$NEONOBJS \$(NEON_DAVOBJS)"
  # Turn on DAV locking please then.
  AC_DEFINE(USE_DAV_LOCKS, 1, [Support WebDAV locking through the library])

  AC_MSG_RESULT(yes)

fi

AC_SUBST(NEON_TARGET)
AC_SUBST(NEON_OBJEXT)
AC_SUBST(NEONOBJS)
AC_SUBST(NEON_EXTRAOBJS)
AC_SUBST(NEON_LINK_FLAGS)
AC_SUBST(NEON_SUPPORTS_DAV)

])

# The libtoolized build case:
AC_DEFUN([NEON_LIBTOOL_BUILD], [

NEON_TARGET=libneon.la
NEON_OBJEXT=lo

NEON_COMMON_BUILD($#, $*)

])

# The non-libtool build case:
AC_DEFUN([NEON_NORMAL_BUILD], [

NEON_TARGET=libneon.a
NEON_OBJEXT=o

AC_CHECK_TOOL(AR, ar, :)
AC_CHECK_TOOL(RANLIB, ranlib, :)

NEON_COMMON_BUILD($#, $*)

])

# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

# $1 specifies the location of the bundled neon "src" directory, or
# is empty if none is bundled. $1 specifies the location of the bundled
# expat directory, or is empty if none is bundled.

AC_DEFUN([NEON_SSL],[

AC_ARG_WITH(ssl, 
[  --with-ssl[[=DIR]]        enable OpenSSL support],,
	[with_ssl="no"])

# In an ideal world, we would default to with_ssl="yes".
# But this might lead to packagers of neon-enabled apps
# unknowingly exporting crypto binaries.

AC_MSG_CHECKING(for OpenSSL)

if test "$with_ssl" = "yes"; then
	# They didn't specify a location: look in
	# some usual places
	neon_ssl_dirs="/usr/local/ssl /usr/local /usr/ssl /usr"
	neon_ssl_location=""

	for d in $neon_ssl_dirs; do
		if test -r $d/include/openssl/ssl.h; then
			neon_ssl_location=$d
			break
		fi
	done
elif test "$with_ssl" = "no"; then
	neon_ssl_location=""
else
	neon_ssl_location=$with_ssl
fi

if test -n "$neon_ssl_location"; then
	CFLAGS="$CFLAGS -I${neon_ssl_location}/include"
	NEON_LIBS="$NEON_LIBS -L${neon_ssl_location}/lib -lssl -lcrypto"
	AC_DEFINE([ENABLE_SSL], 1, [Define to enable OpenSSL support])
	AC_MSG_RESULT(found in $neon_ssl_location)
	neon_ssl_message="OpenSSL in $neon_ssl_location"
	NEON_SUPPORTS_SSL=yes
	NEON_CFLAGS="$NEON_CFLAGS -DNEON_SSL"
	if test "$neon_ssl_location" != "/usr"; then
		# Never export -I/usr/include, it's pointless, and may
		# override later includes for applications using the
		# `neon-config --cflags` output.
		NEON_CFLAGS="$NEON_CFLAGS -I${neon_ssl_location}/include"
	fi
else
	neon_ssl_message="No SSL support"
	NEON_SUPPORTS_SSL=no
	AC_MSG_RESULT(not found)
fi

AC_SUBST(NEON_SUPPORTS_SSL)

])


# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

# Following instructions at:
# http://www.socks.nec.com/how2socksify.html

AC_DEFUN([NEON_SOCKS], [

AC_ARG_WITH([--with-socks], 
[  --with-socks[[=DIR]]      Use SOCKS library],
[
if test "$withval" != "no"; then

  if test "$withval" != "yes"; then
	LDFLAGS="$LDFLAGS -L$withval/lib"
	CFLAGS="$CFLAGS -I$withval/include"
  fi

  AC_CHECK_HEADERS(sock.h)

  CFLAGS="$CFLAGS -DSOCKS"

  AC_CHECK_LIB(socks5, connect, [NEON_LIBS="$NEON_LIBS -lsocks5"],
      AC_MSG_ERROR([could not find libsocks5 for SOCKS support]))

fi

])

])


# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

# Check for XML parser.
# Supports:
#  *  libxml 1.x (requires version 1.8.3 or later)
#  *  libxml 2.x
#  *  jclark expat in -lexpat (custom build)
#  *  new expat in -lexpat
#  *  expat in -lxmlparse and -lxmltok (as packaged by Debian/Red Hat)
#  *  Bundled expat if a directory name argument is passed
#     -> expat dir must contain minimal expat sources, i.e.
#        xmltok, xmlparse sub-directories.  See sitecopy/cadaver for
#	 examples of how to do this.
#
# Usage: 
#  NEON_XML_PARSER()
# or
#  NEON_XML_PARSER(expat-dir)
#
# FIXME: needs to take second arg for VPATH builds

AC_DEFUN([NEON_XML_EXTERNAL_EXPAT], [
case $neon_expat_dir in
*/libexpat.la)
	neon_using_libtool_expat=yes
	neon_expat_dir=`echo $neon_expat_dir | sed 's:/libexpat.la$::'`
esac
if test -r "$neon_expat_dir/xmlparse.h"; then
	AC_DEFINE(HAVE_XMLPARSE_H, 1, [Define if you have xmlparse.h])
	AC_DEFINE(HAVE_EXPAT, 1, [Define if you have expat])
	CFLAGS="$CFLAGS -I$neon_expat_dir"
	dnl add the library (if it isn't a libtool library)
	if test -z "$neon_using_libtool_expat"; then
		NEON_LIBS="$NEON_LIBS -L$neon_expat_dir -lexpat"
	fi
	neon_xml_parser_message="expat in $neon_expat_dir"
	neon_found_parser="yes"
fi
])

AC_DEFUN([NEON_XML_SYSTEM_EXPAT], [
ne_found_hdr=no
AC_CHECK_HEADERS(expat.h xmlparse.h xmltok/xmlparse.h, ne_found_hdr=yes)
if test "$ne_found_hdr" = "yes"; then
ne_found_lib=no
AC_CHECK_LIB(expat, XML_Parse, ne_found_lib="-lexpat",
AC_CHECK_LIB(xmlparse, XML_Parse, ne_found_lib="-lxmltok -lxmlparse",,-lxmltok))
if test "$ne_found_lib" != "no"; then
	AC_DEFINE(HAVE_EXPAT, 1, [Define if you have expat])
	NEON_LIBS="$NEON_LIBS $ne_found_lib"
	neon_xml_parser_message="expat in $ne_found_lib"
	neon_found_parser="expat"
fi
fi
])

AC_DEFUN([NEON_XML_LIBXML2], [
# Check for libxml2
AC_CHECK_PROG(XML2_CONFIG, xml2-config, xml2-config)
if test "$XML2_CONFIG" != ""; then
	neon_found_parser="libxml2"
	neon_xml_parser_message="libxml `$XML2_CONFIG --version`"
	AC_DEFINE(HAVE_LIBXML, 1, [Define if you have libxml])
	CPPFLAGS="$CPPFLAGS `$XML2_CONFIG --cflags | sed 's| -I/include||g'`"
	NEON_LIBS="$NEON_LIBS `$XML2_CONFIG --libs`"
	AC_CHECK_HEADERS(xmlversion.h)
fi
])

AC_DEFUN([NEON_XML_LIBXML1], [
# Have we got libxml 1.8.3 or later?
AC_CHECK_PROG(XML_CONFIG, xml-config, xml-config)
if test "$XML_CONFIG" != ""; then
	# Check for recent library
	oLIBS="$LIBS"
	NEWLIBS="`$XML_CONFIG --libs`"
	LIBS="$LIBS $NEWLIBS"
	AC_CHECK_LIB(xml, xmlCreatePushParserCtxt,
		neon_found_parser="libxml" 
		CPPFLAGS="$CPPFLAGS `$XML_CONFIG --cflags`"
		neon_xml_parser_message="libxml `$XML_CONFIG --version`"
		AC_DEFINE(HAVE_LIBXML, 1, [Define if you have libxml])
		NEON_LIBS="$NEON_LIBS $NEWLIBS"
		,
		AC_WARN([cannot use old libxml (1.8.3 or newer required)])
	)
	LIBS="$oLIBS"
fi
])

AC_DEFUN([NEON_XML_PARSER], [

if test "$NEON_NEED_XML_PARSER" = "yes"; then

neon_xml_choice="none"
neon_found_parser="none"

AC_ARG_WITH([libxml1],
AC_HELP_STRING([--with-libxml1], [force use of libxml 1.x]),
[if test "$withval" = "yes"; then
   neon_xml_choice=libxml1
fi])

AC_ARG_WITH([libxml2],
AC_HELP_STRING([--with-libxml2], [force use of libxml 2.x]),
[if test "$withval" = "yes"; then
   neon_xml_choice=libxml2
fi])

AC_ARG_WITH([expat],
[  --with-expat[[=DIR]]      force use of (specified) expat],
[
case $withval in
yes) neon_xml_choice=findexpat ;;
no) : ;;
*) neon_xml_choice=thisexpat
   neon_expat_dir=$withval ;;
esac
])

ifelse($#, 1, [
AC_ARG_WITH([included-expat],
AC_HELP_STRING([--with-included-expat], [use bundled expat sources]),
[if test "$withval" = "yes"; then
   neon_xml_choice=skip
fi])
])

echo Choice of XML parser is $neon_xml_choice >&5

case $neon_xml_choice in
skip) : ;;
none)
	# Try them all.
	NEON_XML_LIBXML2
	if test "$neon_found_parser" = "none"; then
		NEON_XML_LIBXML1
		if test "$neon_found_parser" = "none"; then
			NEON_XML_SYSTEM_EXPAT
		fi
	fi
	;;
thisexpat) NEON_XML_EXTERNAL_EXPAT ;;
findexpat) NEON_XML_SYSTEM_EXPAT ;;
libxml1) NEON_XML_LIBXML1 ;;
libxml2) NEON_XML_LIBXML2 ;;
esac

if test "$neon_found_parser" = "none"; then
	ifelse($#, 1, [

	AC_REQUIRE([AC_C_BIGENDIAN])
	# Define XML_BYTE_ORDER for expat sources.
	if test $ac_cv_c_bigendian = "yes"; then
		ne_border=21
	else
		ne_border=12
	fi

	# mini-expat doesn't pick up config.h
	CPPFLAGS="$CPPFLAGS -DXML_BYTE_ORDER=$ne_border"

	# Use the bundled expat sources
	LIBOBJS="$LIBOBJS $1/xmltok/xmltok.o $1/xmltok/xmlrole.o $1/xmlparse/xmlparse.o $1/xmlparse/hashtable.o"
	CFLAGS="$CFLAGS -DXML_DTD -I$1/xmlparse -I$1/xmltok"
	AC_DEFINE(HAVE_EXPAT, 1, [Define if you have expat])
	AC_DEFINE(HAVE_XMLPARSE_H, 1, [Define if you have xmlparse.h])
	neon_xml_parser_message="supplied expat in $1"
    ], [
	AC_MSG_ERROR([no XML parser was found: expat or libxml>=1.8.3 required])
    ])
fi

AC_MSG_NOTICE([XML parser found: $neon_xml_parser_message])

fi

])

#serial 6

dnl This macro is intended to be used solely in this file.
dnl These are the prerequisite macros for GNU's strftime.c replacement.
dnl FIXME: the list is far from complete
AC_DEFUN(_jm_STRFTIME_PREREQS,
[
 dnl strftime.c uses localtime_r if it exists.  Check for it.
 AC_CHECK_FUNCS(localtime_r)
 dnl FIXME: add tests for everything in strftime.c: e.g., HAVE_BCOPY,
 dnl HAVE_TZNAME, HAVE_TZSET, HAVE_TM_ZONE, etc.
])

dnl Determine if the strftime function has all the features of the GNU one.
dnl
dnl From Jim Meyering.
dnl
AC_DEFUN(jm_FUNC_GNU_STRFTIME,
[AC_REQUIRE([AC_HEADER_TIME])dnl

 _jm_STRFTIME_PREREQS

 AC_REQUIRE([AC_C_CONST])dnl
 AC_REQUIRE([AC_HEADER_STDC])dnl
 AC_CHECK_HEADERS(sys/time.h)
 AC_CACHE_CHECK([for working GNU strftime], jm_cv_func_working_gnu_strftime,
  [AC_TRY_RUN(
changequote(<<, >>)dnl
<< /* Ulrich Drepper provided parts of the test program.  */
#if STDC_HEADERS
# include <stdlib.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

static int
compare (const char *fmt, const struct tm *tm, const char *expected)
{
  char buf[99];
  strftime (buf, 99, fmt, tm);
  if (strcmp (buf, expected))
    {
#ifdef SHOW_FAILURES
      printf ("fmt: \"%s\", expected \"%s\", got \"%s\"\n",
	      fmt, expected, buf);
#endif
      return 1;
    }
  return 0;
}

int
main ()
{
  int n_fail = 0;
  struct tm *tm;
  time_t t = 738367; /* Fri Jan  9 13:06:07 1970 */
  tm = gmtime (&t);

  /* This is necessary to make strftime give consistent zone strings and
     e.g., seconds since the epoch (%s).  */
  putenv ("TZ=GMT0");

#undef CMP
#define CMP(Fmt, Expected) n_fail += compare ((Fmt), tm, (Expected))

  CMP ("%-m", "1");		/* GNU */
  CMP ("%A", "Friday");
  CMP ("%^A", "FRIDAY");	/* The ^ is a GNU extension.  */
  CMP ("%B", "January");
  CMP ("%^B", "JANUARY");
  CMP ("%C", "19");		/* POSIX.2 */
  CMP ("%D", "01/09/70");	/* POSIX.2 */
  CMP ("%F", "1970-01-09");
  CMP ("%G", "1970");		/* GNU */
  CMP ("%H", "13");
  CMP ("%I", "01");
  CMP ("%M", "06");
  CMP ("%M", "06");
  CMP ("%R", "13:06");		/* POSIX.2 */
  CMP ("%S", "07");
  CMP ("%T", "13:06:07");	/* POSIX.2 */
  CMP ("%U", "01");
  CMP ("%V", "02");
  CMP ("%W", "01");
  CMP ("%X", "13:06:07");
  CMP ("%Y", "1970");
  CMP ("%Z", "GMT");
  CMP ("%_m", " 1");		/* GNU */
  CMP ("%a", "Fri");
  CMP ("%^a", "FRI");
  CMP ("%b", "Jan");
  CMP ("%^b", "JAN");
  CMP ("%c", "Fri Jan  9 13:06:07 1970");
  CMP ("%^c", "FRI JAN  9 13:06:07 1970");
  CMP ("%d", "09");
  CMP ("%e", " 9");		/* POSIX.2 */
  CMP ("%g", "70");		/* GNU */
  CMP ("%h", "Jan");		/* POSIX.2 */
  CMP ("%^h", "JAN");
  CMP ("%j", "009");
  CMP ("%k", "13");		/* GNU */
  CMP ("%l", " 1");		/* GNU */
  CMP ("%m", "01");
  CMP ("%n", "\n");		/* POSIX.2 */
  CMP ("%p", "PM");
  CMP ("%r", "01:06:07 PM");	/* POSIX.2 */
  CMP ("%s", "738367");		/* GNU */
  CMP ("%t", "\t");		/* POSIX.2 */
  CMP ("%u", "5");		/* POSIX.2 */
  CMP ("%w", "5");
  CMP ("%x", "01/09/70");
  CMP ("%y", "70");
  CMP ("%z", "+0000");		/* GNU */

  exit (n_fail ? 1 : 0);
}
	      >>,
changequote([, ])dnl
	     jm_cv_func_working_gnu_strftime=yes,
             jm_cv_func_working_gnu_strftime=no,
	     dnl When crosscompiling, assume strftime is missing or broken.
	     jm_cv_func_working_gnu_strftime=no)
  ])
  if test $jm_cv_func_working_gnu_strftime = no; then
    AC_SUBST(LIBOBJS)
    LIBOBJS="$LIBOBJS strftime.$ac_objext"
    AC_DEFINE_UNQUOTED(strftime, gnu_strftime,
      [Define to gnu_strftime if the replacement function should be used.])
  fi
])

AC_DEFUN(jm_FUNC_STRFTIME,
[
  _jm_STRFTIME_PREREQS
  AC_REPLACE_FUNCS(strftime)
])

# Copyright (C) 1998-2002 Joe Orton <joe@manyfish.co.uk>
#
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the neon library code
# itself may be copied and distributed under the terms of the GNU
# LGPL, see COPYING.LIB for more details

# This file is part of the neon HTTP/WebDAV client library.
# See http://www.webdav.org/neon/ for the latest version. 
# Please send any feedback to <neon@webdav.org>

# Adds an --enable-warnings argument to configure to
# allow enabling GCC warnings
#
# Usage:
#   NEON_WARNINGS

AC_DEFUN([NEON_WARNINGS],[

AC_REQUIRE([AC_PROG_CC])

AC_ARG_ENABLE(warnings,
	[  --enable-warnings       enable compiler warnings during build ],
	[with_warnings=$enableval],
	[with_warnings=no])  dnl Defaults to DISABLED

if test "$with_warnings" = "yes"; then
    if test "$GCC" = "yes"; then
	CFLAGS="$CFLAGS -Wall -ansi-pedantic -Wmissing-declarations -Winline -Wshadow -Wreturn-type -Wsign-compare -Wundef -Wpointer-arith -Wcast-align -Wbad-function-cast -Wimplicit-prototypes"
	if test -z "$with_ssl" -o "$with_ssl" = "no"; then
	    # OpenSSL headers fail strict prototypes checks
	    CFLAGS="$CFLAGS -Wstrict-prototypes"
	fi
    else
	# non-GCC compilers
	case `uname` in
	OSF1) CFLAGS="$CFLAGS -check -msg_disable returnchecks -msg_disable alignment -msg_disable overflow" ;;
	IRIX) CFLAGS="$CFLAGS -fullwarn" ;;
	UnixWare) CFLAGS="$CFLAGS -v" ;;
	*) AC_MSG_WARN([warning flags unknown for compiler on this platform]) ;;
	esac
    fi
fi

])


