/************************************************************************
*                                                                       *
* gb2pinyin - translates from GB to tone pinyin (chinese)               *
*                                                                       *
* Created in 1992 by Tommi Kaikkonen (tommi@phoenix.oulu.fi)            *
*									*
* modified (25 Nov 1992) by Katya Ta (ta_k@maths.su.oz.au)		*
* renamed c2t.c (chinese2text) as this can handle gb and big5		*
*                                                                       *
************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*
#include <malloc.h>
*/

#define MEMAREA 4096 /* max number of lines in DICT file, wc -l DICT */

main(argc, argv)
int argc;
char **argv;
{
  char *DICT="/home/ftp/software/unix/X-Window/cxterm-dictionary/TONEPY.tit";
  register int eka=0, toka=0, i=0;
  register char hz[4], **pipo=0;
  register char **taulu=0, rivi[82];
  register int rpit=0, tila=0, rraja=0, mulpin=0;
  int monitila=0;
  FILE *piffi=0;
  FILE *miss_chars=0; 
  int missing =0;
  int keep = 0;

	if (argc > 1){
	   for (i=1; i< argc; i++){
	       if (argv[i][0] == '-') {
		   if (argv[i][1] == 'm') /*multiple pinyin*/
		      monitila = 1;
		   else if (argv[i][1] == 'D') { /*dictionary*/
			   DICT = argv[i+1];
			   i++;
			} /*'D'*/
			else if (argv[i][1] == 'c') { /*file for chars not found*/
				miss_chars = fopen(argv[i+1], "w");
				if (miss_chars == 0)
	   			   puts("can't open missing characters file");
				i++;
			     } /* 'c'*/
			     else if (argv[i][1] == 'k') /*keep - print missing chars
							  * to stdio 
							  */
				     keep = 1;
	       }/*'-'*/
	   }/*for*/
	   i =0;
	} /*if argc > 1 */	
  if ((piffi = fopen (DICT, "r")) == 0) {
    printf (stderr, "Error: unable to open pinyin dictionnary %s\n",
	    DICT);
    exit (-1);
  }
  if ((taulu = (char **)malloc (MEMAREA*sizeof(char *))) == 0) {
    printf (stderr, "Error: out of memory when allocating taulu(MEMAREA too large)\n");
    exit (-2);
  }
  pipo = taulu;
  while (1) {
    if (feof(piffi) || !fgets (rivi, 80, piffi)) {
      *pipo = 0;
      pipo[1] = 0;
      pipo[2] = 0;
      fclose (piffi);
      break;
    }
    rpit = strlen (rivi);
    rivi[rpit-1] = '\0';
    if (tila == 0) {
      if (!strncmp ("BEGINDICTIONARY", rivi, 9)) tila=1;
    } else {
      if (rivi[0] == '#') continue;
      if ((*pipo = (char *)malloc (rpit+8)) == 0) {
	printf (stderr, "Error: out of memory when allocating *pipo\n");
	exit (-3);
      }
      strcpy (*pipo, rivi);
      pipo++;
      if (++rraja >= MEMAREA) {
	printf (stderr, "Error: out of memory when allocating *pipo(MEMAREA too small)...\n");
	exit (-4);
      }
    }
  }
  hz[2] = '\0';
  while (!feof (stdin)) {
    mulpin = 0;
    eka = getchar();
    if (eka < 0) break;
    if (eka & 128) {
      toka = getchar();
      if (toka < 0) break;
      hz[0] = (char)eka;
      hz[1] = (char)toka;
      for (pipo=taulu; pipo && *pipo; pipo++) {
	tila = 0;
	for (i=0; i<80 && (*pipo)[i] != '\t' && (*pipo)[i] != '\0'; i++);
	for (i++; i<80 && (*pipo)[i] && (*pipo)[i+1]; i+=2) {
	  if (hz[0] != (*pipo)[i] || hz[1] != (*pipo)[i+1]) continue;
	  else {tila=1; break;}
	}
	if (tila) {
	  if (mulpin++) printf ("/");
	  for (i=0; i<80 && (*pipo)[i] != '\t'; i++) printf("%c", (*pipo)[i]);
	  if (monitila) {
	    tila = 0;
	    continue;
	  } else {
	    printf (" ");
	    break;
	  }
	}
      }
      
      if ((!tila) && (!mulpin)) { /*no pronunciation could be found for the character */
	  if (!keep) { /* not keep */
	     printf("??? "); /*print ??? for missing char*/
	     if (miss_chars != 0){ /*there is a missing char file print the char to it*/
	        fprintf(miss_chars, "%c", hz[0]);
		fprintf(miss_chars, "%c ", hz[1]);
		missing++;
		if (missing > 20) { /* not to many chars on one line */
		   fprintf(miss_chars, "\n");
		   missing = 0;
		} /*if (missing > 20*/
	      } /*if (miss_chars != 0) */
	   } /*!keep*/
	   else { /*keep is on so print the char to stdio*/
			printf("%c", hz[0]);
			printf("%c ", hz[1]);
		}
	} /*if ((!tila) && (!mulpin)) */

      if (monitila) printf (" ");
    } else {
      printf ("%c", eka);
    }
  }
  if (miss_chars != 0)
  {
     fprintf(miss_chars, "\n");
     fclose(miss_chars);
  }
}
