/* msn_core.c - this contains all the functions used to do anything with MSN */

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>

#include <sys/types.h>
#include <sys/socket.h> // for the accept() in filetrans code
#include <sys/stat.h>

#include "md5.h"

#include "msn_core.h"
#include "msn_bittybits.h"
#include "msn_interface.h"

#define DEBUG 1

// Define all those extern'ed variables in msn_core.h:
llist * connections=NULL;

int next_trid=10;
char buf[BUF_SIZE]; // used for anything temporary

char * errors[1000];
char default_error_msg[]="Unknown error code";

void msn_init(msnconn * conn, const char * username, const char * password)
{
  srand(time(NULL));

  conn->auth=new authdata_NS;
  conn->type=CONN_NS;
  conn->ready=0;
  ((authdata_NS *)conn->auth)->username=msn_permstring(username);
  ((authdata_NS *)conn->auth)->password=msn_permstring(password);

  for(int a=0; a<1000; a++)
  {
    errors[a]=default_error_msg;
  }

  errors[200]=msn_permstring("Syntax error");
  errors[201]=msn_permstring("Invalid parameter");
  errors[205]=msn_permstring("Invalid user");
  errors[206]=msn_permstring("Domain name missing from username");
  errors[207]=msn_permstring("Already logged in");
  errors[208]=msn_permstring("Invalid username");
  errors[209]=msn_permstring("Invalid friendly name");
  errors[210]=msn_permstring("List full");
  errors[215]=msn_permstring("This user is already on this list or in this session");
  errors[216]=msn_permstring("Not on list");
  errors[218]=msn_permstring("Already in this mode");
  errors[219]=msn_permstring("This user is already in the opposite list");
  errors[280]=msn_permstring("Switchboard server failed");
  errors[281]=msn_permstring("Transfer notification failed");
  errors[300]=msn_permstring("Required fields missing");
  errors[302]=msn_permstring("Not logged in");
  errors[500]=msn_permstring("Internal server error");
  errors[501]=msn_permstring("Database server error");
  errors[510]=msn_permstring("File operation failed at server");
  errors[520]=msn_permstring("Memory allocation failed on server");
  errors[600]=msn_permstring("The server is too busy");
  errors[601]=msn_permstring("The server is unavailable");
  errors[602]=msn_permstring("A Peer Notification Server is down");
  errors[603]=msn_permstring("Database connection failed");
  errors[604]=msn_permstring("Server going down for maintenance");
  errors[707]=msn_permstring("Server failed to create connection");
  errors[711]=msn_permstring("Blocking write failed on server");
  errors[712]=msn_permstring("Session overload on server");
  errors[713]=msn_permstring("You have been too active recently. Slow down!");
  errors[714]=msn_permstring("Too many sessions open");
  errors[715]=msn_permstring("Not expected");
  errors[717]=msn_permstring("Bad friend file on server");
  errors[911]=msn_permstring("Authentication failed. Check that you typed your username and password correctly.");
  errors[913]=msn_permstring("This action is not allowed while you are offline");
  errors[920]=msn_permstring("This server is not accepting new users");

  msn_add_to_llist(connections, conn);
}

void msn_show_verbose_error(msnconn * conn, int errcode)
{
  snprintf(buf, 1024, "An error has occurred while communicating with the MSN Messenger server: %s (code %d)", errors[errcode], errcode);
  ext_show_error(conn, buf);
}

void msn_invite_user(msnconn * conn, char * rcpt)
{
  sprintf(buf, "CAL %d %s\r\n", next_trid++, rcpt);
  write(conn->sock, buf, strlen(buf));
}

void msn_send_IM(msnconn * conn, const char * rcpt, const char * s)
{
  static char header[]="MIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n";
  message * msg=new message;
  msg->body=s;
  msg->header=msn_permstring(header);
  msg->font=NULL;
  msg->colour=NULL;
  msn_send_IM(conn, rcpt, msg);

  msg->body=NULL; // don't delete s
  delete msg;
}

void msn_send_IM(msnconn * conn, const char * rcpt, message * msg)
{
  char header[1024];

  if(conn->type==CONN_NS)
  {
    llist * list;

    list=connections;
    while(1)
    {
      msnconn * c;
      llist * users;

      if(list==NULL) { break ; }
      c=(msnconn *)list->data;
      if(c->type==CONN_NS) { list=list->next; continue; }
      users=c->users;
      // the below sends a message into this session if the only other participant is
      // the user we want to talk to
      if(users!=NULL && users->next==NULL && !strcmp(((char_data *)users->data)->c, rcpt))
      {
	msn_send_IM(c, rcpt, msg);
	return;
      }

      list=list->next;
    }
    // otherwise, just connect
    msn_request_SB(conn, rcpt, msg, NULL);
    return;
  }

  if(msg->header==NULL)
  {
    if(msg->font==NULL)
    {
      sprintf(header, "MIME-Version: 1.0\r\nContent-Type: %s\r\n\r\n", (msg->content==NULL)?("text/plain; charset=UTF-8"):(msg->content));
    } else {
      char * fontname=msn_encode_URL(msg->font);
      char ef[2] = {'\0', '\0'};
      if(msg->bold) { ef[0]='B'; }
      if(msg->underline) { ef[0]='U'; }

      sprintf(header, "MIME-Version: 1.0\r\nContent-Type: %s\r\nX-MMS-IM-Format: FN=%s; EF=%s; CO=%s; CS=0; PF=%d\r\n\r\n",
	(msg->content==NULL)?("text/plain"):(msg->content), fontname, ef, msg->colour, msg->fontsize);

      delete fontname;
    }
  } else {
    strcpy(header, msg->header);
  }


  sprintf(buf, "MSG %d N %d\r\n%s", next_trid, strlen(header)+strlen(msg->body), header);
  write(conn->sock, buf, strlen(buf));
  write(conn->sock, msg->body, strlen(msg->body));
  next_trid++;
}

void msn_send_typing(msnconn * conn)
{
  char header[]="MIME-Version: 1.0\r\nContent-Type: text/x-msmsgscontrol\r\nTypingUser: ";
  char * username=((authdata_SB *)conn->auth)->username;

  sprintf(buf, "MSG %d U %d\r\n%s%s\r\n\r\n\r\n",
	next_trid++, strlen(header)+strlen(username)+6, header, username);

  write(conn->sock, buf, strlen(buf));
}

void msn_add_to_list(msnconn * conn, const char * lst, const char * username)
{
  sprintf(buf, "ADD %d %s %s %s\r\n", next_trid++, lst, username, username);
  write(conn->sock, buf, strlen(buf));
}

void msn_del_from_list(msnconn * conn, const char * lst, const char * username)
{
  sprintf(buf, "REM %d %s %s\r\n", next_trid++, lst, username);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_GTC(msnconn * conn, char c)
{
  sprintf(buf, "GTC %d %c\r\n", next_trid++, c);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_BLP(msnconn * conn, char c)
{
  sprintf(buf, "BLP %d %cL\r\n", next_trid++, c);
  write(conn->sock, buf, strlen(buf));
}

void msn_set_friendlyname(msnconn * conn, const char * friendlyname)
{
  char * username;

  username=((authdata_NS *)conn->auth)->username;
  sprintf(buf, "REA %d %s %s\r\n", next_trid++, username, msn_encode_URL(friendlyname));
  write(conn->sock, buf, strlen(buf));
}

void msn_sync_lists(msnconn * conn, int version)
{
  syncinfo * info=new syncinfo;

  info->serial=version;

  sprintf(buf, "SYN %d %d\r\n", next_trid, version);
  write(conn->sock, buf, strlen(buf));

  msn_add_callback(conn, msn_syncdata, next_trid, info);
  next_trid++;
}

void msn_syncdata(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  syncinfo * info=(syncinfo *)data;

  if(!strcmp(args[0], "SYN"))
  {
    if(info->serial==atoi(args[2]))
    {
      delete info;
      info=NULL;
      msn_del_callback(conn, trid);
      ext_got_info(conn, NULL);
      return;
    } else {
      info->serial=atoi(args[2]);
      ext_latest_serial(conn, info->serial);
      msn_add_callback(conn, msn_phonedata, info->serial, info);
    }
  }

  if(!strcmp(args[0], "LST"))
  {
    if(!strcmp(args[2], "FL"))
    {
      if(!strcmp(args[5], "0"))
      {
	info->fl=NULL; info->complete|=LST_FL;
      } else {
	userdata * newuser=new userdata();
	newuser->username=msn_permstring(args[6]);
	newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
	msn_add_to_llist(info->fl, newuser);
	if(atoi(args[4])==atoi(args[5]))
	{ info->complete|=LST_FL; }
      }
    }
    if(!strcmp(args[2], "RL"))
    {
      if(!strcmp(args[5], "0"))
      {
	info->rl=NULL; info->complete|=LST_RL; // no mates! :-)
      } else {
	userdata * newuser=new userdata();
	newuser->username=msn_permstring(args[6]);
	newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
	msn_add_to_llist(info->rl, newuser);
	if(atoi(args[4])==atoi(args[5]))
	{ info->complete|=LST_RL; }
      }
    }
    if(!strcmp(args[2], "AL"))
    {
      if(!strcmp(args[5], "0"))
      {
	info->al=NULL; info->complete|=LST_AL;
      } else {
	userdata * newuser=new userdata();
	newuser->username=msn_permstring(args[6]);
	newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
	msn_add_to_llist(info->al, newuser);
	if(atoi(args[4])==atoi(args[5]))
	{ info->complete|=LST_AL; }
      }
    }
    if(!strcmp(args[2], "BL"))
    {
      if(!strcmp(args[5], "0"))
      {
	info->bl=NULL; info->complete|=LST_BL;
      } else {
	userdata * newuser=new userdata();
	newuser->username=msn_permstring(args[6]);
	newuser->friendlyname=msn_decode_URL(msn_permstring(args[6]));
	msn_add_to_llist(info->bl, newuser);
	if(atoi(args[4])==atoi(args[5]))
	{ info->complete|=LST_BL; }
      }
    }
  }

  if(!strcmp(args[0], "GTC"))
  {
    info->gtc=args[3][0];
    info->complete|=COMPLETE_GTC;
    ext_got_GTC(conn, args[3][0]);
  }

  if(!strcmp(args[0], "BLP"))
  {
    info->blp=args[3][0];
    info->complete|=COMPLETE_BLP;
    ext_got_BLP(conn, args[3][0]);
  }

  if(info->complete == (LST_FL|LST_RL|LST_AL|LST_BL|COMPLETE_BLP|COMPLETE_GTC))
  {
    msn_del_callback(conn, trid);
    msn_del_callback(conn, info->serial);
    msn_check_rl(conn, info);
    ext_got_info(conn, info);
    delete info;
  }
}

void msn_phonedata(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  syncinfo * info=(syncinfo *)data;

  if(!strcmp(args[0], "BPR"))
  {
    llist * ll = info->fl;
    while(ll) {
      userdata * ud = (userdata *) ll->data;
      if(!strcmp(ud->username, args[2]))
      {
	phonedata * newphone=new phonedata();
	newphone->title=msn_permstring(args[3]);
	newphone->number=msn_decode_URL(msn_permstring(args[4]));
	msn_add_to_llist(ud->phone, newphone);
	break;
      }
      ll = ll->next;
    }
  }
}

void msn_check_rl(msnconn * conn, syncinfo * info)
{
  llist * flist; // FL
  llist * olist; // other list
  userdata * fcontact;
  userdata * ocontact;

  int is_on_list;
  int a=0;

  flist=info->rl;

  while(flist!=NULL)
  {
    is_on_list=0;

    fcontact=(userdata *)flist->data;

    a=0;
    for(olist=info->al; a<2; olist=info->bl, a++)
    {
      while(olist!=NULL)
      {
	ocontact=(userdata *)olist->data;
	if(!strcmp(ocontact->username, fcontact->username))
	{
	  is_on_list=1;
	  break;
	}
	olist=olist->next;
      }
      if(is_on_list) { break; } // avoid a second loop if unnecessary
    }

    if(!is_on_list)
    {
      ext_new_RL_entry(conn, fcontact->username, fcontact->friendlyname);
    }

    flist=flist->next;
  }
}

void msn_new_SB(msnconn * nsconn, void * tag)
{
  msn_request_SB(nsconn, NULL, NULL, tag);
}

void msn_request_SB(msnconn * nsconn, const char * rcpt, message * msg, void * tag)
{
  conninfo_SB * info=new conninfo_SB;

  info->auth=new authdata_SB;
  info->auth->username=msn_permstring(((authdata_NS *)nsconn->auth)->username);
  info->auth->rcpt=msn_permstring(rcpt);
  if(msg==NULL)
  {
    info->auth->msg=NULL;
  } else {
    info->auth->msg=new message;
    info->auth->msg->header=msn_permstring(msg->header);
    info->auth->msg->body=msn_permstring(msg->body);
    info->auth->msg->font=msn_permstring(msg->font);
    info->auth->msg->colour=msn_permstring(msg->colour);
    info->auth->msg->content=msn_permstring(msg->content);
    info->auth->msg->bold=msg->bold;
    info->auth->msg->italic=msg->italic;
    info->auth->msg->underline=msg->underline;
  }

  info->auth->tag=tag;

  sprintf(buf, "XFR %d SB\r\n", next_trid);
  write(nsconn->sock, buf, strlen(buf));

  msn_add_callback(nsconn, msn_SBconn_2, next_trid, info);
  next_trid++;
}

void msn_SBconn_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  conninfo_SB * info=(conninfo_SB *)data;

  msn_del_callback(conn, trid);

  if(strcmp(args[0], "XFR"))
  {
    msn_show_verbose_error(conn, atoi(args[0]));
    delete info;
    return;
  }

  info->auth->cookie=msn_permstring(args[5]);
  info->auth->sessionID=NULL;

  msnconn * newconn=new msnconn;

  newconn->auth=info->auth;
  newconn->type=CONN_SB;
  newconn->ready=0;

  msn_add_to_llist(connections, newconn);

  int port=1863;
  char * c;

  if((c=strstr(args[3], ":"))!=NULL)
  {
    *c='\0';
    c++;
    port=atoi(c);
  }

  delete info;

  msn_connect(newconn, args[3], port);
}

void msn_SBconn_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  authdata_SB * auth=(authdata_SB *)conn->auth;

  msn_del_callback(conn, trid);

  if(strcmp(args[2], "OK"))
  {
    msn_show_verbose_error(conn, atoi(args[0]));
    msn_clean_up(conn);
    return;
  }

  if(auth->rcpt==NULL) // they're requesting the SB session the proper way
  {
    ext_got_SB(conn, auth->tag);
  } else {
    sprintf(buf, "CAL %d %s\r\n", next_trid, auth->rcpt);
    write(conn->sock, buf, strlen(buf));

    delete auth->rcpt;
    auth->rcpt=NULL;

    next_trid++;
  }
  conn->ready=1;
  ext_new_connection(conn);
}

void msn_handle_incoming(int sock, int readable, int writable)
{
  // First, we find which msnconn this socket belongs to

  llist * list;
  msnconn * conn;
  callback * call;

  char ** args;
  int numargs;
  int trid;

  list=connections;

  if(list==NULL) { return; }

  while(1)
  {
    conn=(msnconn *)list->data;
    if(conn->sock==sock)
    { break; }
    list=list->next;
    if(list==NULL)
    {
    #ifdef MSNDEBUG
	printf("Network traffic not for us\n");
    #endif
	return;
    } // not for us
  }

  // first, siphon off any file transfer traffic to the special handler
  if(conn->type==CONN_FTP)
  { msn_handle_filetrans_incoming(conn, readable, writable); return; }

  // OK, it's for us. If it's readable, parse it, then deliver it to the appropriate handler

  if(!readable) { return; }

  args=msn_read_line(sock, &numargs);

  if(args==NULL)
  {
    if(errno!=0)
    { msn_clean_up(conn); }
    return;
  }

  if(!strcmp(args[0], "XFR") && !strcmp(args[2], "NS"))
  {
    delete conn->callbacks; // delete the callback data
    conn->callbacks=NULL;

    ext_unregister_sock(conn->sock);
    close(conn->sock);

    char * c;
    int port=1863;

    if((c=strstr(args[3], ":"))!=NULL)
    {
      *c='\0';
      c++;
      port=atoi(c);
    }

    msn_connect(conn, args[3], port);
    return;
  }

  if(!strcmp(args[0], "RNG"))
  {
    msn_handle_RNG(conn, args, numargs);
    return;
  }

  trid=atoi(args[1]);

  list=conn->callbacks;

  if(list!=NULL && trid>0)
  {
    while(1)
    {
      call=(callback *)list->data;
      if(call->trid==trid)
      {
	(call->func)(conn, trid, args, numargs, call->data);
	delete args[0];
	delete args;
	return;
      }
      list=list->next;
      if(list==NULL) { break; } // defaults
    }
  }

  msn_handle_default(conn, args, numargs);

  delete args[0];
  delete args;
}

void msn_handle_close(int sock)
{
  // First, we find which msnconn this socket belongs to

  llist * list;
  msnconn * conn;

  list=connections;

  if(list==NULL) { return; }

  while(1)
  {
    conn=(msnconn *)list->data;
    if(conn->sock==sock)
    { break; }
    list=list->next;
    if(list==NULL)
    {
	#ifdef MSNDEBUG
	printf("Socket close not for us\n");
	#endif
       return; } // not for us
  }

  msn_clean_up(conn);
}

void msn_handle_default(msnconn * conn, char ** args, int numargs)
{

  //     Switchboard messages

  if(!strcmp(args[0], "MSG"))
  {
    msn_handle_MSG(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "NAK"))
  {
    msn_handle_NAK(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "JOI"))
  {
    msn_handle_JOI(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "BYE"))
  {
    msn_handle_BYE(conn, args, numargs);
    return;
  }

  //    Notification server messages

  if(!strcmp(args[0], "NLN") || !strcmp(args[0], "ILN") || !strcmp(args[0], "FLN"))
  {
    msn_handle_statechange(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "CHG"))
  {
    ext_changed_state(conn, args[2]);
    return;
  }

  if(!strcmp(args[0], "ADD"))
  {
    msn_handle_ADD(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "REM"))
  {
    msn_handle_REM(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "BLP"))
  {
    msn_handle_BLP(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "GTC"))
  {
    msn_handle_GTC(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "REA"))
  {
    msn_handle_REA(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "CHL"))
  {
    msn_handle_CHL(conn, args, numargs);
    return;
  }

  if(!strcmp(args[0], "OUT"))
  {
    msn_handle_OUT(conn, args, numargs);
    return;
  }

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(conn, atoi(args[0]));
    return;
  }

  #ifdef MSNDEBUG
  printf("Don't know what to do with this one, ignoring it:\n"); // DEBUG
  for(int a=0; a<numargs; a++)
  {
    printf("%s ", args[a]);
  }
  printf("\n");
  #endif
}

void msn_handle_MSG(msnconn * conn, char ** args, int numargs)
{
  int msglen;
  char * msg;
  char * mime;
  char * body;
  char * tmp;

  msglen=atoi(args[3]);

  msg=new char[msglen+1];
  read(conn->sock, msg, msglen);
  msg[msglen]='\0';

  mime=msg;
  body=strstr(msg, "\r\n\r\n");
  if(body!=NULL) { body[2]='\0'; /* finish the MIME string */ body+=4; }

    // the below is a kludge until I remember the header name for TypingUser
  if((strstr(mime, "TypingUser")!=NULL) || (strstr(mime, "TypeingUser")!=NULL))
  { // the second of the above two is a workaround for a spelling bug in the Jabber MSN transport
    ext_typing_user(conn, args[1], msn_decode_URL(args[2]));
    delete msg;
    return;
  }

  /* Warning - the code below was written at what my body clock insisted was past midnight,
  jetlagged, on a foreign road, because I had nothing better to do. I would like to please
  call to your attention the no-warranty clause in the GPL.... :^) */

  char * content; // content-type

  content=msn_find_in_mime(mime, "Content-Type");
  if(content==NULL) { ext_show_error(conn, "MSG with no Content-type set"); delete msg; return; }
  #ifdef MSNDEBUG
  printf("Content type: \"%s\"\n", content);
  #endif
  if((tmp=strstr(content, "; charset"))!=NULL) { *tmp='\0'; }

  if(!strcmp(content, "text/plain"))
  {
    message * msg=new message;
    msg->header=mime;
    msg->body=body;
    msg->font=NULL;
    msg->content=msn_find_in_mime(mime, "Content-Type"); // include any "charset=" I've chopped off

    ext_got_IM(conn, args[1], msn_decode_URL(args[2]), msg);
  } else if(!strcmp(content, "text/x-msmsgsinitialemailnotification")) {
    char * unread_ibc;
    char * unread_folc;
    int unread_ib=0, unread_fol=0;

    unread_ibc=msn_find_in_mime(body, "Inbox-Unread");
    unread_folc=msn_find_in_mime(body, "Folders-Unread");
    if(unread_ibc!=NULL) { unread_ib=atoi(unread_ibc); delete unread_ibc; }
    if(unread_folc!=NULL) { unread_fol=atoi(unread_folc); delete unread_folc; }

    ext_initial_email(conn, unread_ib, unread_fol);
  } else if(!strcmp(content, "text/x-msmsgsemailnotification")) {
    char * from=msn_find_in_mime(body, "From-Addr");
    char * subject=msn_find_in_mime(body, "Subject");

    ext_new_mail_arrived(conn, from, subject);

    delete from;
    delete subject;
  } else if(!strcmp(content, "text/x-msmsgsinvite")) {
    msn_handle_invite(conn, args[1], msn_decode_URL(args[2]), mime, body);
  } else {
    #ifdef MSNDEBUG
    printf("Unknown content-type: \"%s\"\n", content);
    #endif
  }
  delete content;
  delete msg;
}

char * msn_find_in_mime(char * mime, char * header)
{
  char * retval;
  int pos;

  if(!strncmp(mime, header, strlen(header)))
  {
    retval=mime;
  } else {
    char * tmp=new char[strlen(header)+3];
    strcpy(tmp, "\r\n");
    strcat(tmp, header);
    retval=strstr(mime, header);
    if(retval==NULL) { return NULL; }
    retval+=2;
    delete tmp;
  }

  while(*retval!=':') { retval++; }
  retval++; // pass the colon
  while(isspace(*retval)) { retval++; } // position at start of value

  pos=0;
  while(retval[pos]!='\0')
  {
    if(retval[pos]=='\r')
    {
      char * tmp;
      retval[pos]='\0';
      tmp=msn_permstring(retval);
      retval[pos]='\r';
      return tmp;
    }
    pos++;
  }
  #ifdef MSNDEBUG
  printf("Invalid MIME header - WTF?!\n");
  #endif
  return NULL;
}

void msn_handle_invite(msnconn * conn, char * from, char * friendly, char * mime, char * body)
{
  char * command=msn_find_in_mime(body, "Invitation-Command");
  char * cookie=msn_find_in_mime(body, "Invitation-Cookie");
  int inv_is_out=0;
  invitation * inv=NULL;
  llist * l;

  l=conn->invitations_in;
  while(1)
  {
    if(l==NULL)
    { if(!inv_is_out) { l=conn->invitations_out; inv_is_out=1; continue; } else { break; } }
    inv=(invitation *)l->data;
    #ifdef MSNDEBUG
    printf("invitation: checking %s against %s\n", inv->cookie, cookie);
    #endif
    if(!strcmp(inv->cookie, cookie))
    { break ; }
    inv=NULL;
    l=l->next;
  }


  if(!strcmp(command, "INVITE"))
  {
    msn_handle_new_invite(conn, from, friendly, mime, body);
  } else if(!strcmp(command, "ACCEPT")) {
    if(inv==NULL)
    {
     #ifdef MSNDEBUG
     printf("Very odd - just got an ACCEPT out of mid-air...\n");
     #endif
     delete command; return; }

    if(!inv_is_out && inv->app==APP_FTP)
    {
      #ifdef MSNDEBUG
      printf("Downloading file from remote host..\n");
      #endif
      msn_recv_file((invitation_ftp *)inv, body);
    } else if(inv_is_out && inv->app==APP_FTP) {
      msn_send_file((invitation_ftp *)inv, body);
    }
  } else if(!strcmp(command, "CANCEL") || !strcmp(command, "REJECT")) {
    if(inv==NULL)
    {
      #ifdef MSNDEBUG
      printf("Very odd - just got a CANCEL/REJECT out of mid-air...\n");
      #endif
      delete command;
      return;
    }
    if(inv->app==APP_FTP)
    {
      ext_filetrans_failed((invitation_ftp *)inv, 0, "Cancelled by remote user");
      if(inv_is_out)
      {
	msn_del_from_llist(conn->invitations_out, inv);
      } else {
	msn_del_from_llist(conn->invitations_in, inv);
      }
      delete inv;
    }
  } else {
    #ifdef MSNDEBUG
    printf("Argh, don't support %s yet!\n", command);
    #endif
  }

  delete command;
}

void msn_handle_new_invite(msnconn * conn, char * from, char * friendlyname, char * mime, char * body)
{

  char * appname;

  char * tmp1=NULL;
  char * tmp2=NULL;

  appname=msn_find_in_mime(body, "Application-Name");
  invitation * invg=NULL;

  if((tmp1=msn_find_in_mime (body, "Application-File")) != NULL
  && (tmp2=msn_find_in_mime (body, "Application-FileSize")) != NULL)
  {
    invitation_ftp * inv=new invitation_ftp;
    invg=inv;
    invg->app=APP_FTP;
    invg->other_user=msn_permstring(from);
    invg->cookie=msn_find_in_mime(body, "Invitation-Cookie");
    invg->conn=conn;
    inv->filename=tmp1;
    tmp1=NULL;
    inv->filesize=atol(tmp2);

    ext_filetrans_invite(conn, from, friendlyname, inv);
  }
  if(tmp1!=NULL) { delete tmp1; }
  if(tmp2!=NULL) { delete tmp2; }

  delete appname;

  if(invg==NULL)
  {
    ext_show_error(conn, "Unknown invitation type!");
    return;
  }

  msn_add_to_llist(conn->invitations_in, invg);
}

void msn_recv_file(invitation_ftp * inv, char * msg_body)
{
  char * cookie=msn_find_in_mime(msg_body, "AuthCookie");
  char * remote=msn_find_in_mime(msg_body, "IP-Address");
  char * port_c=msn_find_in_mime(msg_body, "Port");
  int port;

  if(cookie==NULL || remote==NULL || port_c==NULL)
  {
    ext_filetrans_failed(inv, 0, "Missing parameters");
    msn_del_from_llist(inv->conn->invitations_in, inv);
    if(cookie!=NULL) { delete cookie; }
    if(remote!=NULL) { delete remote; }
    if(port_c!=NULL) { delete port_c; }
    delete inv;
  }

  port=atoi(port_c);
  delete port_c;

  msnconn * conn=new msnconn;
  conn->type=CONN_FTP;

  sprintf(buf, "Connecting to %s:%d\n", remote, port);
  ext_filetrans_progress(inv, buf, 0, 0);

  conn->sock=ext_connect_socket(remote, port);
  delete remote;

  if(conn->sock<0)
  {
    ext_filetrans_failed(inv, errno, strerror(errno));
    msn_del_from_llist(inv->conn->invitations_in, inv);
    delete cookie;
    delete inv;
    return;
  }

  ext_register_sock(conn->sock, 1, 0);

  ext_filetrans_progress(inv, "Connected", 0, 0);

  authdata_FTP * auth=new authdata_FTP;
  auth->cookie=msn_permstring(cookie);
  delete cookie;
  auth->inv=inv;
  auth->username=msn_permstring(((authdata_SB *)inv->conn->auth)->username);
  auth->direction=MSNFTP_RECV;

  conn->auth=auth;

  msn_add_to_llist(connections, conn);

  write(conn->sock, "VER MSNFTP\r\n", strlen("VER MSNFTP\r\n"));
}


void msn_handle_filetrans_incoming(msnconn * conn, int readable, int writable)
{
  authdata_FTP * auth=(authdata_FTP *)conn->auth;

  #ifdef MSNDEBUG
  printf("Incoming from file sender\n");
  #endif

  if(auth->direction==MSNFTP_RECV)
  {
    if(!readable) { return; } // not interested...

    if(auth->fd==-1)
    {
      char ** args;
      int numargs;

      args=msn_read_line(conn->sock, &numargs);

      if(args==NULL) { msn_clean_up(conn); return; }

      if(!strcmp(args[0], "VER"))
      {
	sprintf(buf, "USR %s %s\r\n", auth->username, auth->cookie);
	write(conn->sock, buf, strlen(buf));
	ext_filetrans_progress(auth->inv, "Negotiating", 0, 0);
      } else if (!strcmp(args[0], "FIL")) {
	auth->fd=open(auth->inv->filename, O_WRONLY|O_CREAT|O_TRUNC, S_IRWXU);
	if(auth->fd<0)
	{
	  ext_filetrans_failed(auth->inv, errno, strerror(errno));
	  msn_del_from_llist(conn->invitations_in, auth->inv);
	  msn_clean_up(conn);
	  delete args[0];
	  delete args;
	  return;
	}

	write(conn->sock, "TFR\r\n", strlen("TFR\r\n"));
      }
      delete args[0];
      delete args;
      auth->num_ignore=3;
    }

    fd_set readfd;
    struct timeval timeout={0, 0};
    FD_ZERO(&readfd);
    FD_SET(conn->sock, &readfd);
    char c;

    while(select(conn->sock+1, &readfd, NULL, NULL, &timeout)==1)
    {
      if(read(conn->sock, &c, 1)<1)
      {
	msn_clean_up(conn);
	return;
      }
      if(auth->num_ignore>0)
      {
	auth->num_ignore--;
	continue;
      }
      auth->bytes_done++;
      write(auth->fd, &c, 1);
      if(auth->bytes_done==auth->inv->filesize)
      {
	write(conn->sock, "BYE 16777989\r\n", strlen("BYE 16777989"));
	ext_filetrans_success(auth->inv);

	msn_del_from_llist(auth->inv->conn->invitations_in, auth->inv);
	msn_clean_up(conn);
	return;
      }
      if(auth->bytes_done%2045==0) { auth->num_ignore=3; }
    }

    ext_filetrans_progress(auth->inv, "Receiving file", auth->bytes_done, auth->inv->filesize);
  } else {
    // We are sending

    if(!auth->connected) // we have not accept()ed yet, but the read/writability means there's one waiting
    {
      int s;

      if((s=accept(conn->sock, NULL, NULL))<0)
      {
	#ifdef MSNDEBUG
	perror("Could not accept()\n");
	#endif
	ext_filetrans_failed(auth->inv, errno, strerror(errno));
	msn_del_from_llist(auth->inv->conn->invitations_out, auth->inv);
	msn_clean_up(conn); // that will nuke both auth and inv
	return;
      }

      ext_unregister_sock(conn->sock);
      close(conn->sock);

      conn->sock=s;
      ext_register_sock(conn->sock, 1, 1);

      ext_filetrans_progress(auth->inv, "Connected", 0, 0);

      auth->connected=1;
    } else {
      // we know it's connected already

      if(auth->fd==-1)
      {
	char ** args;
	int numargs;

	if(!readable) { return; } // not interested...

	if((args=msn_read_line(conn->sock, &numargs))==NULL)
	{
	  #ifdef MSNDEBUG
	  perror("read() failed");
	  #endif
	  ext_filetrans_failed(auth->inv, errno, strerror(errno));
	  msn_del_from_llist(auth->inv->conn->invitations_out, auth->inv);
	  msn_clean_up(conn);
	  return;
	}

	if(!strcmp(args[0], "VER"))
	{
	  sprintf(buf, "VER MSNFTP\r\n");
	  write(conn->sock, buf, strlen(buf));
	  ext_filetrans_progress(auth->inv, "Negotiating", 0, 0);
	}

	if(!strcmp(args[0], "USR"))
	{
	  if(strcmp(args[2], auth->cookie))  // if they DIFFER
	  {
	    ext_filetrans_failed(auth->inv, errno, strerror(errno));
	    msn_del_from_llist(auth->inv->conn->invitations_out, auth->inv);
	    msn_clean_up(conn);
	    return;
	  }

	  sprintf(buf, "FIL %lu\r\n", auth->inv->filesize);
	  write(conn->sock, buf, strlen(buf));
	}

	if(!strcmp(args[0], "TFR"))
	{
	  // you asked for it, go to data-dump mode
	  auth->fd=open(auth->inv->filename, O_RDONLY);
	  if(auth->fd<0)
	  {
	    ext_filetrans_failed(auth->inv, errno, "Could not open file for reading");
	    msn_del_from_llist(auth->inv->conn->invitations_out, auth->inv);
	    msn_clean_up(conn);
	    return;
	  }

	  // OK, now we lose control, but the next round of the polling loop will
	  // say that the socket is writable, and then the fun starts...
	  ext_filetrans_progress(auth->inv, "Sending data", 0, 0);
	}
      } else {
	// just pumping data now

	fd_set writefd;
	FD_ZERO(&writefd);
	FD_SET(conn->sock, &writefd);
	struct timeval tout={0, 0};
	char c;

	while(select(conn->sock+1, NULL, &writefd, NULL, &tout)==1)
	{
	  if(auth->bytes_done%2045==0)
	  {
	    unsigned char check[3];
	    int to_go=(auth->inv->filesize-auth->bytes_done>2045)?(2045):(auth->inv->filesize-auth->bytes_done);


	    check[0]='\0';
	    check[1]=to_go%256;
	    check[2]=to_go/256;
	    write(conn->sock, check, 3);
	  }

	  if(read(auth->fd, &c, 1)<1)
	  {
	    ext_filetrans_failed(auth->inv, errno, strerror(errno));
	    msn_del_from_llist(auth->inv->conn->invitations_out, auth->inv);
	    msn_clean_up(conn);
	    return;
	  }

	  auth->bytes_done++;
	  write(conn->sock, &c, 1);

	  if(auth->bytes_done==auth->inv->filesize)
	  {
	    ext_filetrans_success(auth->inv);

	    msn_del_from_llist(auth->inv->conn->invitations_in, auth->inv);
	    msn_clean_up(conn);
	    return;
	  }
	}

	ext_filetrans_progress(auth->inv, "Sending file", auth->bytes_done, auth->inv->filesize);
      }
    }
  }
}

void msn_send_file(invitation_ftp * inv, char * msg_body)
{
  int port=6891;
  msnconn * conn=new msnconn;

  ext_filetrans_progress(inv, "Sending IP address", 0, 0);

  conn->type=CONN_FTP;

  while((conn->sock=ext_server_socket(port))<0)
  {
    port++;
    if(port>6911)
    {
      ext_filetrans_failed(inv, errno, strerror(errno));
      msn_del_from_llist(inv->conn->invitations_out, inv);
      delete inv;
      delete conn;
      return;
    }
  }

  ext_register_sock(conn->sock, 1, 0);

  msn_add_to_llist(connections, conn);

  authdata_FTP * auth=new authdata_FTP;

  conn->auth=auth;

  auth->cookie=new char[64];
  sprintf(auth->cookie, "%d", rand());

  auth->inv=inv;
  auth->direction=MSNFTP_SEND;

  auth->connected=0;

  message * msg=new message;
  msg->content=msn_permstring("text/x-msmsgsinvite; charset=UTF-8");


  sprintf(buf, "Invitation-Command: ACCEPT\r\nInvitation-Cookie: %s\r\nIP-Address: %s\r\nPort: %d\r\nAuthCookie: %s\r\nLaunch-Application: FALSE\r\nRequest-Data: IP-Address:\r\n\r\n",
    inv->cookie, ext_get_IP(), port, auth->cookie);

  msg->body=msn_permstring(buf);

  msn_send_IM(inv->conn, NULL, msg);

  delete msg;
}

void msn_handle_NAK(msnconn * conn, char ** args, int numargs)
{
  ext_IM_failed(conn);
}

void msn_handle_JOI(msnconn * conn, char ** args, int numargs)
{
  authdata_SB * auth;

  auth=(authdata_SB *)conn->auth;

  if(!strcmp(args[1], auth->username)) { return; }

  msn_add_to_llist(conn->users, new char_data(msn_permstring(args[1])));
  ext_user_joined(conn, args[1], msn_decode_URL(args[2]), 0);

  if(auth->msg!=NULL)
  {
    msn_send_IM(conn, NULL, auth->msg);
    delete auth->msg;
    auth->msg=NULL;
  }
}

void msn_handle_RNG(msnconn * conn, char ** args, int numargs)
{
  msnconn * newSBconn=new msnconn;
  authdata_SB * auth=new authdata_SB;

  newSBconn->type=CONN_SB;
  newSBconn->auth=auth;

  auth->username=msn_permstring(((authdata_NS *)(conn->auth))->username);
  auth->sessionID=msn_permstring(args[1]);
  auth->cookie=msn_permstring(args[4]);
  auth->msg=NULL;

  msn_add_to_llist(connections, newSBconn);

  char * c;
  int port=1863;
  if((c=strstr(args[2], ":"))!=NULL)
  {
    *c='\0';
    c++;
    port=atoi(c);
  }

  msn_connect(newSBconn, args[2], port);
}

void msn_handle_BYE(msnconn * conn, char ** args, int numargs)
{
  llist * list;
  char_data * c;

  list=conn->users;

  ext_user_left(conn, args[1]);

  while(list!=NULL)
  {
    c=(char_data *)list->data;
    if(!strcmp(c->c, args[1])) // if the departing user matches this item on the list
    {
      if(list->next!=NULL)
      { list->next->prev=list->prev; }
      if(list->prev!=NULL)
      { list->prev->next=list->next; }
      if(list->prev==NULL) { conn->users=list->next; }
      list->next=NULL;  // otherwise the delete will go through the entire llist!
      list->prev=NULL;
      delete list; // will delete the char_data for us too
      break;
    }
    list=list->next;
  }

  if(conn->users==NULL)
  {
    msn_clean_up(conn);
  }
}

void msn_handle_statechange(msnconn * conn, char ** args, int numargs)
{
  char * buddy;
  char * state;
  char * friendlyname;

  if(!strcmp(args[0], "ILN"))
  {
    friendlyname=args[4];
    buddy=args[3];
    state=args[2];
  } else if(!strcmp(args[0], "FLN")) {
    buddy=args[1];
    ext_buddy_offline(conn, buddy);
    return;
  } else {
    friendlyname=args[3];
    buddy=args[2];
    state=args[1];
  }

  ext_buddy_set(conn, buddy, msn_decode_URL(friendlyname), state);
}

void msn_handle_ADD(msnconn * conn, char ** args, int numargs)
{
  if(!strcmp(args[2], "RL"))
  {
    #ifdef MSNDEBUG
    printf("Via ADD:\n");
    #endif
    ext_new_RL_entry(conn, args[4], msn_decode_URL(args[5]));
  }

  ext_new_list_entry(conn, args[2], args[4]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_REM(msnconn * conn, char ** args, int numargs)
{
  ext_del_list_entry(conn, args[2], args[4]);
  ext_latest_serial(conn, atoi(args[3]));
}


void msn_handle_BLP(msnconn * conn, char ** args, int numargs)
{
  ext_got_BLP(conn, args[3][0]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_GTC(msnconn * conn, char ** args, int numargs)
{
  ext_got_GTC(conn, args[3][0]);
  ext_latest_serial(conn, atoi(args[3]));
}

void msn_handle_REA(msnconn * conn, char ** args, int numargs)
{
  ext_latest_serial(conn, atoi(args[2]));
  ext_got_friendlyname(conn, msn_decode_URL(args[4]));
}

void msn_handle_CHL(msnconn * conn, char ** args, int numargs)
{
  md5_state_t state;
  md5_byte_t digest[16];
  int a;

  md5_init(&state);
  md5_append(&state, (md5_byte_t *)(args[2]), strlen(args[2]));
  md5_append(&state, (md5_byte_t *)"Q1P7W2E4J9R8U3S5", 16);
  md5_finish(&state, digest);

  sprintf(buf, "QRY %d msmsgs@msnmsgr.com 32\r\n", next_trid++);
  write(conn->sock, buf, strlen(buf));

  for(a=0; a<16; a++)
  {
    sprintf(buf, "%02x", digest[a]);
    write(conn->sock, buf, strlen(buf));
  }
}

void msn_handle_OUT(msnconn * conn, char ** args, int numargs)
{
  if(numargs>1)
  {
    if(!strcmp(args[1], "OTH"))
    {
      ext_show_error(conn, "You have logged onto MSN twice at once. Your MSN session will now terminate.");
    } else if(!strcmp(args[1], "SSD")) {
      ext_show_error(conn, "This MSN server is going down for maintenance. Your MSN session will now terminate.");
    } else {
      sprintf(buf, "The MSN server has terminated the connection with an unknown reason code. Please report this code: %s", args[1]);
      ext_show_error(conn, buf);
    }
  }
  msn_clean_up(conn);
}

void msn_filetrans_reject(invitation_ftp * inv)
{
   message * msg=new message;

   sprintf(buf, "Invitation-Command: CANCEL\r\nInvitation-Cookie: %s\r\nCancel-Code: REJECT\r\n",
     inv->cookie);
   msg->body=msn_permstring(buf);
   msg->content=msn_permstring("text/x-msmsgsinvite; charset=UTF-8");
   msn_send_IM(inv->conn, NULL, msg);
   delete msg;

   #ifdef MSNDEBUG
   printf("Rejecting file transfer\n");
   #endif

   msn_del_from_llist(inv->conn->invitations_in, inv);
}

void msn_filetrans_accept(invitation_ftp * inv, const char * dest)
{
   message * msg=new message;

   delete inv->filename;
   inv->filename=msn_permstring(dest);
   sprintf(buf, "Invitation-Command: ACCEPT\r\nInvitation-Cookie: %s\r\nLaunch-Application: FALSE\r\nRequest-Data: IP-Address\r\n\r\n",
     inv->cookie);
   msg->body=msn_permstring(buf);
   msg->content=msn_permstring("text/x-msmsgsinvite; charset=UTF-8");
   msn_send_IM(inv->conn, NULL, msg);
   delete msg;

   #ifdef MSNDEBUG
   printf("Accepting file transfer\n");
   #endif
}

void msn_filetrans_cancel(invitation_ftp * inv)
{
  llist * l;
  msnconn * conn;

  // one of the two below will fail, but it will do so safely and quietly
  msn_del_from_llist(inv->conn->invitations_in, inv);
  msn_del_from_llist(inv->conn->invitations_out, inv);

  l=connections;

  while(1)
  {
    if(l==NULL) { delete inv; return; } // Hmm, couldn't find it...

    conn=(msnconn *)l->data;

    if(conn->type==CONN_FTP && ((authdata_FTP *)(conn->auth))->inv==inv)
    { break; }

    l=l->next;
  }

  authdata_FTP * auth=(authdata_FTP *)conn->auth;
  delete auth->inv;
  auth->inv=NULL;
  delete auth;
  conn->auth=NULL;

  msn_clean_up(conn);
}

invitation_ftp * msn_filetrans_send(msnconn * conn, const char * path)
{
  struct stat st_info;

  if(stat(path, &st_info)<0)
  { ext_show_error(conn, "Could not open file"); return NULL; }

  invitation_ftp * inv=new invitation_ftp;

  inv->app=APP_FTP;
  inv->cookie=new char[64];
  sprintf(inv->cookie, "%d", rand());
  inv->other_user=NULL;
  inv->conn=conn;

  inv->filename=msn_permstring(path);
  inv->filesize=st_info.st_size;

  message * msg=new message;
  char * basename;

  basename=inv->filename+strlen(inv->filename);

  while(basename>=inv->filename && *basename!='/' && *basename!='\\')
  {
    basename--;
  }

  basename++; // it will always be 1 char before the start of the string

  msg->content=msn_permstring("text/x-msmsgsinvite; charset=UTF-8");

  sprintf(buf, "Application-Name: File transfer\r\nApplication-GUID: {5D3E02AB-6190-11d3-BBBB-00C04F795683}\r\nInvitation-Command: INVITE\r\nInvitation-Cookie: %s\r\nApplication-File: %s\r\nApplication-FileSize: %lu\r\n\r\n",
    inv->cookie, basename, inv->filesize);

  msg->body=msn_permstring(buf);

  msn_send_IM(conn, NULL, msg);

  msn_add_to_llist(conn->invitations_out, inv);

  delete msg;

  ext_filetrans_progress(inv, "Negotiating connection", 0, 0);

  return inv;
}

void msn_connect(msnconn * conn, const char * server, int port)
{
  conn->ready=0;

  if(conn->type==CONN_SB)
  {
    authdata_SB * auth=(authdata_SB *)conn->auth;

    if((conn->sock=ext_connect_socket(server, port))==-1)
    {
      ext_show_error(conn, "Could not connect to switchboard server");
      return;
    }

    ext_register_sock(conn->sock, 1, 0);

    if(auth->sessionID==NULL)
    {
      sprintf(buf, "USR %d %s %s\r\n", next_trid, auth->username, auth->cookie);
      write(conn->sock, buf, strlen(buf));

      msn_add_callback(conn, msn_SBconn_3, next_trid, NULL);
    } else {
      sprintf(buf, "ANS %d %s %s %s\r\n", next_trid, auth->username, auth->cookie, auth->sessionID);
      write(conn->sock, buf, strlen(buf));

      ext_new_connection(conn);
      conn->ready=1;
      msn_add_callback(conn, msn_SB_ans, next_trid, NULL);
    }

    next_trid++;

    return;
  } // Otherwise, it's a Notification Server (NS)

  connectinfo * info;

  info=new connectinfo;

  // The following is necessary as username and password may be temp variables
  // that will no longer exist when the next function is called
  info->username=msn_permstring( ((authdata_NS *)conn->auth)->username);
  info->password=msn_permstring( ((authdata_NS *)conn->auth)->password);

  conn->ready=0;
  if((conn->sock=ext_connect_socket(server, port))==-1)
  {
    ext_show_error(conn, "Could not connect to MSN server");
    return;
  }

  ext_register_sock(conn->sock, 1, 0);

  #ifdef MSNDEBUG
  printf("Connected\n"); // DEBUG
  #endif

  sprintf(buf, "VER %d MSNP7\r\n", next_trid);
  write(conn->sock, buf, strlen(buf));
  msn_add_callback(conn, msn_connect_2, next_trid, (callback_data *)info);
  next_trid++;
}

// Further connection functions:

void msn_connect_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(strcmp(args[0], "VER") || strcmp(args[2], "MSNP7")) // if either *differs*...
  {
    ext_show_error(NULL, "Protocol negotiation failed");
    delete info;
    ext_unregister_sock(conn->sock);
    close(conn->sock);
    conn->sock=-1;
    return;
  }

  sprintf(buf, "USR %d MD5 I %s\r\n", next_trid, info->username);
  write(conn->sock, buf, strlen(buf));

  msn_add_callback(conn, msn_connect_3, next_trid, data);
  next_trid++;
}

void msn_connect_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  md5_state_t state;
  md5_byte_t digest[16];
  int a;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(conn, atoi(args[0]));
    msn_clean_up(conn);
    delete info;
    return;
  }

  // OK, the challenge just arrived as args[4]

  md5_init(&state);
  md5_append(&state, (md5_byte_t *)(args[4]), strlen(args[4]));
  md5_append(&state, (md5_byte_t *)(info->password), strlen(info->password));
  md5_finish(&state, digest);

  sprintf(buf, "USR %d MD5 S ", next_trid);
  write(conn->sock, buf, strlen(buf));

  for(a=0; a<16; a++)
  {
    sprintf(buf, "%02x", digest[a]);
    write(conn->sock, buf, 2);
  }

  write(conn->sock, "\r\n", 2);

  msn_add_callback(conn, msn_connect_4, next_trid, data);
  next_trid++;
}

void msn_connect_4(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);

  if(isdigit(args[0][0]))
  {
    msn_show_verbose_error(conn, atoi(args[0]));
    delete info;
    msn_clean_up(conn);
    return;
  }

  ext_got_friendlyname(conn, msn_decode_URL(args[4]));

  delete info;

  next_trid++;

  conn->ready=1;
  ext_new_connection(conn);
}

void msn_SB_ans(msnconn * conn, int trid, char ** args, int numargs, callback_data * data)
{
  if(!strcmp(args[0], "ANS") && !strcmp(args[2], "OK"))
  { return; }

  if(isdigit(args[0][0]))
  {
    msn_del_callback(conn, trid);
    msn_show_verbose_error(conn, atoi(args[0]));
    msn_clean_up(conn);
    return;
  }

  if(!strcmp(args[0], "IRO"))
  {
    if(!strcmp(args[4], ((authdata_SB *)conn->auth)->username)) { return; }
    msn_add_to_llist(conn->users, new char_data(msn_permstring(args[4])));
    ext_user_joined(conn, args[4], msn_decode_URL(args[5]), 1);
    if(!strcmp(args[2], args[3]))
    {
      msn_del_callback(conn, trid);
    }
  }
}

void msn_set_state(msnconn * conn, const char * state)
{
  sprintf(buf, "CHG %d %s\r\n", next_trid, state);
  write(conn->sock, buf, strlen(buf));
  next_trid++;
}

/*
void msn_connect_3(msnconn * conn, char ** args, int numargs, callback_data * data)
{
  connectinfo * info;

  info=(connectinfo *)data;
  msn_del_callback(conn, trid);
  trid++;

  if(isdigit(args[0][0]))
  {
    msn_print_verbose_error(conn, atoi(args[0]));
    delete info;
    return;
  }

  sprintf(buf, "INF %d\r\n", trid, info->username);
  write(conn.sock, buf, strlen(buf));

  msn_add_callback(conn, msn_connect_4, trid, data);
}
*/
