/****************************************************************************
**
** $Id: cvsthread.h,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef CVSTHREAD_H_20010626
#define CVSTHREAD_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"

#include <stdio.h>
#include <pthread.h>

//----------------------------------------------------------------------------

#include <qstring.h>
#include <qstringlist.h>

//----------------------------------------------------------------------------

class CvsThread
{
public:
   CvsThread(QString command) 
      : 
      m_pCvs(0),
      m_command(command),
      m_isRunning(false) {
      	pthread_mutex_init(&m_mutex,0);
      	pthread_mutex_init(&m_condmutex,0);
      	pthread_cond_init(&m_conditional,0);
     }

   ~CvsThread() 
   {
      pthread_mutex_destroy(&m_mutex); 
      pthread_mutex_destroy(&m_condmutex); 
      pthread_cond_destroy(&m_conditional); 
      if(m_pCvs) pclose(m_pCvs);
   }
   
   void start();
   void kill();

   void setIsRunning() {m_isRunning = true;}
   void setIsFinished(){m_isRunning = false;}
   bool isFinished() {return !m_isRunning;}
   void waitTillFinished();

   QString& getCommand() {return m_command;}
   
   void mutexLock() {pthread_mutex_lock(&m_mutex);}
   void mutexUnlock() {pthread_mutex_unlock(&m_mutex);}

   QStringList m_outputQueue;
   
   FILE *m_pCvs;

protected:
   static void threadFunction(CvsThread *thread);

   QString m_command;
   bool m_isRunning;
   
   pthread_t m_thread;
   pthread_mutex_t m_mutex;
   static pthread_mutex_t m_condmutex;
   static pthread_cond_t m_conditional;
};

//----------------------------------------------------------------------------

#endif //DIRECTORY_H_20010626
