#!/usr/bin/perl -sw
##
## Makefile for Vipul's Razor v2.
##
## Copyright (c) 1998-2002
## This code is free software; you can redistribute it and/or modify
## it under the same terms as Perl itself.
##
## $Id: Makefile.PL,v 1.12 2002/07/25 20:00:03 vipul Exp $

use ExtUtils::MakeMaker;

WriteMakefile (

    NAME          => 'razor-agents',
    AUTHOR        => 'Vipul Ved Prakash <mail@vipul.net>',
    ABSTRACT      => 'Collaborative, content-based spam filtering network.',
    DISTNAME      => 'razor-agents', 
    NOECHO        => '',
    VERSION_FROM  => 'lib/Razor2/Client/Version.pm', 
    EXE_FILES     => [ qw( bin/razor-client ) ], 
    PREREQ_PM     => { 
                       'Net::Ping'        => 0, 
                       'Net::DNS'         => 0, 
                       'Time::HiRes'      => 0,
                       'Digest::SHA1'     => 0,  
                       'Getopt::Long'     => 0,
                       'File::Copy'       => 0,
                       'Digest::Nilsimsa' => 0,
                       'URI::Escape'      => 0,
                     },
	MAN1PODS      => { 
                       'docs/razor-check.pod'    => '$(INST_MAN1DIR)/razor-check.1',
					   'docs/razor-report.pod'   => '$(INST_MAN1DIR)/razor-report.1',
                       'docs/razor-admin.pod'    => '$(INST_MAN1DIR)/razor-admin.1',
                       'docs/razor-revoke.pod'   => '$(INST_MAN1DIR)/razor-revoke.1',
                     },
);


sub MY::constants {

    package MY;

    my $self = shift;
    my $inherited = $self->SUPER::constants(@_);

    my $man5pods = "MAN5PODS = docs/razor-agent.conf.pod \\\n" .
                   "	docs/razor-whitelist.pod\\\n".
                   "	docs/razor-agents.pod\n".
                   "";

    $inherited =~ s/^(HTMLEXT =)/$man5pods$1/gm;

    my $man5 = "INST_MAN5DIR = blib/man5\n" . 
               'INSTALLMAN5DIR = $(PREFIX)/man/man5' . "\n" . 
               "MAN5EXT = 5\n";

    $inherited =~ s/^(PERM_RW = )/$man5$1/gm;

    $inherited;

}


sub MY::top_targets {
 
    package MY;

    my $self = shift;
    my $inherited = $self->SUPER::top_targets(@_);

    my ($perlh) = $inherited =~ m"\$\(INST_MAN1DIR\)/\.exists :: (.*)";
 
    my $man5 = 'config :: $(INST_MAN5DIR)/.exists' . "\n"    . 
               '	@$(NOOP)' . "\n\n\n"                     . 
               '$(INST_MAN5DIR)/.exists :: ' . $perlh . "\n" . 
               '	@$(MKPATH) $(INST_MAN5DIR)' . "\n"       . 
               '	@$(EQUALIZE_TIMESTAMP) ' . $perlh . ' $(INST_MAN5DIR)/.exists' . "\n\n" . 
               '	-@$(CHMOD) $(PERM_RWX) $(INST_MAN5DIR)'  . "\n\n";
 
    $inherited =~ s/^(help:)/$man5$1/gm;
 
    $inherited;
 
}


sub MY::manifypods {

    package MY;
    my $self = shift;
    my $inherited = $self->SUPER::manifypods(@_);

    my $deps = " \\\n" .
               "	docs/razor-agent.conf.pod \\\n" . 
               "	docs/razor-agents.pod \\\n" . 
               "	docs/razor-whitelist.pod";
 
    $inherited =~ s/(\n\t\$\(POD2MAN\).*)$/$deps$1/gm;

    my $files = ' \\' . "\n" . 
                '	docs/razor-agent.conf.pod \\' . "\n" . 
                '	$(INST_MAN5DIR)/razor-agent.conf.$(MAN5EXT) \\' . "\n" .
                '	docs/razor-agents.pod \\' . "\n" . 
                '	$(INST_MAN5DIR)/razor-agents.$(MAN5EXT) \\' . "\n" .
                '	docs/razor-whitelist.pod \\' . "\n" . 
                '	$(INST_MAN5DIR)/razor-whitelist.$(MAN5EXT)';

    $inherited .= $files;

    $inherited;

}


sub MY::install {

  package MY;

  my $self = shift;
  my $inherited = $self->SUPER::install(@_);

  my $man5 = " \\\n" . 
             '		$(INST_MAN5DIR) $(INSTALLMAN5DIR)';
 
  $inherited =~ s/(\$\(INSTALLMAN1DIR\))/$1$man5/gm;
  $inherited =~ s/install :: all pure_install doc_install/install :: all pure_install doc_install install_razor_agents/;
  $inherited .= "\ninstall_razor_agents::\n\t " . '$(INST_SCRIPT)/razor-client'; 
  $inherited;

}

