/*
 *	Copyright (c) 1993-1997 JSC Rinet, Novosibirsk, Russia
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/* trafshow.h -- definitions and prototypes */

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#define	DEFAULT_SCR	5	/* screen refresh interval in seconds */
#define	DEFAULT_DNS	2	/* max timeout for gethostbyaddr() */
#define	SCR_OFFS	2	/* first show line on screen */
#define	MAX_PAGES	20	/* max pages on screen */
#define	DEFAULT_SNAPLEN	68	/* length of saved portion of packet */

#define	DEFAULT_COLS	80	/* full screen width */
#define	ADDR_SIZE	28	/* host..port size */
#define	PROTO_SIZE	4	/* protocol size */
#define	BYTES_SIZE	10	/* bytes size */
#define	CPS_SIZE	6	/* cps size */
#define	COUNT_SIZE	9	/* misc counters size */

/* Keyboard functions */
#define	ctrl(c)		((c) & 0x1F)
#define	ESC		'\033'
#define	CR		'\r'
#define	NL		'\n'
#define	BS		'\b'

#define	KEYMAP_UNKNOWN		0
#define	KEYMAP_UP		1
#define	KEYMAP_DOWN		2
#define	KEYMAP_LEFT		3
#define	KEYMAP_RIGHT		4
#define	KEYMAP_PAGE_UP		5
#define	KEYMAP_PAGE_DOWN	6
#define	KEYMAP_HOME		7
#define	KEYMAP_END		8
#define	KEYMAP_INS		9
#define	KEYMAP_F1		10
#define	KEYMAP_F2		11
#define	KEYMAP_F3		12
#define	KEYMAP_F4		13


#ifndef	IPPROTO_OSPF
#define	IPPROTO_OSPF	89
#endif

#ifndef	IPPROTO_IGMP
#define	IPPROTO_IGMP	2
#endif

#ifndef	DLT_C_HDLC
#define	DLT_C_HDLC	12	/* Cisco HDLC data-link level type */
#endif

/* traffic entry */
struct t_entry {
	struct	ether_header eh;
	struct	in_addr	src;	/* source ip address */
	u_short	sport;		/* source port */
	struct	in_addr	dst;	/* destination ip address */
	u_short	dport;		/* destination port */
	u_short	proto;		/* ip protocol */
	u_long	bytes;		/* bytes in ip datagram */
	u_long	obytes;		/* old bytes */
	u_int	cps;		/* chars per second :-) */
};

/* mask entry */
struct m_entry {
	struct	in_addr src;	/* source ip address */
	struct	in_addr sm;	/* source ip address mask */
	u_short	sport;		/* source port */
	struct	in_addr dst;	/* destination ip address */
	struct	in_addr dm;	/* destination ip address mask */
	u_short	dport;		/* destination port */
	u_short	proto;		/* ip protocol */
	short	pair;		/* color-pair */
	int	attr;		/* video attributes; bold, blink, etc */
};

/* global variables */
extern char *program_name;
extern char *device_name;
extern unsigned char *snapend;
extern int curses_initialized;
extern int use_colors;
extern int alarm_flag;
extern int scr_interval;
extern int dns_timeout;
extern int n_entry;		/* counter for number of records */
extern int fflag;
extern int kflag;
extern int nflag;
extern int Nflag;
extern int eflag;
extern int page_size;
extern int resize_flag;
extern int addr_size;
extern int proto_size;
extern int bytes_size;
extern int cps_size;
extern int count_size;

/* function prototypes */

/* trafshow.c */
extern void cleanup(int);
extern void init_term(int);

/* display.c */
extern void init_display(int);
extern void header_line(void);
extern void status_line(int);
extern void scr_redraw(int);
extern void scr_update(void);
extern void display(/* struct ether_header *, struct ip *, int */);
extern int get_keyb(void);

/* keyb.c */
extern int kbhit(int);
extern int get_arrowkey(int (*f)());

/* color.c */
extern int init_colormask(void);
extern int color_on(struct t_entry *);

/* util.c */
#ifdef	__STDC__
extern void error(int, char *, ...);
#else
extern void error();
#endif
extern char *copy_argv(char **);
extern char *read_infile(char *);
extern char *getprotoname(u_short);
extern u_short getprotonum(char *);

/* addrtoname.c */
extern void init_addrtoname(u_int32_t, u_int32_t);
extern char *getname(u_char *);
extern char *intoa(u_int32_t);
extern char *tcpport_string(u_short);
extern char *udpport_string(u_short);
#define ipaddr_string(p) getname((u_char *)(p))
extern char *entoa(u_char *);
extern char *etheraddr_string(u_char *);
extern char *etherproto_string(u_short);

/* getarptab.c */
extern u_char *getarptab(u_char *);
