/*
 * prect.c -- $Id$
 * p_rect for MS Windows
 *
 * Copyright (c) 2001.  See accompanying LEGAL file for details.
 */

#include "playw.h"

/* Win9x does not support the Rectangle primitive in paths
 */

void
p_rect(p_win *w, int x0, int y0, int x1, int y1, int border)
{
  if (border) {
    HDC dc = w_getdc(w, 2);
    if (dc) {
      HBRUSH b = SelectObject(dc, GetStockObject(NULL_BRUSH));
      if (b) DeleteObject(b);
      w->color_set &= ~4;
      w->color_set |= 8;
      Rectangle(dc, x0, y0, x1+1, y1+1);
    }
  } else {
    HDC dc = w_getdc(w, 4);
    HBRUSH b = dc? GetCurrentObject(dc, OBJ_BRUSH) : 0;
    RECT r;
    r.left = x0;
    r.top = y0;
    r.right = x1;
    r.bottom = y1;
    if (b) FillRect(dc, &r, b);
  }
}
