/*
 * Copyright (C) 2000-2001 Peter J Jones (pjones@pmade.org)
 * All Rights Reserved
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
// standard includes
#include <string>
#include <iostream>

// local includes
#include "XML.hh"
#include "Generator.hh"
#include "Clo.hh"

// import std
using namespace std;

// It all starts here!
int main (int argc, char *argv[]) {
	Clo::Parser clo;

	try { // the parse will die for many reasons
		clo.parse(argc, argv);
	} catch (Clo::Exception ex) {
		if (ex.autohelp) {
			// user gave --help or -h
			cout << "Usage: " << argv[0] << " [options] xml-file" << endl;
			cout << ex.fancy();
			return 0;
		} else if (ex.autoversion) {
			// user gave --version or -v
			cout << "clo++ version " << VERSION << endl;
			cout << "Copyright 2000-2001 by Peter J Jones" << endl;
			return 0;
		} else {
			// user just screewed up the command line
			cerr << ex.fancy();
			return 1;
		}
	}

	// local copy of the list of files on the cl
	vector<string> &files = clo.get_file_list();

	// make sure that there is only one and atleast one
	if (files.size() != 1) {
		cerr << argv[0];
		cerr << ": you must give one XML file to parse" << endl;
		return 1;
	}

	// now some variables for makeing the code
	Generator generator;
	XML parser;

	parser.set_filename(files[0]);

	// try to parse the XML file
	try {
		parser.parse(generator);
	} catch (char *ex) {
		cerr << ex << endl;
		return 1;
	} catch (...) {
		cerr << "error parsing xml file" << endl;
		return 1;
	}

	// set some options from the command line
	if (clo.get_string_option("header-file").size())
		generator.set_filename(clo.get_string_option("header-file"));
	if (clo.get_string_option("code-file").size())
		generator.set_codefile(clo.get_string_option("code-file"));
	if (clo.get_string_option("namespace").size())
		generator.set_namespace(clo.get_string_option("namespace"));
	if (clo.get_string_option("class").size())
		generator.set_classname(clo.get_string_option("class"));

	// ok, generate the header file (and maybe a impl file)
	generator.generate();

	// we made it!
	return 0;
}
