#ifndef REPOS_FS_FSREPOS_H
#define REPOS_FS_FSREPOS_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* These are needed by both FileRepository.h and RCSRepository.h */

#define R_CERT_FILE     "server.pem"
#define R_KEY_FILE      "server.key"
#define R_MUTABLES      "mutables"

#define R_ENTDIR        "entities"
#define R_GZENTITIES    "entities/gz"
#define R_SXD2ENTITIES  "entities/sxd2"
#define R_FLATENTITIES  "entities/flat"

#define R_OLD_GZENTITIES    "entities.gz"
#define R_OLD_FLATENTITIES  "entities.flat"

#define R_SUBDIR        "SUBDIRS"
#define R_REVISIONS     "revisions"
#define R_LOCKFILE      "LOCK"
#define R_USERS         "users"
#define R_CONFIG        "config"
#define R_IDENTITY      "identity"
#define R_ADMIN_GROUP   "admin_group"
#define R_SELF          "self"
#define R_EVERYONE      "everyone"
#define R_STORETYPE     "store_type"
#define R_READONLY      "READ-ONLY"
#define R_USR_LINK      "usr"
#define R_USR_ACCESS    "access"
#define R_STALEREVS     "HIDDEN"
#define R_GCDIR         "GC"

/* FS_MAX_DIRSIZE must be greater than 64 to ensure that the leafmost
   directory does not underflow when using base64 encoded filenames. */
#define FS_MAX_DIRSIZE  100

#define XDCS_ARCHIVE_MAX (2 * 1024 * 1024)
#define XDCS_THRESH 400

extern Buffer *
flatfile_GetEntityBuffer(Repository *r, const char *mURI /* unused */,
	       const char *trueName);

extern void
flatfile_ReviseEntity(Repository *r,
		      const char *mURI,
		      const char *prevTrueName, void *s);

extern Buffer *
gzfile_GetEntityBuffer(Repository *r, const char *mURI /* unused */,
		       const char *trueName);

extern void
gzfile_ReviseEntity(Repository *r,
		    const char *mURI,
		    const char *prevTrueName, void *s);

extern Buffer *
sxd_GetEntityBuffer(Repository *r, const char *mURI /* unused */,
	      const char *trueName);

extern void
sxd_ReviseEntity(Repository *r,
		 const char *mURI,
		 const char *prevTrueName, void *s);

extern Buffer *
sxd2_GetEntityBuffer(Repository *r, const char *mURI /* unused */,
	      const char *trueName);

extern void
sxd2_ReviseEntity(Repository *r,
		 const char *mURI,
		 const char *prevTrueName, void *s);

extern const char *entity_remove_store_suffix(const char *frag);

extern OC_bool entity_frag_in_current_format(Repository *r, const char *frag);

extern void upgrade_from_pre_0_1_6(Repository *r);

extern void fsrepos_WriteRevision(Repository *r, Revision *rev, OC_bool overWrite);

extern void fsrepos_maybe_remove_dirtree(const char *top, const char *dirPath);

#endif /* REPOS_FS_FSREPOS_H */
