#ifndef COMMON_UTIL_H
#define COMMON_UTIL_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Thin wrapper so that if I intern names later I won't have to find
 * all of the calls to strcmp(): */
OC_bool validate_pet_name(const char *s);

char *xstrcat(const char *s1, const char *s2);
char *xstrdowncase(const char *);
char *xstrdup(const char *); /* X STR(ING) DUP(LICATE) */
char *xstrndup(const char *, int len);
char *xchardup(const char, size_t len);
char *xunsigned_str(uint32_t);
char *xunsigned64_str(uint64_t);
uint64_t atollu(const char *);
OC_bool nmequal(const char *s1, const char *s2);
size_t xprintf(const char *fmt, ...);

extern int xassert_fail(const char * expr, const char *file, unsigned line);
#define xassert(x) ((void) ((x) ? 0 : xassert_fail(#x, __FILE__, __LINE__)))

void* xbsearch(const void *key, const void *base, size_t nmemb,
               size_t size, int (*compar)(const void *, const void *));

extern const char * strnchr(const char *s, size_t len, char c);


#endif /* COMMON_UTIL_H */
