/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

OC_bool
revision_check(const void *v)
{
  return TRUE;
}

void
revision_show(const void *vp)
{
  const Revision *r = vp;
  
  report(0, "mutURI:     %s\n", r->mutURI);
  report(0, "Seq Num:    0x%08x%08x\n", (uint32_t) (r->seq_number >> 32),
                                      (uint32_t) (r->seq_number));
  report(0, "ReviseTime: %s\n", r->reviseTime);
  report(0, "Revisor:    %s\n", r->revisor);
  report(0, "NewObject:  %s\n", r->newObject);

  report(0, "Signature:  %s\n", r->signature);
}

void
revision_serialize(SDR_stream *strm, const void *vp)
{
  const Revision *r = vp;

  sdr_w_obname("mutURI", strm, r->mutURI);
  sdr_w_u64("seqnum", strm, r->seq_number);
  sdr_w_obname("reviseTime", strm, r->reviseTime);
  sdr_w_obname("revisor", strm, r->revisor);
  sdr_w_obname("newObject", strm, r->newObject);
  sdr_w_obname("signature", strm, r->signature);
}

void *
revision_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  Revision *r = (Revision *) GC_MALLOC(sizeof(Revision));

  ser_init(r, &Revision_SerType, di->ver);
  
  r->mutURI         = sdr_r_obname("mutURI", strm);
  r->seq_number     = sdr_r_u64("seqnum", strm);
  r->reviseTime     = sdr_r_obname("reviseTime", strm);
  r->revisor        = sdr_r_obname("revisor", strm);
  r->newObject      = sdr_r_obname("newObject", strm);
  r->signature      = sdr_r_obname("signature", strm);

  SER_MODIFIED(r);
  return r;
}

void
revision_mark(Repository *r, const void *container,
	      const void *ob, rbtree *memObs)
{
  const Revision *rev = ob;

  assert(container == ob);

  mark_addmark(container, memObs, rev->mutURI);
  mark_addmark(container, memObs, rev->revisor);
  mark_addmark(container, memObs, rev->newObject);
}

Revision *
revision_create(const char *mutURI, const char *userName,
		const char *trueName)
{
  Revision *r = (Revision *)GC_MALLOC(sizeof(Revision));

  ser_init(r, &Revision_SerType, Revision_SerType.ver);

  r->mutURI = mutURI;

  r->seq_number = 0llu;
  r->reviseTime = os_GetISOTime();
  r->revisor = userName;
  r->newObject = trueName;
  r->signature = 0;

  SER_MODIFIED(r);
  return r;
}

