#ifndef COMMON_MUTABLE_H
#define COMMON_MUTABLE_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Mutable flags
 * 
 * MUT_FROZEN cannot be cleared by SetMutableFlags(),
 *
 * MUT_DUP_ACLS is a pseudo-flag: it is never actually recorded in the
 * mutable at all, and I begin to think that it should be a separate
 * option to the DupMutable() call. */
#define MF_FROZEN     0x00000001u
#define MF_NOTRAIL    0x00000002u
#define MF_DUP_ACLS   0x80000000u

struct Mutable {
  Serializable ser;
  
  const char *uri;

  /* The sequence number may be larger than the revision number of the
   * revision named by state, because the seqNo is updated whenever
   * ACLs and other fields change. Effectively, the seqNo counts the
   * number of times this mutable has been signed and saved */
  uint64_t seqNo;
  uint64_t nRevisions;

  const char *name;             /* one-line synopsis of description */
  const char *description;      /* full text description of this mutable */
  const char *modGroupURI;	/* group or user that can modify */
  const char *readGroupURI;	/* group or user that can read */
  const char *notify;           /* who gets notified when mutable is modified */

  const char *signature;	/* server signature of preceding plus
				 * mutable's true name */

  uint32_t flags;		/* mutable flags */

  /* Items from here down are NOT serialized: */
  OC_bool modified;
};

Mutable *mutable_create(const char *name, const char *desc);
OC_bool mutable_VerifySignature(Mutable *m);

#endif /* COMMON_MUTABLE_H */
