#ifndef CLIENT_BROWSE_BROWSECONFIG_H
#define CLIENT_BROWSE_BROWSECONFIG_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

void html_output_init(void);
void do_html_output(SDR_stream *strm, const char *s, unsigned len);
void html_begin(SDR_stream *strm, const char *s);
void html_end(SDR_stream *strm, const char *s);

#define begin_comment "<font color=\"red\"><em class=\"comment\">"
#define end_comment "</em></font>"
#define begin_kwd "<font color=\"blue\" class=\"kwd\">"
#define end_kwd "</font>"
#define begin_tkwd "<font color=\"blue\" class=\"tkwd\">"
#define end_tkwd "</font>"
#define begin_type "<b class=\"type\">"
#define end_type "</b>"
#define begin_macro "<b class=\"macro\">"
#define end_macro "</b>"
#define begin_func "<b class=\"func\">"
#define end_func "</b>"
#define begin_string "<font color=\"green\" class=\"string\">"
#define end_string "</font>"
#define begin_incfile "<font color=\"green\" class=\"incfile\">"
#define end_incfile "</font>"
#define begin_preproc "<b class=\"preproc\">"
#define end_preproc "</b>"

#endif /* CLIENT_BROWSE_BROWSECONFIG_H */
