/* valamethodtype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAMETHODTYPE_H__
#define __VALA_VALAMETHODTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valamethod.h>

G_BEGIN_DECLS


#define VALA_TYPE_METHOD_TYPE (vala_method_type_get_type ())
#define VALA_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodType))
#define VALA_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))
#define VALA_IS_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_TYPE))
#define VALA_IS_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_TYPE))
#define VALA_METHOD_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))

typedef struct _ValaMethodType ValaMethodType;
typedef struct _ValaMethodTypeClass ValaMethodTypeClass;
typedef struct _ValaMethodTypePrivate ValaMethodTypePrivate;

/**
 * The type of a method referencea.
 */
struct _ValaMethodType {
	ValaDataType parent_instance;
	ValaMethodTypePrivate * priv;
};

struct _ValaMethodTypeClass {
	ValaDataTypeClass parent_class;
};


ValaMethodType* vala_method_type_new (ValaMethod* method_symbol);
ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self);
void vala_method_type_set_method_symbol (ValaMethodType* self, ValaMethod* value);
GType vala_method_type_get_type (void);


G_END_DECLS

#endif
