/* valadynamicmethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicmethod.h>
#include <gee/readonlycollection.h>
#include <vala/valadatatype.h>
#include <vala/valainvocationexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacodegenerator.h>




struct _ValaDynamicMethodPrivate {
	ValaDataType* _dynamic_type;
	ValaInvocationExpression* _invocation;
	char* cname;
};

#define VALA_DYNAMIC_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodPrivate))
enum  {
	VALA_DYNAMIC_METHOD_DUMMY_PROPERTY,
	VALA_DYNAMIC_METHOD_DYNAMIC_TYPE,
	VALA_DYNAMIC_METHOD_INVOCATION
};
static gint vala_dynamic_method_dynamic_method_id;
static GeeCollection* vala_dynamic_method_real_get_cheader_filenames (ValaSymbol* base);
static char* vala_dynamic_method_real_get_default_cname (ValaMethod* base);
static ValaCodeBinding* vala_dynamic_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static gpointer vala_dynamic_method_parent_class = NULL;
static void vala_dynamic_method_dispose (GObject * obj);



ValaDynamicMethod* vala_dynamic_method_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDynamicMethod * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (dynamic_type), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_DYNAMIC_METHOD, 0, NULL);
	vala_dynamic_method_set_dynamic_type (self, dynamic_type);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_method_set_return_type (VALA_METHOD (self), return_type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static GeeCollection* vala_dynamic_method_real_get_cheader_filenames (ValaSymbol* base) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (base);
	return GEE_COLLECTION (gee_read_only_collection_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, NULL));
}


static char* vala_dynamic_method_real_get_default_cname (ValaMethod* base) {
	ValaDynamicMethod * self;
	const char* _tmp1;
	self = VALA_DYNAMIC_METHOD (base);
	/* return cname of wrapper method*/
	if (self->priv->cname == NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		self->priv->cname = (_tmp0 = g_strdup_printf ("_dynamic_%s%d", vala_symbol_get_name (VALA_SYMBOL (self)), vala_dynamic_method_dynamic_method_id++), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = self->priv->cname, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
}


static ValaCodeBinding* vala_dynamic_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_dynamic_method_binding (codegen, self);
}


ValaDataType* vala_dynamic_method_get_dynamic_type (ValaDynamicMethod* self) {
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (self), NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_method_set_dynamic_type (ValaDynamicMethod* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_DYNAMIC_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL))), _tmp2);
}


ValaInvocationExpression* vala_dynamic_method_get_invocation (ValaDynamicMethod* self) {
	g_return_val_if_fail (VALA_IS_DYNAMIC_METHOD (self), NULL);
	return self->priv->_invocation;
}


void vala_dynamic_method_set_invocation (ValaDynamicMethod* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_DYNAMIC_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_invocation == NULL ? NULL : (self->priv->_invocation = (g_object_unref (self->priv->_invocation), NULL))), _tmp2);
}


static void vala_dynamic_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (object);
	switch (property_id) {
		case VALA_DYNAMIC_METHOD_DYNAMIC_TYPE:
		g_value_set_object (value, vala_dynamic_method_get_dynamic_type (self));
		break;
		case VALA_DYNAMIC_METHOD_INVOCATION:
		g_value_set_object (value, vala_dynamic_method_get_invocation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (object);
	switch (property_id) {
		case VALA_DYNAMIC_METHOD_DYNAMIC_TYPE:
		vala_dynamic_method_set_dynamic_type (self, g_value_get_object (value));
		break;
		case VALA_DYNAMIC_METHOD_INVOCATION:
		vala_dynamic_method_set_invocation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_method_class_init (ValaDynamicMethodClass * klass) {
	vala_dynamic_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDynamicMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_dynamic_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_dynamic_method_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_dynamic_method_dispose;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_dynamic_method_real_get_cheader_filenames;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_dynamic_method_real_get_default_cname;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_dynamic_method_real_create_code_binding;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DYNAMIC_METHOD_DYNAMIC_TYPE, g_param_spec_object ("dynamic-type", "dynamic-type", "dynamic-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DYNAMIC_METHOD_INVOCATION, g_param_spec_object ("invocation", "invocation", "invocation", VALA_TYPE_INVOCATION_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_dynamic_method_init (ValaDynamicMethod * self) {
	self->priv = VALA_DYNAMIC_METHOD_GET_PRIVATE (self);
}


static void vala_dynamic_method_dispose (GObject * obj) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (obj);
	(self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL)));
	(self->priv->_invocation == NULL ? NULL : (self->priv->_invocation = (g_object_unref (self->priv->_invocation), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	G_OBJECT_CLASS (vala_dynamic_method_parent_class)->dispose (obj);
}


GType vala_dynamic_method_get_type (void) {
	static GType vala_dynamic_method_type_id = 0;
	if (G_UNLIKELY (vala_dynamic_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicMethod), 0, (GInstanceInitFunc) vala_dynamic_method_init };
		vala_dynamic_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaDynamicMethod", &g_define_type_info, 0);
	}
	return vala_dynamic_method_type_id;
}




