/* valaccodedynamicsignalbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodedynamicsignalbinding.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <vala/valadatatype.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaarraytype.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeDynamicSignalBindingPrivate {
	ValaSignal* _node;
	char* connect_wrapper_name;
	char* disconnect_wrapper_name;
};

#define VALA_CCODE_DYNAMIC_SIGNAL_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, ValaCCodeDynamicSignalBindingPrivate))
enum  {
	VALA_CCODE_DYNAMIC_SIGNAL_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_DYNAMIC_SIGNAL_BINDING_NODE
};
static gint vala_ccode_dynamic_signal_binding_signal_wrapper_id;
static void vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block);
static void vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block);
static gpointer vala_ccode_dynamic_signal_binding_parent_class = NULL;
static void vala_ccode_dynamic_signal_binding_dispose (GObject * obj);



ValaCCodeDynamicSignalBinding* vala_ccode_dynamic_signal_binding_new (ValaCCodeGenerator* codegen, ValaDynamicSignal* node) {
	ValaCCodeDynamicSignalBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_DYNAMIC_SIGNAL (node), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_DYNAMIC_SIGNAL_BINDING, 0, NULL);
	vala_ccode_dynamic_signal_binding_set_node (self, VALA_SIGNAL (node));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


char* vala_ccode_dynamic_signal_binding_get_connect_wrapper_name (ValaCCodeDynamicSignalBinding* self) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	const char* _tmp9;
	char* _tmp10;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (self->priv->connect_wrapper_name == NULL) {
		char* _tmp1;
		ValaCCodeFunction* func;
		ValaCCodeFormalParameter* _tmp2;
		ValaCCodeFormalParameter* _tmp3;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeBlock* block;
		ValaCCodeFunction* _tmp8;
		_tmp1 = NULL;
		self->priv->connect_wrapper_name = (_tmp1 = g_strdup_printf ("_dynamic_%s%d_connect", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_signal_binding_signal_wrapper_id++), (self->priv->connect_wrapper_name = (g_free (self->priv->connect_wrapper_name), NULL)), _tmp1);
		func = vala_ccode_function_new (self->priv->connect_wrapper_name, "void");
		_tmp2 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp2 = vala_ccode_formal_parameter_new ("obj", "gpointer")));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		_tmp3 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp3 = vala_ccode_formal_parameter_new ("signal_name", "const char *")));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("handler", "GCallback")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("data", "gpointer")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		block = vala_ccode_block_new ();
		if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
			vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (self, block);
		} else {
			char* _tmp7;
			char* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp7 = g_strdup_printf ("dynamic signals are not supported for `%s'", (_tmp6 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_signal_get_dynamic_type (dynamic_signal)))))));
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp6 = (g_free (_tmp6), NULL);
		}
		/* append to C source file*/
		_tmp8 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp8 = vala_ccode_function_copy (func))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		vala_ccode_function_set_block (func, block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
		(func == NULL ? NULL : (func = (g_object_unref (func), NULL)));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	return (_tmp10 = (_tmp9 = self->priv->connect_wrapper_name, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL))), _tmp10);
}


char* vala_ccode_dynamic_signal_binding_get_disconnect_wrapper_name (ValaCCodeDynamicSignalBinding* self) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	const char* _tmp9;
	char* _tmp10;
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (self->priv->disconnect_wrapper_name == NULL) {
		char* _tmp1;
		ValaCCodeFunction* func;
		ValaCCodeFormalParameter* _tmp2;
		ValaCCodeFormalParameter* _tmp3;
		ValaCCodeFormalParameter* _tmp4;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeBlock* block;
		ValaCCodeFunction* _tmp8;
		_tmp1 = NULL;
		self->priv->disconnect_wrapper_name = (_tmp1 = g_strdup_printf ("_dynamic_%s%d_disconnect", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node)), vala_ccode_dynamic_signal_binding_signal_wrapper_id++), (self->priv->disconnect_wrapper_name = (g_free (self->priv->disconnect_wrapper_name), NULL)), _tmp1);
		func = vala_ccode_function_new (self->priv->disconnect_wrapper_name, "void");
		_tmp2 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp2 = vala_ccode_formal_parameter_new ("obj", "gpointer")));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		_tmp3 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp3 = vala_ccode_formal_parameter_new ("signal_name", "const char *")));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp4 = vala_ccode_formal_parameter_new ("handler", "GCallback")));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp5 = vala_ccode_formal_parameter_new ("data", "gpointer")));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		block = vala_ccode_block_new ();
		if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (dynamic_signal)) == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_object_type) {
			vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (self, block);
		} else {
			char* _tmp7;
			char* _tmp6;
			_tmp7 = NULL;
			_tmp6 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_node)), (_tmp7 = g_strdup_printf ("dynamic signals are not supported for `%s'", (_tmp6 = vala_code_node_to_string (VALA_CODE_NODE (vala_dynamic_signal_get_dynamic_type (dynamic_signal)))))));
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp6 = (g_free (_tmp6), NULL);
		}
		/* append to C source file*/
		_tmp8 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp8 = vala_ccode_function_copy (func))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		vala_ccode_function_set_block (func, block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (func));
		(func == NULL ? NULL : (func = (g_object_unref (func), NULL)));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	return (_tmp10 = (_tmp9 = self->priv->disconnect_wrapper_name, (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL))), _tmp10);
}


static void vala_ccode_dynamic_signal_binding_generate_dbus_connect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	ValaMethod* _tmp1;
	ValaMethod* m;
	gboolean first;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* register_call;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	GeeList* _tmp5;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* add_call;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeConstant* _tmp13;
	char* _tmp12;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp30;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeConstant* _tmp38;
	ValaCCodeExpressionStatement* _tmp39;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (dynamic_signal))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	first = TRUE;
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				ValaFormalParameter* _tmp2;
				if (first) {
					/* skip sender parameter*/
					first = FALSE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					continue;
				}
				_tmp2 = NULL;
				vala_signal_add_parameter (self->priv->_node, (_tmp2 = vala_formal_parameter_copy (param)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_node), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* FIXME should only be done once per marshaller*/
	_tmp3 = NULL;
	_tmp4 = NULL;
	register_call = (_tmp4 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("dbus_g_object_register_marshaller")))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp4);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_COLLECTION ((_tmp5 = vala_signal_get_parameters (self->priv->_node))), vala_signal_get_return_type (self->priv->_node), NULL))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	_tmp10 = NULL;
	add_call = (_tmp10 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("dbus_g_proxy_add_signal")))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp10);
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("obj"))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (self->priv->_node))))))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	_tmp12 = (g_free (_tmp12), NULL);
	first = TRUE;
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_method_get_parameters (m);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) gee_iterator_get (param_it));
			{
				if (first) {
					/* skip sender parameter*/
					first = FALSE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					continue;
				}
				if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)) && vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param))))) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
					ValaArrayType* _tmp14;
					ValaArrayType* array_type;
					char* _tmp15;
					gboolean _tmp16;
					ValaCCodeIdentifier* _tmp17;
					ValaCCodeFunctionCall* _tmp18;
					ValaCCodeFunctionCall* carray_type;
					ValaCCodeConstant* _tmp19;
					ValaCCodeIdentifier* _tmp21;
					char* _tmp20;
					_tmp14 = NULL;
					array_type = (_tmp14 = VALA_ARRAY_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14)));
					_tmp15 = NULL;
					if ((_tmp16 = (_tmp15 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)))) == NULL, (_tmp15 = (g_free (_tmp15), NULL)), _tmp16)) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter type for D-Bus signals");
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
						(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
						(dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL)));
						(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
						(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
						(add_call == NULL ? NULL : (add_call = (g_object_unref (add_call), NULL)));
						return;
					}
					_tmp17 = NULL;
					_tmp18 = NULL;
					carray_type = (_tmp18 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
					_tmp19 = NULL;
					vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("\"GArray\""))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
					_tmp21 = NULL;
					_tmp20 = NULL;
					vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type))))))));
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					_tmp20 = (g_free (_tmp20), NULL);
					vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION (carray_type));
					vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION (carray_type));
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
					(carray_type == NULL ? NULL : (carray_type = (g_object_unref (carray_type), NULL)));
				} else {
					char* _tmp22;
					gboolean _tmp23;
					ValaCCodeIdentifier* _tmp25;
					char* _tmp24;
					ValaCCodeIdentifier* _tmp27;
					char* _tmp26;
					_tmp22 = NULL;
					if ((_tmp23 = (_tmp22 = vala_data_type_get_type_id (vala_formal_parameter_get_type_reference (param))) == NULL, (_tmp22 = (g_free (_tmp22), NULL)), _tmp23)) {
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter type for D-Bus signals");
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
						(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
						(dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL)));
						(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
						(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
						(add_call == NULL ? NULL : (add_call = (g_object_unref (add_call), NULL)));
						return;
					}
					_tmp25 = NULL;
					_tmp24 = NULL;
					vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_data_type_get_type_id (vala_formal_parameter_get_type_reference (param)))))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					_tmp24 = (g_free (_tmp24), NULL);
					_tmp27 = NULL;
					_tmp26 = NULL;
					vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_data_type_get_type_id (vala_formal_parameter_get_type_reference (param)))))));
					(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
					_tmp26 = (g_free (_tmp26), NULL);
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (add_call, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp30 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp31 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp31 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (add_call)))));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	_tmp32 = NULL;
	_tmp33 = NULL;
	call = (_tmp33 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("dbus_g_proxy_connect_signal")))), (_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL))), _tmp33);
	_tmp34 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("obj"))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ("signal_name"))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("handler"))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("data"))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_constant_new ("NULL"))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp39 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp39 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	(dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
	(add_call == NULL ? NULL : (add_call = (g_object_unref (add_call), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


static void vala_ccode_dynamic_signal_binding_generate_dbus_disconnect_wrapper (ValaCCodeDynamicSignalBinding* self, ValaCCodeBlock* block) {
	ValaDynamicSignal* _tmp0;
	ValaDynamicSignal* dynamic_signal;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeExpressionStatement* _tmp7;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (block));
	_tmp0 = NULL;
	dynamic_signal = (_tmp0 = VALA_DYNAMIC_SIGNAL (self->priv->_node), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	call = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("dbus_g_proxy_disconnect_signal")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("obj"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("signal_name"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("handler"))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("data"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (call)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	(dynamic_signal == NULL ? NULL : (dynamic_signal = (g_object_unref (dynamic_signal), NULL)));
	(call == NULL ? NULL : (call = (g_object_unref (call), NULL)));
}


ValaSignal* vala_ccode_dynamic_signal_binding_get_node (ValaCCodeDynamicSignalBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self), NULL);
	return self->priv->_node;
}


void vala_ccode_dynamic_signal_binding_set_node (ValaCCodeDynamicSignalBinding* self, ValaSignal* value) {
	ValaSignal* _tmp2;
	ValaSignal* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DYNAMIC_SIGNAL_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_node = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL))), _tmp2);
}


static void vala_ccode_dynamic_signal_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicSignalBinding * self;
	self = VALA_CCODE_DYNAMIC_SIGNAL_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_SIGNAL_BINDING_NODE:
		g_value_set_object (value, vala_ccode_dynamic_signal_binding_get_node (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_signal_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeDynamicSignalBinding * self;
	self = VALA_CCODE_DYNAMIC_SIGNAL_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_DYNAMIC_SIGNAL_BINDING_NODE:
		vala_ccode_dynamic_signal_binding_set_node (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_dynamic_signal_binding_class_init (ValaCCodeDynamicSignalBindingClass * klass) {
	vala_ccode_dynamic_signal_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDynamicSignalBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_dynamic_signal_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_dynamic_signal_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_dynamic_signal_binding_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DYNAMIC_SIGNAL_BINDING_NODE, g_param_spec_object ("node", "node", "node", VALA_TYPE_SIGNAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_dynamic_signal_binding_init (ValaCCodeDynamicSignalBinding * self) {
	self->priv = VALA_CCODE_DYNAMIC_SIGNAL_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_dynamic_signal_binding_dispose (GObject * obj) {
	ValaCCodeDynamicSignalBinding * self;
	self = VALA_CCODE_DYNAMIC_SIGNAL_BINDING (obj);
	(self->priv->_node == NULL ? NULL : (self->priv->_node = (g_object_unref (self->priv->_node), NULL)));
	self->priv->connect_wrapper_name = (g_free (self->priv->connect_wrapper_name), NULL);
	self->priv->disconnect_wrapper_name = (g_free (self->priv->disconnect_wrapper_name), NULL);
	G_OBJECT_CLASS (vala_ccode_dynamic_signal_binding_parent_class)->dispose (obj);
}


GType vala_ccode_dynamic_signal_binding_get_type (void) {
	static GType vala_ccode_dynamic_signal_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_dynamic_signal_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDynamicSignalBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_dynamic_signal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDynamicSignalBinding), 0, (GInstanceInitFunc) vala_ccode_dynamic_signal_binding_init };
		vala_ccode_dynamic_signal_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeDynamicSignalBinding", &g_define_type_info, 0);
	}
	return vala_ccode_dynamic_signal_binding_type_id;
}




