/* valaccodecasestatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodecasestatement.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeCaseStatementPrivate {
	ValaCCodeExpression* _expression;
	GeeList* statements;
};

#define VALA_CCODE_CASE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementPrivate))
enum  {
	VALA_CCODE_CASE_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_CASE_STATEMENT_EXPRESSION
};
static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_case_statement_parent_class = NULL;
static void vala_ccode_case_statement_dispose (GObject * obj);



ValaCCodeCaseStatement* vala_ccode_case_statement_new (ValaCCodeExpression* expression) {
	ValaCCodeCaseStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_CASE_STATEMENT, 0, NULL);
	vala_ccode_case_statement_set_expression (self, expression);
	return self;
}


/**
 * Append the specified statement to this switch section.
 *
 * @param stmt a statement
 */
void vala_ccode_case_statement_add_statement (ValaCCodeCaseStatement* self, ValaCCodeStatement* stmt) {
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_STATEMENT (stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->statements), stmt);
}


static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "case ");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_expression), writer);
	vala_ccode_writer_write_string (writer, ":");
	vala_ccode_writer_write_newline (writer);
	{
		GeeList* stmt_collection;
		GeeIterator* stmt_it;
		stmt_collection = self->priv->statements;
		stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
		while (gee_iterator_next (stmt_it)) {
			ValaCCodeStatement* stmt;
			stmt = ((ValaCCodeStatement*) gee_iterator_get (stmt_it));
			{
				vala_ccode_node_write (VALA_CCODE_NODE (stmt), writer);
				(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
			}
		}
		(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
	}
}


ValaCCodeExpression* vala_ccode_case_statement_get_expression (ValaCCodeCaseStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_case_statement_set_expression (ValaCCodeCaseStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), _tmp2);
}


static void vala_ccode_case_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_CASE_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_ccode_case_statement_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_case_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_CASE_STATEMENT_EXPRESSION:
		vala_ccode_case_statement_set_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_case_statement_class_init (ValaCCodeCaseStatementClass * klass) {
	vala_ccode_case_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCaseStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_case_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_case_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_case_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_case_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CASE_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "expression", "expression", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_case_statement_init (ValaCCodeCaseStatement * self) {
	self->priv = VALA_CCODE_CASE_STATEMENT_GET_PRIVATE (self);
	self->priv->statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_STATEMENT, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_ccode_case_statement_dispose (GObject * obj) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	(self->priv->statements == NULL ? NULL : (self->priv->statements = (g_object_unref (self->priv->statements), NULL)));
	G_OBJECT_CLASS (vala_ccode_case_statement_parent_class)->dispose (obj);
}


GType vala_ccode_case_statement_get_type (void) {
	static GType vala_ccode_case_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_case_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCaseStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_case_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCaseStatement), 0, (GInstanceInitFunc) vala_ccode_case_statement_init };
		vala_ccode_case_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeCaseStatement", &g_define_type_info, 0);
	}
	return vala_ccode_case_statement_type_id;
}




