static const char rcsid[] = "$Id: log.c,v 1.17 1999/11/03 19:21:24 jurekb Exp $";
/*
 *  Solid POP3 - a POP3 server
 *  Copyright (C) 1999  Jerzy Balamut <jurekb@dione.ids.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
/* Code from this file sometimes works with root privileges */

#include "includes.h"
#include <syslog.h>
#include <errno.h>
#include "log.h"

int pop_debug = 0;

void pop_openlog(void) {
	openlog(POP_IDENT, LOG_PID, POP_FACILITY);
};

void pop_closelog() {
	closelog();
};

void pop_log(int priority, const char *format, ...) {
	char tmp[1536];
	va_list lst;

	va_start(lst, format);
	vsnprintf(tmp, sizeof(tmp), format, lst);
	va_end(lst);
	syslog(priority, "%s", tmp);
};

void pop_log_dbg(int priority, const char *format, ...) {
	char tmp[1536];
	va_list lst;

	if (!pop_debug)
		return;
	va_start(lst, format);
	vsnprintf(tmp, sizeof(tmp), format, lst);
	va_end(lst);
	syslog(priority, "%s", tmp);
};


void pop_error(const char *name) {
	pop_log(POP_PRIORITY, "%.200s: %.200s", name, strerror(errno));
};

void pop_error_dbg(const char *name) {
	if (pop_debug)
		pop_error(name);
};
