/***************************************************************************
                          setupdlg.h  -  The KountDown setup dialog
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETUPDLG_H
#define SETUPDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

typedef unsigned long ULONG;

class QFont;
class QDateTime;
class SetupStart;
class SetupHalf;
class SetupFinish;

/**
  *@author Erik Johansson
  */

class SetupDlg : public KDialogBase
{
   Q_OBJECT
	
	public:
		SetupDlg();
		~SetupDlg();
	
	protected slots:
		void slotOk();
		void slotApply();
		void slotDefault();
		void slotFont();
	
	private:
		void readSettings();
		enum NAME { YEARS, MONTHS, WEEKS, DAYS, HOURS, MINS, SECS };
		QDateTime calcHalfTime( const QDateTime, const ULONG, const ULONG, const ULONG, const ULONG, const ULONG, const ULONG, const ULONG );
		void calcHalfTime( const QDateTime, const QDateTime, ULONG &, ULONG &, ULONG &, ULONG &, ULONG &, ULONG &, ULONG & );
		int calcFormat( bool, bool, bool, bool, bool, bool, bool );
		bool calcFormat( int &, NAME );
		QFont font[3];
		bool closeDialog;
		SetupStart *start;
		SetupHalf *half;
		SetupFinish *finish;	
};

#endif
